/*
 * Decompiled with CFR 0.152.
 */
package rcon.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import rcon.Scheduler;
import rcon.commands.ClientRequest;
import rcon.commands.Command;
import rcon.commands.KickCommand;
import rcon.commands.PunkBusterCommand;
import rcon.commands.SayCommand;
import rcon.event.RCONEventHandler;
import rcon.ingame.ServerMessages;
import rcon.map.Map;
import rcon.players.Player;
import rcon.players.PlayerInfo;
import rcon.server.ConfigSynchronizer;
import rcon.server.Configuration;
import rcon.server.EventParser;
import rcon.server.HeartbeatChecker;
import rcon.server.OnlineList;
import rcon.server.PlayerUpdater;
import rcon.server.ServerConnection;
import rcon.server.ServerMessenger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameServer {
    private static final int PLAYER_TIMEOUT = 60000;
    static Logger logger = Logger.getLogger(GameServer.class);
    private final String host;
    private final int port;
    private String serverName;
    private int maxPlayerCount;
    private String gameMode;
    private String map;
    private int roundsPlayed;
    private int roundsTotal;
    private long connectionTime;
    private final OnlineList online;
    private final Configuration config;
    private ServerMessages serverMessages;
    private final ServerConnection connection;
    private EventParser events;
    private HeartbeatChecker heartbeats;
    private PlayerUpdater playerUpdater;
    private ServerMessenger serverMessenger;
    private ConfigSynchronizer configSynchronizer;

    public GameServer(String host, int port, int timeout, String configFile) throws IOException {
        this.host = host;
        this.port = port;
        this.online = new OnlineList();
        this.config = new Configuration();
        this.config.load(configFile);
        this.connection = new ServerConnection(timeout);
        this.heartbeats = null;
        this.events = null;
        this.playerUpdater = null;
        this.serverMessenger = null;
        this.serverMessages = new ServerMessages();
        this.serverName = "Unknown";
        this.maxPlayerCount = 0;
        this.gameMode = "Unknown";
        this.map = "Unknown";
        this.roundsPlayed = 0;
        this.roundsTotal = 0;
        this.configSynchronizer = null;
        this.connection.start(host, port);
        this.connectionTime = -1L;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public OnlineList getOnline() {
        return this.online;
    }

    public synchronized ServerMessages getServerMessages() {
        return this.serverMessages;
    }

    public synchronized Configuration getConfiguration() {
        return this.config;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getMaxPlayerCount() {
        return this.maxPlayerCount;
    }

    public String getGameMode() {
        return this.gameMode;
    }

    public String getMap() {
        return this.map;
    }

    public int getRoundsPlayed() {
        return this.roundsPlayed;
    }

    public int getRoundsTotal() {
        return this.roundsTotal;
    }

    public void awaitDisconnect() {
        this.connection.awaitShutdown();
        if (this.events != null) {
            try {
                this.events.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void connectionLost() {
        if (this.events != null) {
            this.connection.addEvent(Command.EOF);
            try {
                this.events.join(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.events = null;
        }
        if (this.heartbeats != null) {
            this.disableHeartbeats();
        }
        if (this.playerUpdater != null) {
            this.disablePlayerUpdates();
        }
        if (this.serverMessenger != null) {
            this.disableServerMessenger();
        }
        if (this.configSynchronizer != null) {
            this.configSynchronizer.stop();
            this.configSynchronizer = null;
        }
        this.connection.stop();
    }

    public synchronized void stop() {
        if (this.events != null) {
            this.disableEvents();
        }
        if (this.heartbeats != null) {
            this.disableHeartbeats();
        }
        if (this.playerUpdater != null) {
            this.disablePlayerUpdates();
        }
        if (this.serverMessenger != null) {
            this.disableServerMessenger();
        }
        if (this.configSynchronizer != null) {
            this.configSynchronizer.stop();
            this.configSynchronizer = null;
        }
        this.logout();
        try {
            this.connection.quit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.connection.stop();
    }

    public synchronized boolean login(String password) {
        try {
            boolean res = this.connection.login(password);
            if (res) {
                this.connectionTime = Calendar.getInstance().getTimeInMillis() / 1000L;
                this.onConnect();
            }
            return res;
        }
        catch (IOException e) {
            this.connectionLost();
            return false;
        }
    }

    private void onConnect() {
        this.configSynchronizer = new ConfigSynchronizer(this);
        this.configSynchronizer.run();
        Scheduler.getInstance().repeat(this.configSynchronizer, 180000);
    }

    public synchronized boolean enableEvents() {
        if (this.events != null) {
            throw new IllegalStateException("Event handling alreqady enabled.");
        }
        try {
            Command response = this.request("admin.eventsEnabled", "true");
            if (response.is("OK")) {
                this.events = new EventParser(this.online, this.connection);
                this.events.start();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized void disableEvents() {
        if (this.events == null) {
            throw new IllegalStateException("Event handling not enabled.");
        }
        try {
            this.request("admin.eventsEnabled", "false");
        }
        catch (IOException e) {
            // empty catch block
        }
        this.connection.addEvent(Command.EOF);
        try {
            this.events.join(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.events = null;
    }

    public synchronized boolean enableHeartbeats(int interval) {
        if (this.heartbeats != null) {
            throw new IllegalStateException("Heartbeats already started.");
        }
        this.heartbeats = new HeartbeatChecker(this);
        Scheduler.getInstance().repeat(this.heartbeats, interval);
        return true;
    }

    public synchronized void disableHeartbeats() {
        if (this.heartbeats == null) {
            throw new IllegalStateException("Heartbeats not started.");
        }
        this.heartbeats.stop();
        this.heartbeats = null;
    }

    public synchronized boolean enablePlayerUpdates(int interval) {
        if (this.playerUpdater != null) {
            throw new IllegalStateException("Player updates already enabled");
        }
        this.playerUpdater = new PlayerUpdater(this, 60000);
        Scheduler.getInstance().repeat(this.playerUpdater, interval);
        return true;
    }

    public synchronized void disablePlayerUpdates() {
        if (this.playerUpdater == null) {
            throw new IllegalStateException("Player updates are not enabled.");
        }
        this.playerUpdater.setEnabled(false);
        this.playerUpdater = null;
    }

    public synchronized void enableServerMessenger(int interval) {
        if (this.serverMessenger != null) {
            throw new IllegalStateException("Server messenger already enabled.");
        }
        this.serverMessenger = new ServerMessenger(this, this.serverMessages);
        Scheduler.getInstance().repeat(this.serverMessenger, interval);
    }

    public synchronized void disableServerMessenger() {
        if (this.serverMessenger == null) {
            throw new IllegalStateException("Server messenger is not enabled.");
        }
        this.serverMessenger.stop();
        this.serverMessenger = null;
    }

    public synchronized void logout() {
        try {
            this.connection.logout();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void addHandler(RCONEventHandler handler) {
        if (this.events == null) {
            throw new IllegalStateException("Event handling not enabled.");
        }
        this.events.addHandler(handler);
    }

    public synchronized boolean say(String message) {
        try {
            Command response = this.request(new SayCommand(message));
            return response.is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean say(String message, Player p) {
        try {
            Command response = this.request(new SayCommand(message, p.getName()));
            return response.is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean disconnect(Player p, String reason) {
        try {
            Command response = this.request(new KickCommand(p.getName(), reason));
            return response.is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean ban(final Player p, String reason, String duration) {
        String fullDuration = duration.equals("perm") ? "permanently" : "for a " + duration.toLowerCase();
        StringBuilder sb = new StringBuilder();
        sb.append("Player " + p.getName() + " has been banned ");
        sb.append(fullDuration);
        sb.append(" with the reason " + reason + ".");
        this.say(sb.toString());
        sb = new StringBuilder();
        sb.append("You are being banned ");
        sb.append(fullDuration);
        sb.append(" with the reason " + reason + ".");
        this.say(sb.toString(), p);
        sb = new StringBuilder();
        sb.append("Banned ");
        sb.append(fullDuration);
        sb.append(" for " + reason + ".");
        final String disconnectMessage = sb.toString();
        Scheduler.getInstance().schedule(new Runnable(){

            public void run() {
                GameServer.this.disconnect(p, disconnectMessage);
            }
        }, 10000);
        return true;
    }

    public synchronized boolean kick(final Player p, final String reason) {
        this.say("You are being kicked for " + reason + ".", p);
        String text = "Player " + p.getName() + " has been kicked for " + reason + ".";
        this.say(text);
        Scheduler.getInstance().schedule(new Runnable(){

            public void run() {
                GameServer.this.disconnect(p, reason);
            }
        }, 5000);
        return true;
    }

    public synchronized boolean warn(Player p, String reason) {
        String targetMessage = "You were warned for " + reason + ".";
        this.say(targetMessage, p);
        String message = "Player " + p.getName() + " has been warned for " + reason + ".";
        this.say(message);
        return true;
    }

    public synchronized boolean restartMap() {
        try {
            Command response = this.request("admin.restartMap", new String[0]);
            return response.is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean runNextMap() {
        try {
            Command response = this.request("admin.runNextLevel", new String[0]);
            return response.is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean endRound(int winner) {
        try {
            Command response = this.request("admin.endRound", String.valueOf(winner));
            return response.is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized Map currentMap() {
        try {
            Command response = this.request("admin.currentLevel", new String[0]);
            if (response.is("OK")) {
                String name = response.get(0);
                Map map = Map.get(name);
                return map;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public synchronized boolean setNextMapIndex(int index) {
        try {
            Command response = this.request("mapList.nextLevelIndex", String.valueOf(index));
            return response.is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean setPlaylist(String playlist) {
        try {
            Command response = this.request("admin.setPlaylist", playlist);
            return response.is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean clearMapList() {
        try {
            Command response = this.request("mapList.clear", new String[0]);
            return response.is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean appendMap(Map map, int rounds) {
        try {
            Command response = this.request("mapList.append", map.getLevel(), String.valueOf(rounds));
            return response.is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean requestPbPlayerList() {
        try {
            Command response = this.request(new PunkBusterCommand("pb_sv_Plist", new String[0]));
            return response.is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized int getVersion() {
        try {
            Command response = this.request("version", new String[0]);
            if (response.is("OK")) {
                try {
                    return response.getInt(1);
                }
                catch (Exception e) {
                    return -1;
                }
            }
            return -1;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public synchronized boolean requestPlayerInfo() {
        try {
            Command response = this.request("admin.listPlayers", "all");
            if (response.is("OK")) {
                ArrayList<PlayerInfo> playerInfo = PlayerInfo.parse(response);
                if (playerInfo.size() != this.online.size()) {
                    logger.warn("Actual player count " + playerInfo.size() + " does not match local player count " + this.online.size() + ".");
                }
                for (PlayerInfo info : playerInfo) {
                    this.updatePlayer(info);
                }
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean updateInfo() {
        try {
            Command response = this.request("serverInfo", new String[0]);
            if (response.is("OK")) {
                this.serverName = response.get(0);
                this.maxPlayerCount = response.getInt(2);
                this.gameMode = response.get(3);
                this.map = response.get(4);
                this.roundsPlayed = response.getInt(5);
                this.roundsTotal = response.getInt(6);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean kill(Player target) {
        try {
            Command response = this.request("admin.killPlayer", target.getName());
            return response.is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean setVariable(String variable, String value) {
        try {
            return this.request(variable, value).is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized String getVariable(String variable) {
        try {
            Command response = this.request(variable, new String[0]);
            if (response.is("OK") && response.size() > 0) {
                return response.get(0);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public synchronized boolean punkbuster(String command) {
        try {
            Command response = this.request("punkBuster.pb_sv_command", command);
            return response.is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized List<String> getReservedSlots() {
        try {
            Command response = this.request("reservedSlots.list", new String[0]);
            if (response.is("OK")) {
                ArrayList<String> slots = new ArrayList<String>();
                for (int i = 0; i < response.size(); ++i) {
                    slots.add(response.get(i));
                }
                return slots;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public synchronized boolean addReservedSlot(String playerName) {
        try {
            return this.request("reservedSlots.addPlayer", playerName).is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean removeReservedSlot(String playerName) {
        try {
            return this.request("reservedSlots.removePlayer", playerName).is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean clearReservedSlots() {
        try {
            return this.request("reservedSlots.clear", new String[0]).is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean loadReservedSlots() {
        try {
            return this.request("reservedSlots.load", new String[0]).is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean saveReservedSlots() {
        try {
            return this.request("reservedSlots.save", new String[0]).is("OK");
        }
        catch (IOException e) {
            return false;
        }
    }

    private synchronized void updatePlayer(PlayerInfo info) {
        Player player = this.online.ensureGetByName(info.getName());
        if (this.events != null) {
            this.events.onPlayerInfo(info);
        }
    }

    private synchronized Command request(String command, String ... arguments) throws IOException {
        return this.request(new ClientRequest(command, arguments));
    }

    private synchronized Command request(Command command) throws IOException {
        try {
            return this.connection.sendRequest(command);
        }
        catch (IOException e) {
            this.connectionLost();
            throw e;
        }
    }

    public long getConnectionTime() {
        return this.connectionTime;
    }
}

