/*
 * Decompiled with CFR 0.152.
 */
package rcon.server;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import rcon.Hex;
import rcon.commands.ClientRequest;
import rcon.commands.Command;
import rcon.net.RCONInputStream;
import rcon.net.RCONOutputStream;
import rcon.server.ReceiverThread;
import rcon.server.SimpleTimer;

public class ServerConnection
implements Runnable {
    static Logger logger = Logger.getLogger(ServerConnection.class);
    private Socket socket;
    private LinkedBlockingQueue<Command> events = new LinkedBlockingQueue();
    private SynchronousQueue<Command> responses = new SynchronousQueue();
    private AtomicInteger seq = new AtomicInteger(1);
    private ReceiverThread receiver;
    private RCONOutputStream rout;
    private SimpleTimer timeoutTimer;

    public ServerConnection(int timeout) {
        this.timeoutTimer = new SimpleTimer(timeout, this);
    }

    public boolean awaitShutdown() {
        try {
            this.receiver.join();
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected void addResponse(Command response) {
        this.timeoutTimer.abort();
        this.responses.offer(response);
    }

    public Command sendRequest(Command command) throws IOException {
        long before = System.currentTimeMillis();
        command.setSeq(this.seq.getAndIncrement());
        try {
            this.rout.sendCommand(command);
            this.timeoutTimer.start();
            Command response = this.responses.take();
            if (response == Command.EOF) {
                throw new IOException("End of file.");
            }
            Command command2 = response;
            return command2;
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while sending request.", e);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        finally {
            logger.trace("It took " + (System.currentTimeMillis() - before) + " ms to send receive a response. (" + command.getName() + ")");
        }
    }

    protected void sentResponse(Command response) throws IOException {
        this.rout.sendCommand(response);
    }

    protected void addEvent(Command event) {
        this.events.add(event);
    }

    public Command getEvent() {
        try {
            return this.events.take();
        }
        catch (InterruptedException e) {
            return Command.EOF;
        }
    }

    public void start(String ip, int port) throws IOException {
        this.socket = new Socket(ip, port);
        this.rout = new RCONOutputStream(this.socket.getOutputStream());
        RCONInputStream rin = new RCONInputStream(this.socket.getInputStream());
        this.receiver = new ReceiverThread(rin, this);
        this.receiver.start();
    }

    public boolean login(String password) throws IOException {
        Command result = this.sendRequest(new ClientRequest("login.hashed", new String[0]));
        if (result.is("OK")) {
            String salt = result.get(0);
            String hexHash = Hex.hashPassword(password, salt);
            result = this.sendRequest(new ClientRequest("login.hashed", hexHash));
            if (result.is("OK")) {
                return true;
            }
        }
        return false;
    }

    public boolean logout() throws IOException {
        Command result = this.sendRequest(new ClientRequest("logout", new String[0]));
        return result.is("OK");
    }

    public void quit() throws IOException {
        Command result = this.sendRequest(new ClientRequest("quit", new String[0]));
        if (!result.is("OK")) {
            System.out.println("Server did not acknowledge quit command. Forcing shutdown.");
        }
    }

    public void stop() {
        this.receiver.interrupt();
        try {
            this.socket.close();
        }
        catch (IOException e) {
            logger.error("Failed to close socket.", e);
        }
        try {
            this.receiver.join(500L);
        }
        catch (InterruptedException e) {
            logger.error("Failed to shut down network threads.", e);
            throw new RuntimeException(e);
        }
        this.timeoutTimer.close();
    }

    public void run() {
        this.responses.offer(Command.EOF);
    }
}

