/*
 * Decompiled with CFR 0.152.
 */
package rcon.server;

import java.util.ArrayList;
import java.util.Arrays;

public class SimpleTimer {
    private volatile ArrayList<Runnable> listeners;
    private volatile int delay;
    private volatile long last;
    private volatile boolean started;
    private volatile boolean closed;
    private volatile Object lock;
    private volatile TimerThread thread;

    public SimpleTimer(int delay, Runnable ... l) {
        this.listeners = new ArrayList<Runnable>(Arrays.asList(l));
        this.delay = delay;
        this.last = 0L;
        this.started = false;
        this.closed = false;
        this.lock = new Object();
        this.thread = new TimerThread();
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.started = false;
            this.closed = true;
            this.lock.notifyAll();
        }
        try {
            this.thread.join(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            this.started = true;
            this.last = System.currentTimeMillis();
            this.lock.notifyAll();
        }
    }

    public void restart() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.started = false;
            this.lock.notifyAll();
        }
    }

    public void abort() {
        this.stop();
    }

    private class TimerThread
    extends Thread {
        public TimerThread() {
            super("TimerThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = SimpleTimer.this.lock;
            synchronized (object) {
                while (!SimpleTimer.this.closed) {
                    while (!(SimpleTimer.this.closed || SimpleTimer.this.started && System.currentTimeMillis() >= SimpleTimer.this.last + (long)SimpleTimer.this.delay)) {
                        try {
                            if (SimpleTimer.this.started) {
                                SimpleTimer.this.lock.wait(Math.max(0L, (long)SimpleTimer.this.delay - System.currentTimeMillis() + SimpleTimer.this.last));
                                continue;
                            }
                            SimpleTimer.this.lock.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (SimpleTimer.this.closed) break;
                    for (Runnable l : SimpleTimer.this.listeners) {
                        l.run();
                    }
                    SimpleTimer.this.last = System.currentTimeMillis();
                    SimpleTimer.this.started = false;
                    SimpleTimer.this.lock.notifyAll();
                }
            }
        }
    }
}

