/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionValue;
import org.hsqldb.ParserDQL;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.error.Error;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

public class FunctionSQL
extends Expression {
    protected static final int FUNC_POSITION_CHAR = 1;
    private static final int FUNC_POSITION_BINARY = 2;
    private static final int FUNC_OCCURENCES_REGEX = 3;
    private static final int FUNC_POSITION_REGEX = 4;
    protected static final int FUNC_EXTRACT = 5;
    protected static final int FUNC_BIT_LENGTH = 6;
    protected static final int FUNC_CHAR_LENGTH = 7;
    protected static final int FUNC_OCTET_LENGTH = 8;
    private static final int FUNC_CARDINALITY = 9;
    private static final int FUNC_ABS = 10;
    private static final int FUNC_MOD = 11;
    protected static final int FUNC_LN = 12;
    private static final int FUNC_EXP = 13;
    private static final int FUNC_POWER = 14;
    private static final int FUNC_SQRT = 15;
    private static final int FUNC_FLOOR = 16;
    private static final int FUNC_CEILING = 17;
    private static final int FUNC_WIDTH_BUCKET = 20;
    protected static final int FUNC_SUBSTRING_CHAR = 21;
    private static final int FUNC_SUBSTRING_REG_EXPR = 22;
    private static final int FUNC_SUBSTRING_REGEX = 23;
    protected static final int FUNC_FOLD_LOWER = 24;
    protected static final int FUNC_FOLD_UPPER = 25;
    private static final int FUNC_TRANSCODING = 26;
    private static final int FUNC_TRANSLITERATION = 27;
    private static final int FUNC_REGEX_TRANSLITERATION = 28;
    protected static final int FUNC_TRIM_CHAR = 29;
    static final int FUNC_OVERLAY_CHAR = 30;
    private static final int FUNC_CHAR_NORMALIZE = 31;
    private static final int FUNC_SUBSTRING_BINARY = 32;
    private static final int FUNC_TRIM_BINARY = 33;
    private static final int FUNC_OVERLAY_BINARY = 40;
    protected static final int FUNC_CURRENT_DATE = 41;
    protected static final int FUNC_CURRENT_TIME = 42;
    protected static final int FUNC_CURRENT_TIMESTAMP = 43;
    protected static final int FUNC_LOCALTIME = 44;
    protected static final int FUNC_LOCALTIMESTAMP = 50;
    private static final int FUNC_CURRENT_CATALOG = 51;
    private static final int FUNC_CURRENT_DEFAULT_TRANSFORM_GROUP = 52;
    private static final int FUNC_CURRENT_PATH = 53;
    private static final int FUNC_CURRENT_ROLE = 54;
    private static final int FUNC_CURRENT_SCHEMA = 55;
    private static final int FUNC_CURRENT_TRANSFORM_GROUP_FOR_TYPE = 56;
    private static final int FUNC_CURRENT_USER = 57;
    private static final int FUNC_SESSION_USER = 58;
    private static final int FUNC_SYSTEM_USER = 59;
    protected static final int FUNC_USER = 60;
    private static final int FUNC_VALUE = 61;
    static final short[] noParamList = new short[0];
    static final short[] emptyParamList = new short[]{795, 782};
    static final short[] optionalNoParamList = new short[]{842, 2, 795, 782};
    static final short[] optionalSingleParamList = new short[]{795, 842, 1, 797, 782};
    static final short[] singleParamList = new short[]{795, 797, 782};
    static final short[] optionalIntegerParamList = new short[]{842, 3, 795, 844, 782};
    static final short[] doubleParamList = new short[]{795, 797, 784, 797, 782};
    static final short[] tripleParamList = new short[]{795, 797, 784, 797, 784, 797, 782};
    static final short[] quadParamList = new short[]{795, 797, 784, 797, 784, 797, 784, 797, 782};
    static IntValueHashMap valueFuncMap = new IntValueHashMap();
    static IntValueHashMap regularFuncMap = new IntValueHashMap();
    static OrderedIntHashSet nonDeterministicFuncSet = new OrderedIntHashSet();
    int funcType;
    boolean isDeterministic;
    String name;
    short[] parseList;
    short[] parseListAlt;
    boolean isSQLValueFunction;

    public static FunctionSQL newSQLFunction(String string, ParserDQL.CompileContext compileContext) {
        int n = regularFuncMap.get((Object)string, -1);
        boolean bl = false;
        if (n == -1) {
            n = valueFuncMap.get((Object)string, -1);
            bl = true;
        }
        if (n == -1) {
            return null;
        }
        FunctionSQL functionSQL = new FunctionSQL(n);
        if (n == 61) {
            if (compileContext.currentDomain == null) {
                return null;
            }
            functionSQL.dataType = compileContext.currentDomain;
        } else {
            functionSQL.isSQLValueFunction = bl;
        }
        return functionSQL;
    }

    protected FunctionSQL() {
        super(28);
        this.nodes = Expression.emptyArray;
    }

    protected FunctionSQL(int n) {
        this();
        this.funcType = n;
        this.isDeterministic = !nonDeterministicFuncSet.contains(n);
        switch (n) {
            case 1: 
            case 2: {
                this.name = "POSITION";
                this.parseList = new short[]{795, 797, 128, 797, 842, 5, 304, 841, 2, 355, 453, 782};
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                this.name = "EXTRACT";
                this.parseList = new short[]{795, 841, 17, 321, 171, 72, 126, 167, 248, 621, 678, 653, 622, 620, 678, 619, 645, 663, 281, 282, 114, 797, 782};
                break;
            }
            case 7: {
                this.name = "CHAR_LENGTH";
                this.parseList = new short[]{795, 797, 842, 5, 304, 841, 2, 355, 453, 782};
                break;
            }
            case 6: {
                this.name = "BIT_LENGTH";
                this.parseList = singleParamList;
                break;
            }
            case 8: {
                this.name = "OCTET_LENGTH";
                this.parseList = singleParamList;
                break;
            }
            case 9: {
                this.parseList = singleParamList;
                break;
            }
            case 10: {
                this.name = "ABS";
                this.parseList = singleParamList;
                break;
            }
            case 11: {
                this.name = "MOD";
                this.parseList = doubleParamList;
                break;
            }
            case 12: {
                this.name = "LN";
                this.parseList = singleParamList;
                break;
            }
            case 13: {
                this.name = "EXP";
                this.parseList = singleParamList;
                break;
            }
            case 14: {
                this.name = "POWER";
                this.parseList = doubleParamList;
                break;
            }
            case 15: {
                this.name = "SQRT";
                this.parseList = singleParamList;
                break;
            }
            case 16: {
                this.name = "FLOOR";
                this.parseList = singleParamList;
                break;
            }
            case 17: {
                this.name = "CEILING";
                this.parseList = singleParamList;
                break;
            }
            case 20: {
                this.name = "WIDTH_BUCKET";
                this.parseList = quadParamList;
                break;
            }
            case 21: 
            case 32: {
                this.name = "SUBSTRING";
                this.parseList = new short[]{795, 797, 114, 797, 842, 2, 111, 797, 842, 5, 304, 841, 2, 355, 453, 782};
                this.parseListAlt = new short[]{795, 797, 784, 797, 842, 2, 784, 797, 782};
                break;
            }
            case 24: {
                this.name = "LOWER";
                this.parseList = singleParamList;
                break;
            }
            case 25: {
                this.name = "UPPER";
                this.parseList = singleParamList;
                break;
            }
            case 29: 
            case 33: {
                this.name = "TRIM";
                this.parseList = new short[]{795, 842, 11, 842, 5, 841, 3, 149, 284, 22, 842, 1, 797, 114, 797, 782};
                break;
            }
            case 30: 
            case 40: {
                this.name = "OVERLAY";
                this.parseList = new short[]{795, 797, 472, 797, 114, 797, 842, 2, 111, 797, 842, 2, 304, 355, 782};
                break;
            }
            case 51: {
                this.name = "CURRENT_CATALOG";
                this.parseList = noParamList;
                break;
            }
            case 54: {
                this.name = "CURRENT_ROLE";
                this.parseList = noParamList;
                break;
            }
            case 55: {
                this.name = "CURRENT_SCHEMA";
                this.parseList = noParamList;
                break;
            }
            case 57: {
                this.name = "CURRENT_USER";
                this.parseList = noParamList;
                break;
            }
            case 58: {
                this.name = "SESSION_USER";
                this.parseList = noParamList;
                break;
            }
            case 59: {
                this.name = "SYSTEM_USER";
                this.parseList = noParamList;
                break;
            }
            case 60: {
                this.name = "USER";
                this.parseList = optionalNoParamList;
                break;
            }
            case 61: {
                this.name = "VALUE";
                this.parseList = noParamList;
                break;
            }
            case 41: {
                this.name = "CURRENT_DATE";
                this.parseList = noParamList;
                break;
            }
            case 42: {
                this.name = "CURRENT_TIME";
                this.parseList = optionalIntegerParamList;
                break;
            }
            case 43: {
                this.name = "CURRENT_TIMESTAMP";
                this.parseList = optionalIntegerParamList;
                break;
            }
            case 44: {
                this.name = "LOCALTIME";
                this.parseList = optionalIntegerParamList;
                break;
            }
            case 50: {
                this.name = "LOCALTIMESTAMP";
                this.parseList = optionalIntegerParamList;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionSQL");
            }
        }
    }

    public void setArguments(Expression[] expressionArray) {
        this.nodes = expressionArray;
    }

    public Expression getFunctionExpression() {
        return this;
    }

    @Override
    public Object getValue(Session session) {
        Object[] objectArray = new Object[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            Expression expression = this.nodes[i];
            if (expression == null) continue;
            objectArray[i] = expression.getValue(session, expression.dataType);
        }
        return this.getValue(session, objectArray);
    }

    Object getValue(Session session, Object[] objectArray) {
        switch (this.funcType) {
            case 1: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                long l = ((CharacterType)this.nodes[1].dataType).position(session, objectArray[1], objectArray[0], this.nodes[0].dataType, 0L) + 1L;
                if (this.nodes[2] != null && ((Number)this.nodes[2].valueData).intValue() == 453) {
                    l *= 2L;
                }
                return ValuePool.getLong(l);
            }
            case 2: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                long l = ((BinaryType)this.nodes[1].dataType).position(session, (BlobData)objectArray[1], (BlobData)objectArray[0], this.nodes[0].dataType, 0L) + 1L;
                if (this.nodes[2] != null && ((Number)this.nodes[2].valueData).intValue() == 453) {
                    l *= 2L;
                }
                return ValuePool.getLong(l);
            }
            case 5: {
                if (objectArray[1] == null) {
                    return null;
                }
                int n = ((Number)this.nodes[0].valueData).intValue();
                n = DTIType.getFieldNameTypeForToken(n);
                switch (n) {
                    case 106: {
                        return ((DTIType)this.nodes[1].dataType).getSecondPart(objectArray[1]);
                    }
                    case 264: 
                    case 265: {
                        return ((DateTimeType)this.nodes[1].dataType).getPartString(session, objectArray[1], n);
                    }
                }
                int n2 = ((DTIType)this.nodes[1].dataType).getPart(session, objectArray[1], n);
                return ValuePool.getInt(n2);
            }
            case 7: {
                if (objectArray[0] == null) {
                    return null;
                }
                long l = ((CharacterType)this.nodes[0].dataType).size(session, objectArray[0]);
                return ValuePool.getLong(l);
            }
            case 6: {
                if (objectArray[0] == null) {
                    return null;
                }
                long l = this.nodes[0].dataType.isBinaryType() ? ((BlobData)objectArray[0]).bitLength(session) : 16L * ((CharacterType)this.nodes[0].dataType).size(session, objectArray[0]);
                return ValuePool.getLong(l);
            }
            case 8: {
                if (objectArray[0] == null) {
                    return null;
                }
                long l = this.nodes[0].dataType.isBinaryType() ? ((BlobData)objectArray[0]).length(session) : 2L * ((CharacterType)this.nodes[0].dataType).size(session, objectArray[0]);
                return ValuePool.getLong(l);
            }
            case 10: {
                if (objectArray[0] == null) {
                    return null;
                }
                return this.dataType.absolute(objectArray[0]);
            }
            case 11: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                return ((NumberType)this.dataType).modulo(objectArray[0], objectArray[1], this.nodes[0].dataType);
            }
            case 12: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = ((Number)objectArray[0]).doubleValue();
                if (d <= 0.0) {
                    throw Error.error(3444);
                }
                d = Math.log(d);
                return ValuePool.getDouble(Double.doubleToLongBits(d));
            }
            case 13: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = Math.exp(((Number)objectArray[0]).doubleValue());
                return ValuePool.getDouble(Double.doubleToLongBits(d));
            }
            case 14: {
                double d;
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                double d2 = ((Number)objectArray[0]).doubleValue();
                double d3 = ((Number)objectArray[1]).doubleValue();
                if (d3 < 0.0) {
                    throw Error.error(3445);
                }
                if (d2 == 0.0) {
                    if (d3 < 0.0) {
                        throw Error.error(3445);
                    }
                    d = d3 == 0.0 ? 1.0 : 0.0;
                } else {
                    d = Math.pow(d2, d3);
                }
                return ValuePool.getDouble(Double.doubleToLongBits(d));
            }
            case 15: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = Math.sqrt(((Number)objectArray[0]).doubleValue());
                return ValuePool.getDouble(Double.doubleToLongBits(d));
            }
            case 16: {
                if (objectArray[0] == null) {
                    return null;
                }
                return ((NumberType)this.dataType).floor(objectArray[0]);
            }
            case 17: {
                if (objectArray[0] == null) {
                    return null;
                }
                return ((NumberType)this.dataType).ceiling(objectArray[0]);
            }
            case 20: {
                return null;
            }
            case 21: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                Object object = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].dataType);
                long l = ((Number)object).longValue() - 1L;
                long l2 = 0L;
                if (this.nodes[2] != null) {
                    if (objectArray[2] == null) {
                        return null;
                    }
                    object = Type.SQL_BIGINT.convertToType(session, objectArray[2], this.nodes[2].dataType);
                    l2 = ((Number)object).longValue();
                }
                if (this.nodes.length <= 3 || this.nodes[3] == null || ((Number)this.nodes[2].valueData).intValue() == 453) {
                    // empty if block
                }
                return ((CharacterType)this.dataType).substring(session, objectArray[0], l, l2, this.nodes[2] != null, false);
            }
            case 24: {
                if (objectArray[0] == null) {
                    return null;
                }
                return ((CharacterType)this.dataType).lower(session, objectArray[0]);
            }
            case 25: {
                if (objectArray[0] == null) {
                    return null;
                }
                return ((CharacterType)this.dataType).upper(session, objectArray[0]);
            }
            case 29: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                boolean bl = false;
                boolean bl2 = false;
                switch (((Number)this.nodes[0].valueData).intValue()) {
                    case 22: {
                        bl2 = true;
                        bl = true;
                        break;
                    }
                    case 149: {
                        bl = true;
                        break;
                    }
                    case 284: {
                        bl2 = true;
                        break;
                    }
                    default: {
                        throw Error.runtimeError(201, "FunctionSQL");
                    }
                }
                String string = (String)objectArray[1];
                if (string.length() != 1) {
                    throw Error.error(3460);
                }
                char c = string.charAt(0);
                return ((CharacterType)this.dataType).trim(session, objectArray[2], c, bl, bl2);
            }
            case 30: {
                if (objectArray[0] == null || objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                Object object = Type.SQL_BIGINT.convertToType(session, objectArray[2], this.nodes[2].dataType);
                long l = ((Number)object).longValue() - 1L;
                long l3 = 0L;
                if (this.nodes[3] != null) {
                    if (objectArray[3] == null) {
                        return null;
                    }
                    object = Type.SQL_BIGINT.convertToType(session, objectArray[3], this.nodes[3].dataType);
                    l3 = ((Number)object).longValue();
                }
                return ((CharacterType)this.dataType).overlay(null, objectArray[0], objectArray[1], l, l3, this.nodes[3] != null);
            }
            case 32: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                Object object = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].dataType);
                long l = ((Number)object).longValue() - 1L;
                long l4 = 0L;
                if (this.nodes[2] != null) {
                    if (objectArray[2] == null) {
                        return null;
                    }
                    object = Type.SQL_BIGINT.convertToType(session, objectArray[2], this.nodes[2].dataType);
                    l4 = ((Number)object).intValue();
                }
                return ((BinaryType)this.dataType).substring(session, (BlobData)objectArray[0], l, l4, this.nodes[2] != null);
            }
            case 33: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                boolean bl = false;
                boolean bl3 = false;
                int n = ((Number)this.nodes[0].valueData).intValue();
                switch (n) {
                    case 22: {
                        bl3 = true;
                        bl = true;
                        break;
                    }
                    case 149: {
                        bl = true;
                        break;
                    }
                    case 284: {
                        bl3 = true;
                        break;
                    }
                    default: {
                        throw Error.runtimeError(201, "FunctionSQL");
                    }
                }
                BlobData blobData = (BlobData)objectArray[1];
                if (blobData.length(session) != 1L) {
                    throw Error.error(3460);
                }
                byte[] byArray = blobData.getBytes();
                return ((BinaryType)this.dataType).trim(session, (BlobData)objectArray[3], byArray[0], bl, bl3);
            }
            case 40: {
                if (objectArray[0] == null || objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                Object object = Type.SQL_BIGINT.convertToType(session, objectArray[2], this.nodes[2].dataType);
                long l = ((Number)object).longValue() - 1L;
                long l5 = 0L;
                if (this.nodes[3] != null) {
                    if (objectArray[3] == null) {
                        return null;
                    }
                    object = Type.SQL_BIGINT.convertToType(session, objectArray[3], this.nodes[3].dataType);
                    l5 = ((Number)object).longValue();
                }
                return ((BinaryType)this.dataType).overlay(session, (BlobData)objectArray[0], (BlobData)objectArray[1], l, l5, this.nodes[3] != null);
            }
            case 51: {
                return session.database.getCatalogName().name;
            }
            case 54: {
                return session.getRole() == null ? null : session.getRole().getNameString();
            }
            case 55: {
                return session.getCurrentSchemaHsqlName().name;
            }
            case 57: {
                return session.getUser().getNameString();
            }
            case 58: {
                return session.getUser().getNameString();
            }
            case 59: {
                return session.getUser().getNameString();
            }
            case 60: {
                return session.getUser().getNameString();
            }
            case 61: {
                return session.sessionData.currentValue;
            }
            case 41: {
                return session.getCurrentDate();
            }
            case 42: {
                return this.dataType.convertToTypeLimits(session, session.getCurrentTime(true));
            }
            case 43: {
                return this.dataType.convertToTypeLimits(session, session.getCurrentTimestamp(true));
            }
            case 44: {
                return this.dataType.convertToTypeLimits(session, session.getCurrentTime(false));
            }
            case 50: {
                return this.dataType.convertToTypeLimits(session, session.getCurrentTimestamp(false));
            }
        }
        throw Error.runtimeError(201, "FunctionSQL");
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            this.nodes[n].resolveTypes(session, this);
        }
        switch (this.funcType) {
            case 1: 
            case 2: {
                if (this.nodes[0].dataType == null) {
                    if (this.nodes[1].dataType == null) {
                        throw Error.error(5567);
                    }
                    this.nodes[0].dataType = this.nodes[1].dataType.typeCode == 40 || this.nodes[1].dataType.isBinaryType() ? this.nodes[1].dataType : Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType.typeCode == 40 || this.nodes[0].dataType.isBinaryType() ? this.nodes[0].dataType : Type.SQL_VARCHAR;
                }
                if (this.nodes[0].dataType.isCharacterType() && this.nodes[1].dataType.isCharacterType()) {
                    this.funcType = 1;
                } else if (this.nodes[0].dataType.isBinaryType() && this.nodes[1].dataType.isBinaryType()) {
                    if (this.nodes[0].dataType.isBitType() || this.nodes[1].dataType.isBitType()) {
                        throw Error.error(5563);
                    }
                    this.funcType = 2;
                } else {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 5: {
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isDateTimeType() && !this.nodes[1].dataType.isIntervalType()) {
                    throw Error.error(5563);
                }
                n = ((Number)this.nodes[0].valueData).intValue();
                DTIType dTIType = (DTIType)this.nodes[1].dataType;
                n = DTIType.getFieldNameTypeForToken(n);
                this.dataType = dTIType.getExtractType(n);
                break;
            }
            case 6: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_BIT_VARYING_MAX_LENGTH;
                }
                if (!this.nodes[0].dataType.isCharacterType() && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 7: {
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
            }
            case 8: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType() && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 9: {
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 11: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.nodes[0].dataType = ((NumberType)this.nodes[0].dataType).getIntegralType();
                this.dataType = this.nodes[1].dataType = ((NumberType)this.nodes[1].dataType).getIntegralType();
                break;
            }
            case 14: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.nodes[0].dataType = Type.SQL_DOUBLE;
                this.nodes[1].dataType = Type.SQL_DOUBLE;
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.nodes[0].dataType = Type.SQL_DOUBLE;
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 10: {
                if (this.nodes[0].dataType != null && this.nodes[0].dataType.isIntervalType()) {
                    this.dataType = this.nodes[0].dataType;
                    break;
                }
            }
            case 16: 
            case 17: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 20: {
                if (this.nodes[0].dataType == null || this.nodes[1].dataType == null || this.nodes[2].dataType == null || this.nodes[3].dataType == null) {
                    throw Error.error(5567);
                }
                if (!(this.nodes[0].dataType.isNumberType() && this.nodes[1].dataType.isNumberType() && this.nodes[2].dataType.isNumberType() && this.nodes[3].dataType.isIntegralType())) {
                    throw Error.error(5563);
                }
                this.dataType = this.nodes[3].dataType;
                break;
            }
            case 21: 
            case 32: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_NUMERIC;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_NUMERIC;
                    }
                    if (!this.nodes[2].dataType.isNumberType()) {
                        throw Error.error(5563);
                    }
                    this.nodes[2].dataType = ((NumberType)this.nodes[2].dataType).getIntegralType();
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType()) {
                    this.funcType = 21;
                    if (this.dataType.typeCode == 1) {
                        this.dataType = CharacterType.getCharacterType(12, this.dataType.precision);
                    }
                } else if (this.dataType.isBinaryType()) {
                    this.funcType = 32;
                } else {
                    throw Error.error(5563);
                }
                if (this.nodes.length <= 3 || this.nodes[3] == null) break;
                break;
            }
            case 24: 
            case 25: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType()) break;
                throw Error.error(5563);
            }
            case 29: 
            case 33: {
                if (this.nodes[0] == null) {
                    this.nodes[0] = new ExpressionValue(ValuePool.getInt(22), Type.SQL_INTEGER);
                }
                if (this.nodes[2].dataType == null) {
                    throw Error.error(5567);
                }
                this.dataType = this.nodes[2].dataType;
                if (this.dataType.isCharacterType()) {
                    this.funcType = 29;
                    if (this.dataType.typeCode == 1) {
                        this.dataType = CharacterType.getCharacterType(12, this.dataType.precision);
                    }
                    if (this.nodes[1] != null) break;
                    this.nodes[1] = new ExpressionValue(" ", Type.SQL_CHAR);
                    break;
                }
                if (this.dataType.isBinaryType()) {
                    this.funcType = 33;
                    if (this.nodes[1] != null) break;
                    this.nodes[1] = new ExpressionValue(new BinaryData(new byte[]{0}, false), Type.SQL_BINARY);
                    break;
                }
                throw Error.error(5563);
            }
            case 30: 
            case 40: {
                if (this.nodes[0].dataType == null) {
                    if (this.nodes[1].dataType == null) {
                        throw Error.error(5567);
                    }
                    this.nodes[0].dataType = this.nodes[1].dataType.typeCode == 40 || this.nodes[1].dataType.isBinaryType() ? this.nodes[1].dataType : Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType.typeCode == 40 || this.nodes[0].dataType.isBinaryType() ? this.nodes[0].dataType : Type.SQL_VARCHAR;
                }
                if (this.nodes[0].dataType.isCharacterType() && this.nodes[1].dataType.isCharacterType()) {
                    this.funcType = 30;
                    this.dataType = this.nodes[0].dataType.typeCode == 40 || this.nodes[1].dataType.typeCode == 40 ? CharacterType.getCharacterType(40, this.nodes[0].dataType.precision + this.nodes[1].dataType.precision) : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision + this.nodes[1].dataType.precision);
                } else if (this.nodes[0].dataType.isBinaryType() && this.nodes[1].dataType.isBinaryType()) {
                    this.funcType = 40;
                    this.dataType = this.nodes[0].dataType.typeCode == 30 || this.nodes[1].dataType.typeCode == 30 ? BinaryType.getBinaryType(30, this.nodes[0].dataType.precision + this.nodes[1].dataType.precision) : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision + this.nodes[1].dataType.precision);
                } else {
                    throw Error.error(5563);
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_NUMERIC;
                }
                if (!this.nodes[2].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.nodes[2].dataType = ((NumberType)this.nodes[2].dataType).getIntegralType();
                if (this.nodes[3] == null) break;
                if (this.nodes[3].dataType == null) {
                    this.nodes[3].dataType = Type.SQL_NUMERIC;
                }
                if (!this.nodes[3].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.nodes[3].dataType = ((NumberType)this.nodes[3].dataType).getIntegralType();
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                this.dataType = SqlInvariants.SQL_IDENTIFIER;
                break;
            }
            case 61: {
                break;
            }
            case 41: {
                this.dataType = CharacterType.SQL_DATE;
                break;
            }
            case 42: {
                n = 0;
                if (this.nodes[0] != null) {
                    n = (Integer)this.nodes[0].valueData;
                }
                this.dataType = DateTimeType.getDateTimeType(94, n);
                break;
            }
            case 43: {
                n = 6;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    n = (Integer)this.nodes[0].valueData;
                }
                this.dataType = DateTimeType.getDateTimeType(95, n);
                break;
            }
            case 44: {
                n = 0;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    n = (Integer)this.nodes[0].valueData;
                }
                this.dataType = DateTimeType.getDateTimeType(92, n);
                break;
            }
            case 50: {
                n = 6;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    n = (Integer)this.nodes[0].valueData;
                }
                this.dataType = DateTimeType.getDateTimeType(93, n);
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionSQL");
            }
        }
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.funcType) {
            case 1: 
            case 2: {
                stringBuffer.append("POSITION").append('(').append(this.nodes[0].getSQL()).append(' ').append("IN").append(' ').append(this.nodes[1].getSQL());
                if (this.nodes[2] != null && Boolean.TRUE.equals(this.nodes[2].valueData)) {
                    stringBuffer.append(' ').append("USING").append(' ').append("OCTETS");
                }
                stringBuffer.append(')');
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                int n = (Integer)this.nodes[0].valueData;
                n = DTIType.getFieldNameTypeForToken(n);
                String string = DTIType.getFieldNameTokenForType(n);
                stringBuffer.append("EXTRACT").append('(').append(string).append(' ').append("FROM").append(' ').append(this.nodes[1].getSQL()).append(')');
                break;
            }
            case 7: {
                stringBuffer.append("CHAR_LENGTH").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 6: {
                stringBuffer.append("BIT_LENGTH").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 8: {
                stringBuffer.append("OCTET_LENGTH").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 10: {
                stringBuffer.append("ABS").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 11: {
                stringBuffer.append("MOD").append('(').append(this.nodes[0].getSQL()).append(',').append(this.nodes[1].getSQL()).append(')');
                break;
            }
            case 12: {
                stringBuffer.append("LN").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 13: {
                stringBuffer.append("EXP").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 14: {
                stringBuffer.append("POWER").append('(').append(this.nodes[0].getSQL()).append(',').append(this.nodes[1].getSQL()).append(')');
                break;
            }
            case 15: {
                stringBuffer.append("SQRT").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 16: {
                stringBuffer.append("FLOOR").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 17: {
                stringBuffer.append("CEILING").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 20: {
                stringBuffer.append("WIDTH_BUCKET").append('(').append(this.nodes[0].getSQL()).append(',').append(this.nodes[1].getSQL()).append(',').append(this.nodes[2].getSQL()).append(',').append(this.nodes[3].getSQL()).append(')');
                break;
            }
            case 21: 
            case 32: {
                stringBuffer.append("SUBSTRING").append('(').append(this.nodes[0].getSQL()).append(' ').append("FROM").append(' ').append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    stringBuffer.append(' ').append("FOR").append(' ').append(this.nodes[2].getSQL());
                }
                if (this.nodes.length > 3 && this.nodes[3] != null && Boolean.TRUE.equals(this.nodes[3].valueData)) {
                    stringBuffer.append(' ').append("USING").append(' ').append("OCTETS");
                }
                stringBuffer.append(')');
                break;
            }
            case 24: {
                stringBuffer.append("LOWER").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 25: {
                stringBuffer.append("UPPER").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 30: 
            case 40: {
                stringBuffer.append("OVERLAY").append('(').append(this.nodes[0].getSQL()).append(' ').append("PLACING").append(' ').append(this.nodes[1].getSQL()).append(' ').append("FROM").append(' ').append(this.nodes[2].getSQL());
                if (this.nodes[3] != null) {
                    stringBuffer.append(' ').append("FOR").append(' ').append(this.nodes[3].getSQL());
                }
                if (this.nodes[4] != null && Boolean.TRUE.equals(this.nodes[4].valueData)) {
                    stringBuffer.append(' ').append("USING").append(' ').append("OCTETS");
                }
                stringBuffer.append(')');
                break;
            }
            case 29: 
            case 33: {
                String string = null;
                switch (((Number)this.nodes[0].valueData).intValue()) {
                    case 22: {
                        string = "BOTH";
                        break;
                    }
                    case 149: {
                        string = "LEADING";
                        break;
                    }
                    case 284: {
                        string = "TRAILING";
                    }
                }
                stringBuffer.append("TRIM").append('(').append(string).append(' ').append(this.nodes[1].getSQL()).append(' ').append("FROM").append(' ').append(this.nodes[2].getSQL()).append(')');
                break;
            }
            case 41: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                return this.name;
            }
            case 42: 
            case 44: {
                int n = 0;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    n = ((Number)this.nodes[0].valueData).intValue();
                }
                if (n == 0) {
                    return this.name;
                }
                stringBuffer.append(this.name).append("(").append(n);
                stringBuffer.append(")");
                return stringBuffer.toString();
            }
            case 43: 
            case 50: {
                int n = 6;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    n = ((Number)this.nodes[0].valueData).intValue();
                }
                if (n == 6) {
                    return this.name;
                }
                stringBuffer.append(this.name).append("(").append(n);
                stringBuffer.append(")");
                return stringBuffer.toString();
            }
            default: {
                throw Error.runtimeError(201, "FunctionSQL");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof FunctionSQL && this.funcType == ((FunctionSQL)object).funcType) {
            return super.equals(object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.opType + this.funcType;
    }

    @Override
    public String describe(Session session, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\n');
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("FUNCTION ").append("=[\n");
        stringBuffer.append(this.name).append("(");
        for (n2 = 0; n2 < this.nodes.length; ++n2) {
            stringBuffer.append("[").append(this.nodes[n2].describe(session)).append("]");
        }
        stringBuffer.append(") returns ").append(this.dataType.getNameString());
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public boolean isValueFunction() {
        return this.isSQLValueFunction;
    }

    static {
        regularFuncMap.put("POSITION", 1);
        regularFuncMap.put("POSITION_REGEX", 4);
        regularFuncMap.put("EXTRACT", 5);
        regularFuncMap.put("BIT_LENGTH", 6);
        regularFuncMap.put("CHAR_LENGTH", 7);
        regularFuncMap.put("CHARACTER_LENGTH", 7);
        regularFuncMap.put("OCTET_LENGTH", 8);
        regularFuncMap.put("ABS", 10);
        regularFuncMap.put("MOD", 11);
        regularFuncMap.put("LN", 12);
        regularFuncMap.put("EXP", 13);
        regularFuncMap.put("POWER", 14);
        regularFuncMap.put("SQRT", 15);
        regularFuncMap.put("FLOOR", 16);
        regularFuncMap.put("CEILING", 17);
        regularFuncMap.put("CEIL", 17);
        regularFuncMap.put("WIDTH_BUCKET", 20);
        regularFuncMap.put("SUBSTRING", 21);
        regularFuncMap.put("SUBSTRING_REGEX", 23);
        regularFuncMap.put("LOWER", 24);
        regularFuncMap.put("UPPER", 25);
        regularFuncMap.put("TRIM", 29);
        regularFuncMap.put("OVERLAY", 30);
        regularFuncMap.put("TRIM", 33);
        valueFuncMap.put("CURRENT_DATE", 41);
        valueFuncMap.put("CURRENT_TIME", 42);
        valueFuncMap.put("CURRENT_TIMESTAMP", 43);
        valueFuncMap.put("LOCALTIME", 44);
        valueFuncMap.put("LOCALTIMESTAMP", 50);
        valueFuncMap.put("CURRENT_CATALOG", 51);
        valueFuncMap.put("CURRENT_PATH", 53);
        valueFuncMap.put("CURRENT_ROLE", 54);
        valueFuncMap.put("CURRENT_SCHEMA", 55);
        valueFuncMap.put("CURRENT_USER", 57);
        valueFuncMap.put("SESSION_USER", 58);
        valueFuncMap.put("SYSTEM_USER", 59);
        valueFuncMap.put("USER", 60);
        valueFuncMap.put("VALUE", 61);
        nonDeterministicFuncSet.addAll(valueFuncMap.values());
    }
}

