/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDML;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCompound;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementExpression;
import org.hsqldb.StatementHandler;
import org.hsqldb.StatementProcedure;
import org.hsqldb.StatementSchema;
import org.hsqldb.StatementSet;
import org.hsqldb.StatementSimple;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.Token;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.types.Type;

public class ParserRoutine
extends ParserDML {
    ParserRoutine(Session session, Scanner scanner) {
        super(session, scanner);
    }

    Expression readDefaultClause(Type type) {
        Object object;
        Expression expression = null;
        boolean bl = false;
        if (type.isDateTimeType() || type.isIntervalType()) {
            switch (this.token.tokenType) {
                case 71: 
                case 138: 
                case 279: 
                case 280: {
                    expression = this.readDateTimeIntervalLiteral();
                    if (expression.dataType.typeCode != type.typeCode) {
                        throw this.unexpectedToken();
                    }
                    Object object2 = expression.getValue(this.session, type);
                    return new ExpressionValue(object2, type);
                }
                case 845: {
                    break;
                }
                default: {
                    expression = this.XreadDateTimeValueFunctionOrNull();
                    break;
                }
            }
        } else if (type.isNumberType()) {
            if (this.token.tokenType == 793) {
                this.read();
                bl = true;
            }
        } else if (type.isCharacterType()) {
            switch (this.token.tokenType) {
                case 59: 
                case 62: 
                case 63: 
                case 64: 
                case 68: 
                case 251: 
                case 275: 
                case 303: {
                    object = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                    expression = this.readSQLFunction((FunctionSQL)object);
                    break;
                }
            }
        } else if (type.isBooleanType()) {
            switch (this.token.tokenType) {
                case 292: {
                    this.read();
                    return Expression.EXPR_TRUE;
                }
                case 105: {
                    this.read();
                    return Expression.EXPR_FALSE;
                }
            }
        }
        if (expression == null) {
            if (this.token.tokenType == 184) {
                this.read();
                return new ExpressionValue(null, type);
            }
            if (this.token.tokenType == 845) {
                object = type.convertToType(this.session, this.token.tokenValue, this.token.dataType);
                this.read();
                if (bl) {
                    object = type.negate(object);
                }
                return new ExpressionValue(object, type);
            }
            throw this.unexpectedToken();
        }
        expression.resolveTypes(this.session, null);
        if (type.typeComparisonGroup != expression.getDataType().typeComparisonGroup) {
            throw Error.error(5562);
        }
        return expression;
    }

    Statement compileSelectSingleRowStatement(RangeVariable[] rangeVariableArray) {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        QuerySpecification querySpecification = this.XreadSelect();
        this.readThis(139);
        this.readColumnNamesForSelectInto(orderedHashSet, rangeVariableArray);
        this.XreadTableExpression(querySpecification);
        querySpecification.setReturningResult();
        int[] nArray = new int[orderedHashSet.size()];
        ColumnSchema[] columnSchemaArray = new ColumnSchema[orderedHashSet.size()];
        ParserRoutine.setVariables(rangeVariableArray, orderedHashSet, nArray, columnSchemaArray);
        Type[] typeArray = new Type[columnSchemaArray.length];
        for (int i = 0; i < columnSchemaArray.length; ++i) {
            if (columnSchemaArray[i].getParameterMode() == 1) {
                throw Error.error(2500);
            }
            typeArray[i] = columnSchemaArray[i].getDataType();
        }
        querySpecification.resolve(this.session, rangeVariableArray, typeArray);
        if (querySpecification.getColumnCount() != columnSchemaArray.length) {
            throw Error.error(5564, "INTO");
        }
        StatementSet statementSet = new StatementSet(this.session, this.compileContext, columnSchemaArray, querySpecification, nArray);
        return statementSet;
    }

    Statement compileSetStatement(RangeVariable[] rangeVariableArray) {
        this.read();
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        this.readSetClauseList(rangeVariableArray, orderedHashSet, hsqlArrayList);
        if (hsqlArrayList.size() > 1) {
            throw Error.error(5602);
        }
        Expression expression = (Expression)hsqlArrayList.get(0);
        if (expression.getDegree() != orderedHashSet.size()) {
            throw Error.error(5546, "SET");
        }
        int[] nArray = new int[orderedHashSet.size()];
        ColumnSchema[] columnSchemaArray = new ColumnSchema[orderedHashSet.size()];
        ParserRoutine.setVariables(rangeVariableArray, orderedHashSet, nArray, columnSchemaArray);
        HsqlList hsqlList = expression.resolveColumnReferences(rangeVariableArray, rangeVariableArray.length, null, true);
        hsqlList = Expression.resolveColumnSet(rangeVariableArray, hsqlList, null);
        ExpressionColumn.checkColumnsResolved(hsqlList);
        expression.resolveTypes(this.session, null);
        for (int i = 0; i < columnSchemaArray.length; ++i) {
            if (columnSchemaArray[i].getParameterMode() == 1) {
                throw Error.error(2500);
            }
            if (columnSchemaArray[i].getDataType().canBeAssignedFrom(expression.getNodeDataType(i))) continue;
            throw Error.error(5561);
        }
        StatementSet statementSet = new StatementSet(this.session, this.compileContext, columnSchemaArray, expression, nArray);
        return statementSet;
    }

    StatementDMQL compileTriggerSetStatement(Table table, RangeVariable[] rangeVariableArray) {
        this.read();
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        RangeVariable[] rangeVariableArray2 = new RangeVariable[]{rangeVariableArray[1]};
        this.readSetClauseList(rangeVariableArray2, orderedHashSet, hsqlArrayList);
        int[] nArray = table.getColumnIndexes(orderedHashSet);
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        this.resolveUpdateExpressions(table, rangeVariableArray, nArray, expressionArray, RangeVariable.emptyArray);
        StatementSet statementSet = new StatementSet(this.session, table, rangeVariableArray, nArray, expressionArray, this.compileContext);
        return statementSet;
    }

    private static void setVariables(RangeVariable[] rangeVariableArray, OrderedHashSet orderedHashSet, int[] nArray, ColumnSchema[] columnSchemaArray) throws IndexOutOfBoundsException {
        int n = -1;
        block0: for (int i = 0; i < columnSchemaArray.length; ++i) {
            String string = (String)orderedHashSet.get(i);
            for (int j = 0; j < rangeVariableArray.length; ++j) {
                if (rangeVariableArray[j] == null || rangeVariableArray[j].variables == null || (n = rangeVariableArray[j].variables.getIndex(string)) <= -1) continue;
                nArray[i] = n;
                columnSchemaArray[i] = rangeVariableArray[j].getColumn(n);
                continue block0;
            }
        }
    }

    StatementSchema compileCreateProcedureOrFunction() {
        Object object;
        Object object2;
        Object[] objectArray;
        int n = this.token.tokenType == 213 ? 17 : 16;
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(n, false);
        Routine routine = new Routine(n);
        routine.setName(hsqlName);
        this.readThis(795);
        if (this.token.tokenType == 782) {
            this.read();
        } else {
            while (true) {
                objectArray = this.readRoutineParameter(routine);
                routine.addParameter((ColumnSchema)objectArray);
                if (this.token.tokenType != 784) break;
                this.read();
            }
            this.readThis(782);
        }
        if (n != 17) {
            this.readThis(236);
            if (this.token.tokenType == 276) {
                this.read();
                objectArray = new TableDerived(this.database, hsqlName, 10);
                this.readThis(795);
                if (this.token.tokenType == 782) {
                    this.read();
                } else {
                    while (true) {
                        if (((ColumnSchema)(object2 = this.readRoutineParameter(routine))).getName() == null) {
                            throw super.unexpectedToken();
                        }
                        objectArray.addColumn((ColumnSchema)object2);
                        if (this.token.tokenType != 784) break;
                        this.read();
                    }
                    this.readThis(782);
                }
                routine.setReturnTable((TableDerived)objectArray);
            } else {
                objectArray = this.readTypeDefinition(true);
                routine.setReturnType((Type)objectArray);
            }
        }
        this.readRoutineCharacteristics(routine);
        if (this.token.tokenType == 103) {
            if (routine.getLanguage() != 1) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(444);
            this.checkIsValue(1);
            routine.setMethodURL((String)this.token.tokenValue);
            this.read();
            if (this.token.tokenType == 202) {
                this.read();
                this.readThis(517);
                this.readThis(425);
            }
        } else {
            this.startRecording();
            objectArray = this.compileSQLProcedureStatementOrNull(routine, null);
            if (objectArray == null) {
                throw this.unexpectedToken();
            }
            object2 = this.getRecordedStatement();
            object = Token.getSQL((Token[])object2);
            objectArray.setSQL((String)object);
            routine.setProcedure((Statement)objectArray);
        }
        objectArray = new Object[]{routine};
        object2 = this.getLastPart();
        object = new StatementSchema((String)object2, 14, objectArray);
        return object;
    }

    private void readRoutineCharacteristics(Routine routine) {
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        boolean bl = false;
        block16: while (!bl) {
            switch (this.token.tokenType) {
                case 144: {
                    if (!orderedIntHashSet.add(144)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 425) {
                        this.read();
                        routine.setLanguage(1);
                        continue block16;
                    }
                    if (this.token.tokenType == 259) {
                        this.read();
                        routine.setLanguage(2);
                        continue block16;
                    }
                    throw this.unexpectedToken();
                }
                case 202: {
                    if (!orderedIntHashSet.add(202)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(517);
                    if (this.token.tokenType == 425) {
                        this.read();
                        routine.setParameterStyle(1);
                        continue block16;
                    }
                    this.readThis(259);
                    routine.setParameterStyle(2);
                    continue block16;
                }
                case 257: {
                    if (!orderedIntHashSet.add(257)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(24, false);
                    routine.setSpecificName(hsqlName);
                    continue block16;
                }
                case 82: {
                    if (!orderedIntHashSet.add(82)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    routine.setDeterministic(true);
                    continue block16;
                }
                case 181: {
                    if (!orderedIntHashSet.add(82)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(82);
                    routine.setDeterministic(false);
                    continue block16;
                }
                case 169: {
                    if (!orderedIntHashSet.add(259)) {
                        throw this.unexpectedToken();
                    }
                    if (routine.getType() == 16) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(259);
                    this.readThis(378);
                    routine.setDataImpact(4);
                    continue block16;
                }
                case 178: {
                    if (!orderedIntHashSet.add(259)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(259);
                    routine.setDataImpact(1);
                    continue block16;
                }
                case 216: {
                    if (!orderedIntHashSet.add(259)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(259);
                    this.readThis(378);
                    routine.setDataImpact(3);
                    continue block16;
                }
                case 375: {
                    if (!orderedIntHashSet.add(259)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(259);
                    routine.setDataImpact(2);
                    continue block16;
                }
                case 236: {
                    if (!orderedIntHashSet.add(184) || routine.isProcedure()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(184);
                    this.readThis(192);
                    this.readThis(184);
                    this.readThis(419);
                    routine.setNullInputOutput(true);
                    continue block16;
                }
                case 25: {
                    if (!orderedIntHashSet.add(184) || routine.isProcedure()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(192);
                    this.readThis(184);
                    this.readThis(419);
                    routine.setNullInputOutput(false);
                    continue block16;
                }
                case 88: {
                    if (!orderedIntHashSet.add(234) || routine.isFunction()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(234);
                    this.readThis(508);
                    this.readBigint();
                    continue block16;
                }
                case 177: {
                    if (routine.getType() == 16 || !orderedIntHashSet.add(244)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(244);
                    this.readThis(432);
                    routine.setNewSavepointLevel(true);
                    continue block16;
                }
                case 191: {
                    if (routine.getType() == 16 || !orderedIntHashSet.add(244)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(244);
                    this.readThis(432);
                    routine.setNewSavepointLevel(false);
                    throw super.unsupportedFeature("OLD");
                }
            }
            bl = true;
        }
    }

    private Object[] readLocalDeclarationList(Routine routine, StatementCompound statementCompound) {
        Object[] objectArray;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        while (this.token.tokenType == 76) {
            objectArray = this.readLocalVariableDeclarationOrNull();
            if (objectArray == null) {
                objectArray = this.compileLocalHandlerDeclarationOrNull(routine, statementCompound);
            }
            if (objectArray instanceof ColumnSchema[]) {
                hsqlArrayList.addAll(objectArray);
                continue;
            }
            hsqlArrayList.add(objectArray);
        }
        objectArray = new Object[hsqlArrayList.size()];
        hsqlArrayList.toArray(objectArray);
        return objectArray;
    }

    ColumnSchema[] readLocalVariableDeclarationOrNull() {
        Type type;
        int n = super.getPosition();
        HsqlNameManager.HsqlName[] hsqlNameArray = HsqlNameManager.HsqlName.emptyArray;
        try {
            this.readThis(76);
            if (this.isReservedKey()) {
                this.rewind(n);
                return null;
            }
            while (true) {
                hsqlNameArray = (HsqlNameManager.HsqlName[])ArrayUtil.resizeArray(hsqlNameArray, hsqlNameArray.length + 1);
                hsqlNameArray[hsqlNameArray.length - 1] = super.readNewSchemaObjectName(22, false);
                if (this.token.tokenType != 784) break;
                this.read();
            }
            type = this.readTypeDefinition(true);
        }
        catch (Exception exception) {
            this.rewind(n);
            return null;
        }
        Expression expression = null;
        if (this.token.tokenType == 77) {
            this.read();
            expression = this.readDefaultClause(type);
        }
        ColumnSchema[] columnSchemaArray = new ColumnSchema[hsqlNameArray.length];
        for (int i = 0; i < hsqlNameArray.length; ++i) {
            columnSchemaArray[i] = new ColumnSchema(hsqlNameArray[i], type, true, false, expression);
            columnSchemaArray[i].setParameterMode((byte)2);
        }
        this.readThis(799);
        return columnSchemaArray;
    }

    private StatementHandler compileLocalHandlerDeclarationOrNull(Routine routine, StatementCompound statementCompound) {
        int n;
        this.readThis(76);
        switch (this.token.tokenType) {
            case 376: {
                this.read();
                n = 5;
                break;
            }
            case 101: {
                this.read();
                n = 6;
                break;
            }
            case 295: {
                this.read();
                n = 7;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(123);
        this.readThis(111);
        StatementHandler statementHandler = new StatementHandler(n);
        boolean bl = false;
        boolean bl2 = true;
        block12: while (!bl) {
            int n2 = 0;
            switch (this.token.tokenType) {
                case 784: {
                    if (bl2) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    bl2 = true;
                    continue block12;
                }
                case 261: {
                    n2 = 4;
                }
                case 260: {
                    if (n2 == 0) {
                        n2 = 1;
                    }
                }
                case 262: {
                    if (n2 == 0) {
                        n2 = 2;
                    }
                }
                case 181: {
                    if (n2 == 0) {
                        n2 = 3;
                    }
                    if (!bl2) {
                        throw this.unexpectedToken();
                    }
                    bl2 = false;
                    this.read();
                    if (n2 == 3) {
                        this.readThis(404);
                    } else if (n2 == 4) {
                        String string = this.parseSQLStateValue();
                        statementHandler.addConditionState(string);
                        continue block12;
                    }
                    statementHandler.addConditionType(n2);
                    continue block12;
                }
            }
            if (bl2) {
                throw this.unexpectedToken();
            }
            bl = true;
        }
        if (this.token.tokenType == 799) {
            this.read();
        } else {
            Statement statement = this.compileSQLProcedureStatementOrNull(routine, statementCompound);
            if (statement == null) {
                throw this.unexpectedToken();
            }
            this.readThis(799);
            statementHandler.addStatement(statement);
        }
        return statementHandler;
    }

    String parseSQLStateValue() {
        this.readIfThis(305);
        this.checkIsValue(1);
        String string = this.token.tokenString;
        if (this.token.tokenString.length() != 5) {
            throw Error.error(5607);
        }
        this.read();
        return string;
    }

    private Statement compileCompoundStatement(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        this.readThis(16);
        this.readThis(13);
        StatementCompound statementCompound2 = new StatementCompound(12, hsqlName);
        statementCompound2.setAtomic(true);
        statementCompound2.setRoot(routine);
        statementCompound2.setParent(statementCompound);
        Object[] objectArray = this.readLocalDeclarationList(routine, statementCompound);
        statementCompound2.setLocalDeclarations(objectArray);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound2);
        statementCompound2.setStatements(statementArray);
        this.readThis(93);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (hsqlName == null) {
                throw this.unexpectedToken();
            }
            if (!hsqlName.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        return statementCompound2;
    }

    private Statement[] compileSQLProcedureStatementList(Routine routine, StatementCompound statementCompound) {
        Statement statement;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        while ((statement = this.compileSQLProcedureStatementOrNull(routine, statementCompound)) != null) {
            this.readThis(799);
            hsqlArrayList.add(statement);
        }
        if (hsqlArrayList.size() == 0) {
            throw this.unexpectedToken();
        }
        Statement[] statementArray = new Statement[hsqlArrayList.size()];
        hsqlArrayList.toArray(statementArray);
        return statementArray;
    }

    Statement compileSQLProcedureStatementOrNull(Routine routine, StatementCompound statementCompound) {
        RangeVariable[] rangeVariableArray;
        Statement statement = null;
        HsqlNameManager.HsqlName hsqlName = null;
        RangeVariable[] rangeVariableArray2 = rangeVariableArray = statementCompound == null ? routine.getParameterRangeVariables() : statementCompound.getRangeVariables();
        if (!routine.isTrigger() && this.isSimpleName() && !this.isReservedKey()) {
            hsqlName = this.readNewSchemaObjectName(21, false);
            this.readThis(783);
        }
        this.compileContext.reset();
        switch (this.token.tokenType) {
            case 249: {
                if (routine.dataImpact == 2) {
                    throw Error.error(5608, routine.getDataImpactString());
                }
                if (hsqlName != null) {
                    throw this.unexpectedToken();
                }
                statement = this.compileSelectSingleRowStatement(rangeVariableArray);
                break;
            }
            case 133: {
                if (routine.dataImpact != 4) {
                    throw Error.error(5608, routine.getDataImpactString());
                }
                if (hsqlName != null) {
                    throw this.unexpectedToken();
                }
                statement = this.compileInsertStatement(rangeVariableArray);
                break;
            }
            case 301: {
                if (routine.dataImpact != 4) {
                    throw Error.error(5608, routine.getDataImpactString());
                }
                if (hsqlName != null) {
                    throw this.unexpectedToken();
                }
                statement = this.compileUpdateStatement(rangeVariableArray);
                break;
            }
            case 78: 
            case 293: {
                if (routine.dataImpact != 4) {
                    throw Error.error(5608, routine.getDataImpactString());
                }
                if (hsqlName != null) {
                    throw this.unexpectedToken();
                }
                statement = this.compileDeleteStatement(rangeVariableArray);
                break;
            }
            case 164: {
                if (routine.dataImpact != 4) {
                    throw Error.error(5608, routine.getDataImpactString());
                }
                if (hsqlName != null) {
                    throw this.unexpectedToken();
                }
                statement = this.compileMergeStatement(rangeVariableArray);
                break;
            }
            case 252: {
                if (hsqlName != null) {
                    throw this.unexpectedToken();
                }
                if (routine.isTrigger()) {
                    if (routine.triggerOperation == 19) {
                        throw this.unexpectedToken();
                    }
                    if (routine.triggerType != 4) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileTriggerSetStatement(routine.triggerTable, rangeVariableArray);
                    break;
                }
                statement = this.compileSetStatement(rangeVariableArray);
                break;
            }
            case 24: {
                if (hsqlName != null) {
                    throw this.unexpectedToken();
                }
                statement = this.compileCallStatement(rangeVariableArray, true);
                Routine routine2 = ((StatementProcedure)statement).procedure;
                if (routine2 == null) break;
                switch (routine.dataImpact) {
                    case 2: {
                        if (routine2.dataImpact == 3 || routine2.dataImpact == 4) {
                            throw Error.error(5608, routine.getDataImpactString());
                        }
                    }
                    case 3: {
                        if (routine.dataImpact != 4) break;
                        throw Error.error(5608, routine.getDataImpactString());
                    }
                }
                break;
            }
            case 235: {
                if (routine.isTrigger() || hsqlName != null) {
                    throw this.unexpectedToken();
                }
                this.read();
                statement = this.compileReturnValue(routine, statementCompound);
                break;
            }
            case 16: {
                statement = this.compileCompoundStatement(routine, statementCompound, hsqlName);
                break;
            }
            case 320: {
                if (routine.isTrigger()) {
                    throw this.unexpectedToken();
                }
                statement = this.compileWhile(routine, statementCompound, hsqlName);
                break;
            }
            case 232: {
                if (routine.isTrigger()) {
                    throw this.unexpectedToken();
                }
                statement = this.compileRepeat(routine, statementCompound, hsqlName);
                break;
            }
            case 158: {
                if (routine.isTrigger()) {
                    throw this.unexpectedToken();
                }
                statement = this.compileLoop(routine, statementCompound, hsqlName);
                break;
            }
            case 111: {
                if (routine.isTrigger()) {
                    throw this.unexpectedToken();
                }
                statement = this.compileFor(routine, statementCompound, hsqlName);
                break;
            }
            case 141: {
                if (routine.isTrigger() || hsqlName != null) {
                    throw this.unexpectedToken();
                }
                statement = this.compileIterate();
                break;
            }
            case 150: {
                if (routine.isTrigger() || hsqlName != null) {
                    throw this.unexpectedToken();
                }
                statement = this.compileLeave(routine, statementCompound);
                break;
            }
            case 412: {
                if (routine.isTrigger() || hsqlName != null) {
                    throw this.unexpectedToken();
                }
                statement = this.compileIf(routine, statementCompound);
                break;
            }
            case 28: {
                if (routine.isTrigger() || hsqlName != null) {
                    throw this.unexpectedToken();
                }
                statement = this.compileCase(routine, statementCompound);
                break;
            }
            case 253: {
                if (routine.isTrigger() || hsqlName != null) {
                    throw this.unexpectedToken();
                }
                statement = this.compileSignal(routine, statementCompound, hsqlName);
                break;
            }
            case 233: {
                if (routine.isTrigger() || hsqlName != null) {
                    throw this.unexpectedToken();
                }
                statement = this.compileResignal(routine, statementCompound, hsqlName);
                break;
            }
            default: {
                return null;
            }
        }
        statement.setRoot(routine);
        statement.setParent(statementCompound);
        return statement;
    }

    private Statement compileReturnValue(Routine routine, StatementCompound statementCompound) {
        Expression expression = this.XreadValueExpressionOrNull();
        if (expression == null) {
            this.checkIsValue();
            if (this.token.tokenValue == null) {
                expression = new ExpressionValue(null, null);
            }
        }
        this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
        if (routine.isProcedure()) {
            throw Error.error(5602);
        }
        return new StatementExpression(this.session, this.compileContext, 58, expression);
    }

    private Statement compileIterate() {
        this.readThis(141);
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(21, false);
        return new StatementSimple(102, hsqlName);
    }

    private Statement compileLeave(Routine routine, StatementCompound statementCompound) {
        this.readThis(150);
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(21, false);
        return new StatementSimple(89, hsqlName);
    }

    private Statement compileWhile(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        this.readThis(320);
        Expression expression = this.XreadBooleanValueExpression();
        this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
        StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1101, expression);
        this.readThis(85);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
        this.readThis(93);
        this.readThis(320);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (hsqlName == null) {
                throw this.unexpectedToken();
            }
            if (!hsqlName.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statementCompound2 = new StatementCompound(97, hsqlName);
        statementCompound2.setStatements(statementArray);
        statementCompound2.setCondition(statementExpression);
        return statementCompound2;
    }

    private Statement compileRepeat(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        this.readThis(232);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
        this.readThis(300);
        Expression expression = this.XreadBooleanValueExpression();
        this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
        StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1101, expression);
        this.readThis(93);
        this.readThis(232);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (hsqlName == null) {
                throw this.unexpectedToken();
            }
            if (!hsqlName.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statementCompound2 = new StatementCompound(95, hsqlName);
        statementCompound2.setStatements(statementArray);
        statementCompound2.setCondition(statementExpression);
        return statementCompound2;
    }

    private Statement compileLoop(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        this.readThis(158);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
        this.readThis(93);
        this.readThis(158);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (hsqlName == null) {
                throw this.unexpectedToken();
            }
            if (!hsqlName.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statementCompound2 = new StatementCompound(90, hsqlName);
        statementCompound2.setStatements(statementArray);
        return statementCompound2;
    }

    private Statement compileFor(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        this.readThis(111);
        StatementDMQL statementDMQL = this.compileCursorSpecification(0);
        this.readThis(85);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
        this.readThis(93);
        this.readThis(111);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (hsqlName == null) {
                throw this.unexpectedToken();
            }
            if (!hsqlName.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statementCompound2 = new StatementCompound(46, hsqlName);
        statementCompound2.setLoopStatement(statementDMQL);
        statementCompound2.setStatements(statementArray);
        return statementCompound2;
    }

    private Statement compileIf(Routine routine, StatementCompound statementCompound) {
        int n;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        this.readThis(412);
        Expression expression = this.XreadBooleanValueExpression();
        this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
        StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1101, expression);
        hsqlArrayList.add(statementExpression);
        this.readThis(278);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
        for (n = 0; n < statementArray.length; ++n) {
            hsqlArrayList.add(statementArray[n]);
        }
        while (this.token.tokenType == 92) {
            this.read();
            expression = this.XreadBooleanValueExpression();
            this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
            statementExpression = new StatementExpression(this.session, this.compileContext, 1101, expression);
            hsqlArrayList.add(statementExpression);
            this.readThis(278);
            statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
            for (n = 0; n < statementArray.length; ++n) {
                hsqlArrayList.add(statementArray[n]);
            }
        }
        if (this.token.tokenType == 91) {
            this.read();
            expression = Expression.EXPR_TRUE;
            statementExpression = new StatementExpression(this.session, this.compileContext, 1101, expression);
            hsqlArrayList.add(statementExpression);
            statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
            for (n = 0; n < statementArray.length; ++n) {
                hsqlArrayList.add(statementArray[n]);
            }
        }
        this.readThis(93);
        this.readThis(412);
        statementArray = new Statement[hsqlArrayList.size()];
        hsqlArrayList.toArray(statementArray);
        StatementCompound statementCompound2 = new StatementCompound(88, null);
        statementCompound2.setStatements(statementArray);
        return statementCompound2;
    }

    private Statement compileCase(Routine routine, StatementCompound statementCompound) {
        Statement[] statementArray;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Expression expression = null;
        this.readThis(28);
        hsqlArrayList = this.token.tokenType == 312 ? this.readCaseWhen(routine, statementCompound) : this.readSimpleCaseWhen(routine, statementCompound);
        if (this.token.tokenType == 91) {
            this.read();
            expression = Expression.EXPR_TRUE;
            StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1101, expression);
            hsqlArrayList.add(statementExpression);
            statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
            for (int i = 0; i < statementArray.length; ++i) {
                hsqlArrayList.add(statementArray[i]);
            }
        }
        this.readThis(93);
        this.readThis(28);
        statementArray = new Statement[hsqlArrayList.size()];
        hsqlArrayList.toArray(statementArray);
        StatementCompound statementCompound2 = new StatementCompound(88, null);
        statementCompound2.setStatements(statementArray);
        return statementCompound2;
    }

    private HsqlArrayList readSimpleCaseWhen(Routine routine, StatementCompound statementCompound) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Expression expression = null;
        Expression expression2 = this.XreadRowValuePredicand();
        do {
            this.readThis(312);
            while (true) {
                Expression expression3;
                if (expression2 == (expression3 = this.XreadPredicateRightPart(expression2))) {
                    expression3 = new ExpressionLogical(expression2, this.XreadRowValuePredicand());
                }
                this.resolveOuterReferencesAndTypes(routine, statementCompound, expression3);
                expression = expression == null ? expression3 : new ExpressionLogical(50, expression, expression3);
                if (this.token.tokenType != 784) break;
                this.read();
            }
            StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1101, expression);
            hsqlArrayList.add(statementExpression);
            this.readThis(278);
            Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
            for (int i = 0; i < statementArray.length; ++i) {
                hsqlArrayList.add(statementArray[i]);
            }
        } while (this.token.tokenType == 312);
        return hsqlArrayList;
    }

    private HsqlArrayList readCaseWhen(Routine routine, StatementCompound statementCompound) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Expression expression = null;
        do {
            this.readThis(312);
            expression = this.XreadBooleanValueExpression();
            this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
            StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1101, expression);
            hsqlArrayList.add(statementExpression);
            this.readThis(278);
            Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
            for (int i = 0; i < statementArray.length; ++i) {
                hsqlArrayList.add(statementArray[i]);
            }
        } while (this.token.tokenType == 312);
        return hsqlArrayList;
    }

    private Statement compileSignal(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        this.readThis(253);
        this.readThis(261);
        String string = this.parseSQLStateValue();
        StatementSimple statementSimple = new StatementSimple(92, string);
        return statementSimple;
    }

    private Statement compileResignal(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        String string = null;
        this.readThis(233);
        if (this.readIfThis(261)) {
            string = this.parseSQLStateValue();
        }
        StatementSimple statementSimple = new StatementSimple(91, string);
        return statementSimple;
    }

    private ColumnSchema readRoutineParameter(Routine routine) {
        HsqlNameManager.HsqlName hsqlName = null;
        byte by = 1;
        switch (this.token.tokenType) {
            case 128: {
                this.read();
                break;
            }
            case 197: {
                if (routine.getType() != 17) {
                    throw this.unexpectedToken();
                }
                this.read();
                by = 4;
                break;
            }
            case 131: {
                if (routine.getType() != 17) {
                    throw this.unexpectedToken();
                }
                this.read();
                by = 2;
                break;
            }
        }
        if (!this.isReservedKey()) {
            hsqlName = this.readNewDependentSchemaObjectName(routine.getName(), 23);
        }
        Type type = this.readTypeDefinition(true);
        ColumnSchema columnSchema = new ColumnSchema(hsqlName, type, true, false, null);
        columnSchema.setParameterMode(by);
        return columnSchema;
    }

    void resolveOuterReferencesAndTypes(Routine routine, StatementCompound statementCompound, Expression expression) {
        RangeVariable[] rangeVariableArray = routine.getParameterRangeVariables();
        if (statementCompound != null) {
            rangeVariableArray = statementCompound.getRangeVariables();
        }
        HsqlList hsqlList = expression.resolveColumnReferences(rangeVariableArray, rangeVariableArray.length, null, false);
        hsqlList = Expression.resolveColumnSet(rangeVariableArray, hsqlList, null);
        ExpressionColumn.checkColumnsResolved(hsqlList);
        expression.resolveTypes(this.session, null);
    }
}

