/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ParserDQL;
import org.hsqldb.RangeVariable;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;

public class RangeVariableResolver {
    RangeVariable[] rangeVariables;
    Expression conditions;
    OrderedHashSet rangeVarSet = new OrderedHashSet();
    ParserDQL.CompileContext compileContext;
    HsqlArrayList[] tempJoinExpressions;
    HsqlArrayList[] joinExpressions;
    HsqlArrayList[] whereExpressions;
    HsqlArrayList queryExpressions = new HsqlArrayList();
    Expression[] inExpressions;
    boolean[] inInJoin;
    int inExpressionCount = 0;
    boolean hasOuterJoin = false;
    OrderedIntHashSet colIndexSetEqual = new OrderedIntHashSet();
    OrderedIntHashSet colIndexSetOther = new OrderedIntHashSet();
    OrderedHashSet tempSet = new OrderedHashSet();
    MultiValueHashMap tempMap = new MultiValueHashMap();

    RangeVariableResolver(RangeVariable[] rangeVariableArray, Expression expression, ParserDQL.CompileContext compileContext) {
        int n;
        this.rangeVariables = rangeVariableArray;
        this.conditions = expression;
        this.compileContext = compileContext;
        for (n = 0; n < rangeVariableArray.length; ++n) {
            RangeVariable rangeVariable = rangeVariableArray[n];
            this.rangeVarSet.add(rangeVariable);
            if (!rangeVariable.isLeftJoin && !rangeVariable.isRightJoin) continue;
            this.hasOuterJoin = true;
        }
        this.inExpressions = new Expression[rangeVariableArray.length];
        this.inInJoin = new boolean[rangeVariableArray.length];
        this.tempJoinExpressions = new HsqlArrayList[rangeVariableArray.length];
        for (n = 0; n < rangeVariableArray.length; ++n) {
            this.tempJoinExpressions[n] = new HsqlArrayList();
        }
        this.joinExpressions = new HsqlArrayList[rangeVariableArray.length];
        for (n = 0; n < rangeVariableArray.length; ++n) {
            this.joinExpressions[n] = new HsqlArrayList();
        }
        this.whereExpressions = new HsqlArrayList[rangeVariableArray.length];
        for (n = 0; n < rangeVariableArray.length; ++n) {
            this.whereExpressions[n] = new HsqlArrayList();
        }
    }

    void processConditions() {
        RangeVariableResolver.decomposeAndConditions(this.conditions, this.queryExpressions);
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            if (this.rangeVariables[i].joinCondition == null) continue;
            RangeVariableResolver.decomposeAndConditions(this.rangeVariables[i].joinCondition, this.tempJoinExpressions[i]);
            this.rangeVariables[i].joinCondition = null;
        }
        this.conditions = null;
        this.assignToLists();
        this.expandConditions();
        this.assignToRangeVariables();
    }

    static Expression decomposeAndConditions(Expression expression, HsqlArrayList hsqlArrayList) {
        if (expression == null) {
            return Expression.EXPR_TRUE;
        }
        Expression expression2 = expression.getLeftNode();
        Expression expression3 = expression.getRightNode();
        int n = expression.getType();
        if (n == 49) {
            expression2 = RangeVariableResolver.decomposeAndConditions(expression2, hsqlArrayList);
            expression3 = RangeVariableResolver.decomposeAndConditions(expression3, hsqlArrayList);
            if (expression2 == Expression.EXPR_TRUE) {
                return expression3;
            }
            if (expression3 == Expression.EXPR_TRUE) {
                return expression2;
            }
            expression.setLeftNode(expression2);
            expression.setRightNode(expression3);
            return expression;
        }
        if (n == 41 && expression2.getType() == 25 && expression3.getType() == 25) {
            for (int i = 0; i < expression2.nodes.length; ++i) {
                ExpressionLogical expressionLogical = new ExpressionLogical(expression2.nodes[i], expression3.nodes[i]);
                ((Expression)expressionLogical).resolveTypes(null, null);
                hsqlArrayList.add(expressionLogical);
            }
            return Expression.EXPR_TRUE;
        }
        if (expression != Expression.EXPR_TRUE) {
            hsqlArrayList.add(expression);
        }
        return Expression.EXPR_TRUE;
    }

    static Expression decomposeOrConditions(Expression expression, HsqlArrayList hsqlArrayList) {
        if (expression == null) {
            return Expression.EXPR_FALSE;
        }
        Expression expression2 = expression.getLeftNode();
        Expression expression3 = expression.getRightNode();
        int n = expression.getType();
        if (n == 50) {
            expression2 = RangeVariableResolver.decomposeOrConditions(expression2, hsqlArrayList);
            expression3 = RangeVariableResolver.decomposeOrConditions(expression3, hsqlArrayList);
            if (expression2 == Expression.EXPR_FALSE) {
                return expression3;
            }
            if (expression3 == Expression.EXPR_FALSE) {
                return expression2;
            }
            expression.setLeftNode(expression2);
            expression.setRightNode(expression3);
            return expression;
        }
        if (expression != Expression.EXPR_FALSE) {
            hsqlArrayList.add(expression);
        }
        return Expression.EXPR_FALSE;
    }

    void assignToLists() {
        int n;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < this.rangeVariables.length; ++n) {
            if (this.rangeVariables[n].isLeftJoin) {
                n2 = n;
            }
            if (this.rangeVariables[n].isRightJoin) {
                n2 = n;
                n3 = n;
            }
            if (n2 == n) {
                this.joinExpressions[n].addAll(this.tempJoinExpressions[n]);
                continue;
            }
            for (int i = 0; i < this.tempJoinExpressions[n].size(); ++i) {
                this.assignToJoinLists((Expression)this.tempJoinExpressions[n].get(i), this.joinExpressions, n2 + 1);
            }
        }
        for (n = 0; n < this.queryExpressions.size(); ++n) {
            this.assignToWhereLists((Expression)this.queryExpressions.get(n), this.whereExpressions, n3);
        }
    }

    void assignToJoinLists(Expression expression, HsqlArrayList[] hsqlArrayListArray, int n) {
        this.tempSet.clear();
        expression.collectRangeVariables(this.rangeVariables, this.tempSet);
        int n2 = this.rangeVarSet.getLargestIndex(this.tempSet);
        if (n2 == -1) {
            n2 = 0;
        }
        if (this.tempSet.size() == 1) {
            switch (expression.getType()) {
                default: 
            }
        }
        if (n2 < n) {
            n2 = n;
        }
        hsqlArrayListArray[n2].add(expression);
    }

    void assignToWhereLists(Expression expression, HsqlArrayList[] hsqlArrayListArray, int n) {
        this.tempSet.clear();
        expression.collectRangeVariables(this.rangeVariables, this.tempSet);
        int n2 = this.rangeVarSet.getLargestIndex(this.tempSet);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n2 < n) {
            n2 = n;
        }
        hsqlArrayListArray[n2].add(expression);
    }

    void expandConditions() {
        this.expandConditions(this.whereExpressions, false);
        this.expandConditions(this.joinExpressions, false);
    }

    void expandConditions(HsqlArrayList[] hsqlArrayListArray, boolean bl) {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            Object object;
            HsqlArrayList hsqlArrayList = hsqlArrayListArray[i];
            this.tempMap.clear();
            this.tempSet.clear();
            boolean bl2 = false;
            for (int j = 0; j < hsqlArrayList.size(); ++j) {
                object = (Expression)hsqlArrayList.get(j);
                if (!((Expression)object).isColumnEqual || ((Expression)object).getLeftNode().getRangeVariable() == ((Expression)object).getRightNode().getRangeVariable()) continue;
                if (((Expression)object).getLeftNode().getRangeVariable() == this.rangeVariables[i]) {
                    this.tempMap.put(((Expression)object).getLeftNode().getColumn(), ((Expression)object).getRightNode());
                    if (this.tempSet.add(((Expression)object).getLeftNode().getColumn())) continue;
                    bl2 = true;
                    continue;
                }
                this.tempMap.put(((Expression)object).getRightNode().getColumn(), ((Expression)object).getLeftNode());
                if (this.tempSet.add(((Expression)object).getRightNode().getColumn())) continue;
                bl2 = true;
            }
            if (!bl2 || this.hasOuterJoin && bl) continue;
            Iterator iterator = this.tempMap.keySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                Iterator iterator2 = this.tempMap.get(object);
                this.tempSet.clear();
                while (iterator2.hasNext()) {
                    this.tempSet.add(iterator2.next());
                }
                while (this.tempSet.size() > 1) {
                    Expression expression = (Expression)this.tempSet.remove(this.tempSet.size() - 1);
                    for (int j = 0; j < this.tempSet.size(); ++j) {
                        Expression expression2 = (Expression)this.tempSet.get(j);
                        this.closeJoinChain(hsqlArrayListArray, expression, expression2);
                    }
                }
            }
        }
    }

    void closeJoinChain(HsqlArrayList[] hsqlArrayListArray, Expression expression, Expression expression2) {
        int n;
        int n2 = this.rangeVarSet.getIndex(expression.getRangeVariable());
        int n3 = n2 > (n = this.rangeVarSet.getIndex(expression2.getRangeVariable())) ? n2 : n;
        ExpressionLogical expressionLogical = new ExpressionLogical(expression, expression2);
        for (int i = 0; i < hsqlArrayListArray[n3].size(); ++i) {
            if (!expressionLogical.equals(hsqlArrayListArray[n3].get(i))) continue;
            return;
        }
        hsqlArrayListArray[n3].add(expressionLogical);
    }

    void assignToRangeVariables() {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            RangeVariable.RangeVariableConditions rangeVariableConditions;
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = bl = this.rangeVariables[i].isLeftJoin || this.rangeVariables[i].isRightJoin;
            if (bl) {
                rangeVariableConditions = this.rangeVariables[i].joinConditions[0];
                this.assignToRangeVariable(this.rangeVariables[i], rangeVariableConditions, i, this.joinExpressions[i]);
                rangeVariableConditions = this.rangeVariables[i].joinConditions[0];
                if (rangeVariableConditions.hasIndexCondition()) {
                    bl2 = true;
                }
                rangeVariableConditions = this.rangeVariables[i].whereConditions[0];
                if (this.rangeVariables[i].isRightJoin) {
                    this.assignToRangeVariable(rangeVariableConditions, this.whereExpressions[i]);
                    this.assignToRangeVariable(this.rangeVariables[i], rangeVariableConditions, i, this.whereExpressions[i]);
                } else if (bl2) {
                    this.assignToRangeVariable(rangeVariableConditions, this.whereExpressions[i]);
                } else {
                    this.assignToRangeVariable(this.rangeVariables[i], rangeVariableConditions, i, this.whereExpressions[i]);
                }
                rangeVariableConditions = this.rangeVariables[i].whereConditions[0];
                if (rangeVariableConditions.hasIndexCondition()) {
                    bl2 = true;
                }
            } else {
                rangeVariableConditions = this.rangeVariables[i].joinConditions[0];
                this.joinExpressions[i].addAll(this.whereExpressions[i]);
                this.assignToRangeVariable(this.rangeVariables[i], rangeVariableConditions, i, this.joinExpressions[i]);
                rangeVariableConditions = this.rangeVariables[i].joinConditions[0];
                if (rangeVariableConditions.hasIndexCondition()) {
                    bl2 = true;
                }
            }
            if (this.inExpressions[i] == null || !bl2) continue;
            if (!this.inInJoin[i] && bl) {
                this.rangeVariables[i].whereConditions[0].addCondition(this.inExpressions[i]);
            } else {
                this.rangeVariables[i].joinConditions[0].addCondition(this.inExpressions[i]);
            }
            this.inExpressions[i] = null;
            --this.inExpressionCount;
        }
        if (this.inExpressionCount != 0) {
            this.setInConditionsAsTables();
        }
    }

    void assignToRangeVariable(RangeVariable.RangeVariableConditions rangeVariableConditions, HsqlArrayList hsqlArrayList) {
        int n = hsqlArrayList.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = (Expression)hsqlArrayList.get(i);
            rangeVariableConditions.addCondition(expression);
        }
    }

    void assignToRangeVariable(RangeVariable rangeVariable, RangeVariable.RangeVariableConditions rangeVariableConditions, int n, HsqlArrayList hsqlArrayList) {
        if (hsqlArrayList.isEmpty()) {
            return;
        }
        int n2 = hsqlArrayList.size();
        for (int i = 0; i < n2; ++i) {
            Expression expression = (Expression)hsqlArrayList.get(i);
            if (!expression.isIndexable(rangeVariable)) {
                rangeVariableConditions.addCondition(expression);
                hsqlArrayList.set(i, null);
                continue;
            }
            if (expression.getType() != 41 || expression.exprSubType != 52) continue;
            OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
            ((ExpressionLogical)expression).addLeftColumnsForAllAny(orderedIntHashSet);
            Index index = rangeVariable.rangeTable.getIndexForColumns(orderedIntHashSet, false);
            if (index == null || this.inExpressions[n] != null) continue;
            this.inExpressions[n] = expression;
            this.inInJoin[n] = rangeVariableConditions.isJoin;
            ++this.inExpressionCount;
            hsqlArrayList.set(i, null);
        }
        if (this.inExpressions[n] == null) {
            this.setIndexConditions(rangeVariableConditions, hsqlArrayList, true);
        } else {
            this.assignToRangeVariable(rangeVariableConditions, hsqlArrayList);
        }
    }

    private void setIndexConditions(RangeVariable.RangeVariableConditions rangeVariableConditions, HsqlArrayList hsqlArrayList, boolean bl) {
        int n;
        this.colIndexSetEqual.clear();
        this.colIndexSetOther.clear();
        int n2 = hsqlArrayList.size();
        block8: for (int i = 0; i < n2; ++i) {
            Expression expression = (Expression)hsqlArrayList.get(i);
            if (expression == null) continue;
            if (rangeVariableConditions.hasIndexCondition()) {
                rangeVariableConditions.addCondition(expression);
                hsqlArrayList.set(i, null);
                continue;
            }
            if (!expression.isIndexable(rangeVariableConditions.rangeVar)) {
                rangeVariableConditions.addCondition(expression);
                hsqlArrayList.set(i, null);
                continue;
            }
            int n3 = expression.getType();
            switch (n3) {
                case 50: {
                    continue block8;
                }
                case 2: {
                    continue block8;
                }
                case 41: {
                    if (expression.exprSubType == 52) continue block8;
                    n = expression.getLeftNode().getColumnIndex();
                    this.colIndexSetEqual.add(n);
                    continue block8;
                }
                case 47: {
                    n = expression.getLeftNode().getColumnIndex();
                    this.colIndexSetEqual.add(n);
                    continue block8;
                }
                case 48: {
                    n = expression.getLeftNode().getLeftNode().getColumnIndex();
                    this.colIndexSetOther.add(n);
                    continue block8;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    n = expression.getLeftNode().getColumnIndex();
                    this.colIndexSetOther.add(n);
                    continue block8;
                }
                default: {
                    Error.runtimeError(201, "RangeVariableResolver");
                }
            }
        }
        Index index = rangeVariableConditions.rangeVar.rangeTable.getIndexForColumns(this.colIndexSetEqual, false);
        if (index != null) {
            this.setEqaulityConditions(rangeVariableConditions, hsqlArrayList, index);
            return;
        }
        index = rangeVariableConditions.rangeVar.rangeTable.getIndexForColumns(this.colIndexSetOther, false);
        if (index != null) {
            this.setNonEqualityConditions(rangeVariableConditions, hsqlArrayList, index);
            return;
        }
        int n4 = hsqlArrayList.size();
        for (n2 = 0; n2 < n4; ++n2) {
            Expression expression = (Expression)hsqlArrayList.get(n2);
            if (expression == null) continue;
            n = 0;
            if (bl && expression.getType() == 50) {
                boolean bl2 = ((ExpressionLogical)expression).isIndexable(rangeVariableConditions.rangeVar);
                n = this.setOrConditions(rangeVariableConditions, (ExpressionLogical)expression) ? 1 : 0;
            }
            if (n != 0) continue;
            rangeVariableConditions.addCondition(expression);
            hsqlArrayList.set(n2, null);
        }
    }

    private boolean setOrConditions(RangeVariable.RangeVariableConditions rangeVariableConditions, ExpressionLogical expressionLogical) {
        Object object;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        RangeVariableResolver.decomposeOrConditions(expressionLogical, hsqlArrayList);
        Object[] objectArray = new RangeVariable.RangeVariableConditions[hsqlArrayList.size()];
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
            object = (Expression)hsqlArrayList.get(i);
            RangeVariableResolver.decomposeAndConditions((Expression)object, hsqlArrayList2);
            RangeVariable.RangeVariableConditions rangeVariableConditions2 = new RangeVariable.RangeVariableConditions(rangeVariableConditions);
            this.setIndexConditions(rangeVariableConditions2, hsqlArrayList2, false);
            objectArray[i] = rangeVariableConditions2;
            if (rangeVariableConditions2.hasIndexCondition()) continue;
            return false;
        }
        Expression expression = null;
        for (int i = 0; i < objectArray.length; ++i) {
            object = objectArray[i];
            ((RangeVariable.RangeVariableConditions)object).excludeConditions = expression;
            if (((RangeVariable.RangeVariableConditions)object).indexCond != null) {
                for (int j = 0; j < ((RangeVariable.RangeVariableConditions)object).indexedColumnCount; ++j) {
                    expression = ExpressionLogical.andExpressions(expression, ((RangeVariable.RangeVariableConditions)object).indexCond[j]);
                }
            }
            expression = ExpressionLogical.andExpressions(expression, ((RangeVariable.RangeVariableConditions)object).indexEndCondition);
            expression = ExpressionLogical.andExpressions(expression, ((RangeVariable.RangeVariableConditions)object).nonIndexCondition);
        }
        if (rangeVariableConditions.isJoin) {
            rangeVariableConditions.rangeVar.joinConditions = objectArray;
            objectArray = new RangeVariable.RangeVariableConditions[hsqlArrayList.size()];
            ArrayUtil.fillArray(objectArray, rangeVariableConditions.rangeVar.whereConditions[0]);
            rangeVariableConditions.rangeVar.whereConditions = objectArray;
        } else {
            rangeVariableConditions.rangeVar.whereConditions = objectArray;
            objectArray = new RangeVariable.RangeVariableConditions[hsqlArrayList.size()];
            ArrayUtil.fillArray(objectArray, rangeVariableConditions.rangeVar.joinConditions[0]);
            rangeVariableConditions.rangeVar.joinConditions = objectArray;
        }
        return true;
    }

    private void setEqaulityConditions(RangeVariable.RangeVariableConditions rangeVariableConditions, HsqlArrayList hsqlArrayList, Index index) {
        int n;
        int n2;
        int[] nArray = index.getColumns();
        int n3 = nArray.length;
        Expression[] expressionArray = new Expression[nArray.length];
        for (n2 = 0; n2 < hsqlArrayList.size(); ++n2) {
            int n4;
            int n5;
            Expression expression = (Expression)hsqlArrayList.get(n2);
            if (expression == null || (n5 = expression.getType()) != 41 && n5 != 47 || (n4 = ArrayUtil.find(nArray, expression.getLeftNode().getColumnIndex())) == -1 || expressionArray[n4] != null) continue;
            expressionArray[n4] = expression;
            hsqlArrayList.set(n2, null);
        }
        n2 = 0;
        for (n = 0; n < expressionArray.length; ++n) {
            Expression expression = expressionArray[n];
            if (expression == null) {
                if (n3 == nArray.length) {
                    n3 = n;
                }
                n2 = 1;
                continue;
            }
            if (n2 == 0) continue;
            rangeVariableConditions.addCondition(expression);
            expressionArray[n] = null;
        }
        rangeVariableConditions.addIndexCondition(expressionArray, index, n3);
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            Expression expression = (Expression)hsqlArrayList.get(n);
            if (expression == null) continue;
            rangeVariableConditions.addCondition(expression);
            hsqlArrayList.set(n, null);
        }
    }

    private void setNonEqualityConditions(RangeVariable.RangeVariableConditions rangeVariableConditions, HsqlArrayList hsqlArrayList, Index index) {
        int[] nArray = index.getColumns();
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Expression expression = (Expression)hsqlArrayList.get(i);
            if (expression == null) continue;
            if (rangeVariableConditions.hasIndexCondition()) {
                rangeVariableConditions.addCondition(expression);
                hsqlArrayList.set(i, null);
                continue;
            }
            boolean bl = false;
            if (expression.getType() == 48 && expression.getLeftNode().getType() == 47 && nArray[0] == expression.getLeftNode().getLeftNode().getColumnIndex()) {
                bl = true;
            }
            if (nArray[0] == expression.getLeftNode().getColumnIndex()) {
                if (expression.getRightNode() != null && !expression.getRightNode().isCorrelated()) {
                    bl = true;
                }
                if (expression.getType() == 47) {
                    bl = true;
                }
            }
            if (bl) {
                rangeVariableConditions.addIndexCondition(new Expression[]{expression}, index, 1);
            } else {
                rangeVariableConditions.addCondition(expression);
            }
            hsqlArrayList.set(i, null);
        }
    }

    void setInConditionsAsTables() {
        for (int i = this.rangeVariables.length - 1; i >= 0; --i) {
            int n;
            RangeVariable rangeVariable = this.rangeVariables[i];
            ExpressionLogical expressionLogical = (ExpressionLogical)this.inExpressions[i];
            if (expressionLogical == null) continue;
            OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
            expressionLogical.addLeftColumnsForAllAny(orderedIntHashSet);
            Index index = rangeVariable.rangeTable.getIndexForColumns(orderedIntHashSet, false);
            int n2 = 0;
            for (int j = 0; j < index.getColumnCount(); ++j) {
                if (!orderedIntHashSet.contains(index.getColumns()[j])) continue;
                ++n2;
            }
            RangeVariable rangeVariable2 = new RangeVariable(expressionLogical.getRightNode().subQuery.getTable(), null, null, null, this.compileContext);
            RangeVariable[] rangeVariableArray = new RangeVariable[this.rangeVariables.length + 1];
            ArrayUtil.copyAdjustArray(this.rangeVariables, rangeVariableArray, rangeVariable2, i, 1);
            this.rangeVariables = rangeVariableArray;
            Expression[] expressionArray = new Expression[n2];
            for (n = 0; n < n2; ++n) {
                int n3 = index.getColumns()[n];
                int n4 = orderedIntHashSet.getIndex(n3);
                ExpressionLogical expressionLogical2 = new ExpressionLogical(rangeVariable, n3, rangeVariable2, n4);
                expressionArray[n] = expressionLogical2;
            }
            n = this.rangeVariables[i].isLeftJoin || this.rangeVariables[i].isRightJoin ? 1 : 0;
            RangeVariable.RangeVariableConditions rangeVariableConditions = !this.inInJoin[i] && n != 0 ? rangeVariable.whereConditions[0] : rangeVariable.joinConditions[0];
            rangeVariableConditions.addIndexCondition(expressionArray, index, expressionArray.length);
            rangeVariableConditions.addCondition(expressionLogical);
        }
    }
}

