/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementResultUpdate;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.store.ValuePool;

public class SessionContext {
    Session session;
    Boolean isAutoCommit;
    Boolean isReadOnly;
    Boolean noSQL;
    int currentMaxRows;
    HashMappedList sessionVariables;
    RangeVariable[] sessionVariablesRange;
    private HsqlArrayList stack;
    public Object[] routineArguments = ValuePool.emptyObjectArray;
    public Object[] routineVariables = ValuePool.emptyObjectArray;
    Object[] dynamicArguments = ValuePool.emptyObjectArray;
    public int depth;
    HashMappedList savepoints;
    LongDeque savepointTimestamps;
    RangeIterator[] rangeIterators;
    public Statement currentStatement;
    HashSet constraintPath;
    StatementResultUpdate rowUpdateStatement = new StatementResultUpdate();

    SessionContext(Session session) {
        this.session = session;
        this.rangeIterators = new RangeIterator[4];
        this.savepoints = new HashMappedList(4);
        this.savepointTimestamps = new LongDeque();
        this.sessionVariables = new HashMappedList();
        this.sessionVariablesRange = new RangeVariable[1];
        this.sessionVariablesRange[0] = new RangeVariable(this.sessionVariables, true);
        this.isReadOnly = this.noSQL = Boolean.FALSE;
        this.isAutoCommit = this.noSQL;
    }

    public void push() {
        if (this.stack == null) {
            this.stack = new HsqlArrayList(true);
        }
        this.stack.add(this.dynamicArguments);
        this.stack.add(this.routineArguments);
        this.stack.add(this.routineVariables);
        this.stack.add(this.rangeIterators);
        this.stack.add(this.savepoints);
        this.stack.add(this.savepointTimestamps);
        this.stack.add(this.isAutoCommit);
        this.stack.add(this.isReadOnly);
        this.stack.add(this.noSQL);
        this.stack.add(ValuePool.getInt(this.currentMaxRows));
        this.rangeIterators = new RangeIterator[4];
        this.savepoints = new HashMappedList(4);
        this.savepointTimestamps = new LongDeque();
        this.isAutoCommit = Boolean.FALSE;
        this.currentMaxRows = 0;
        ++this.depth;
    }

    public void pop() {
        this.currentMaxRows = (Integer)this.stack.remove(this.stack.size() - 1);
        this.noSQL = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.isReadOnly = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.isAutoCommit = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.savepointTimestamps = (LongDeque)this.stack.remove(this.stack.size() - 1);
        this.savepoints = (HashMappedList)this.stack.remove(this.stack.size() - 1);
        this.rangeIterators = (RangeIterator[])this.stack.remove(this.stack.size() - 1);
        this.routineVariables = (Object[])this.stack.remove(this.stack.size() - 1);
        this.routineArguments = (Object[])this.stack.remove(this.stack.size() - 1);
        this.dynamicArguments = (Object[])this.stack.remove(this.stack.size() - 1);
        --this.depth;
    }

    public void pushDynamicArguments(Object[] objectArray) {
        this.push();
        this.dynamicArguments = objectArray;
    }

    public void setDynamicArguments(Object[] objectArray) {
        this.dynamicArguments = objectArray;
    }

    void clearStructures(StatementDMQL statementDMQL) {
        int n = statementDMQL.rangeIteratorCount;
        if (n > this.rangeIterators.length) {
            n = this.rangeIterators.length;
        }
        for (int i = 0; i < n; ++i) {
            if (this.rangeIterators[i] == null) continue;
            this.rangeIterators[i].reset();
            this.rangeIterators[i] = null;
        }
    }

    public RangeVariable.RangeIteratorBase getCheckIterator(RangeVariable rangeVariable) {
        RangeIterator rangeIterator = this.rangeIterators[1];
        if (rangeIterator == null) {
            this.rangeIterators[1] = rangeIterator = rangeVariable.getIterator(this.session);
        }
        return (RangeVariable.RangeIteratorBase)rangeIterator;
    }

    public void setRangeIterator(RangeIterator rangeIterator) {
        int n = rangeIterator.getRangePosition();
        if (n >= this.rangeIterators.length) {
            this.rangeIterators = (RangeIterator[])ArrayUtil.resizeArray(this.rangeIterators, n + 1);
        }
        this.rangeIterators[rangeIterator.getRangePosition()] = rangeIterator;
    }

    public HashSet getConstraintPath() {
        if (this.constraintPath == null) {
            this.constraintPath = new HashSet();
        } else {
            this.constraintPath.clear();
        }
        return this.constraintPath;
    }

    public void addSessionVariable(ColumnSchema columnSchema) {
        int n = this.sessionVariables.size();
        if (!this.sessionVariables.add(columnSchema.getName().name, columnSchema)) {
            throw Error.error(5504);
        }
        Object[] objectArray = new Object[this.sessionVariables.size()];
        ArrayUtil.copyArray(this.routineVariables, objectArray, this.routineVariables.length);
        this.routineVariables = objectArray;
        this.routineVariables[n] = columnSchema.getDefaultValue(this.session);
    }
}

