/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.QuerySpecification;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.types.Type;

public final class SortAndSlice {
    static final SortAndSlice noSort = new SortAndSlice();
    public int[] sortOrder;
    public boolean[] sortDescending;
    public boolean[] sortNullsLast;
    boolean sortUnion;
    HsqlArrayList exprList = new HsqlArrayList();
    Expression limitCondition;
    public boolean skipSort = false;
    public boolean skipFullResult = false;
    int[] columnIndexes;
    public Index index;

    SortAndSlice() {
    }

    public boolean hasOrder() {
        return this.exprList.size() != 0;
    }

    public boolean hasLimit() {
        return this.limitCondition != null;
    }

    public int getOrderLength() {
        return this.exprList.size();
    }

    public void addOrderExpression(Expression expression) {
        this.exprList.add(expression);
    }

    public void addLimitCondition(Expression expression) {
        this.limitCondition = expression;
    }

    public void prepare(QuerySpecification querySpecification) {
        int n = this.exprList.size();
        boolean bl = false;
        if (n == 0) {
            return;
        }
        this.sortOrder = new int[n];
        this.sortDescending = new boolean[n];
        this.sortNullsLast = new boolean[n];
        for (int i = 0; i < n; ++i) {
            ExpressionOrderBy expressionOrderBy = (ExpressionOrderBy)this.exprList.get(i);
            this.sortOrder[i] = expressionOrderBy.getLeftNode().queryTableColumnIndex == -1 ? querySpecification.indexStartOrderBy + i : expressionOrderBy.getLeftNode().queryTableColumnIndex;
            this.sortDescending[i] = expressionOrderBy.isDescending();
            this.sortNullsLast[i] = expressionOrderBy.isNullsLast();
            bl |= this.sortDescending[i];
            bl |= this.sortNullsLast[i];
        }
        if (querySpecification == null || bl) {
            return;
        }
        if (querySpecification.isDistinctSelect || querySpecification.isGrouped) {
            return;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Expression expression = ((Expression)this.exprList.get(i)).getLeftNode();
            if (expression.getType() != 2) {
                return;
            }
            if (((ExpressionColumn)expression).getRangeVariable() != querySpecification.rangeVariables[0]) {
                return;
            }
            nArray[i] = expression.columnIndex;
        }
        this.columnIndexes = nArray;
    }

    void setSortRange(QuerySpecification querySpecification) {
        Object object;
        if (this.exprList.size() == 0 && this.limitCondition == null) {
            return;
        }
        Index index = querySpecification.rangeVariables[0].getIndex();
        if (index == null) {
            return;
        }
        int[] nArray = index.getColumns();
        if (this.columnIndexes == null) {
            if (!this.hasOrder()) {
                if (querySpecification.isDistinctSelect || querySpecification.isGrouped || querySpecification.isAggregated) {
                    return;
                }
                this.skipFullResult = true;
            }
            return;
        }
        if (nArray.length == 0) {
            Table table = querySpecification.rangeVariables[0].getTable();
            object = table.getFullIndexForColumns(this.columnIndexes);
            if (object != null && querySpecification.rangeVariables[0].setIndex((Index)object)) {
                this.skipSort = true;
                this.skipFullResult = true;
            }
        } else if (ArrayUtil.haveEqualArrays(this.columnIndexes, nArray, this.columnIndexes.length)) {
            this.skipSort = true;
            this.skipFullResult = true;
        }
        for (int i = 0; i < this.exprList.size(); ++i) {
            object = (ExpressionOrderBy)this.exprList.get(i);
            Type type = ((Expression)object).getLeftNode().getDataType();
            if (!type.isLobType()) continue;
            throw Error.error(5534);
        }
    }

    public int getLimitStart(Session session) {
        Integer n;
        if (this.limitCondition != null && (n = (Integer)this.limitCondition.getLeftNode().getValue(session)) != null) {
            return n;
        }
        return 0;
    }

    public int getLimitCount(Session session, int n) {
        Integer n2;
        int n3 = 0;
        if (this.limitCondition != null && (n2 = (Integer)this.limitCondition.getRightNode().getValue(session)) != null) {
            n3 = n2;
        }
        if (n != 0 && (n3 == 0 || n < n3)) {
            n3 = n;
        }
        return n3;
    }

    public void setIndex(TableBase tableBase) {
        try {
            this.index = tableBase.createAndAddIndexStructure(null, this.sortOrder, this.sortDescending, this.sortNullsLast, false, false, false);
        }
        catch (Throwable throwable) {
            throw Error.runtimeError(201, "SortAndSlice");
        }
    }
}

