/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.error.Error;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.Charset;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;
import org.hsqldb.types.UserTypeModifier;

public class SqlInvariants {
    public static final String SYSTEM_AUTHORIZATION_NAME = "_SYSTEM";
    public static final String DBA_ADMIN_ROLE_NAME = "DBA";
    public static final String SCHEMA_CREATE_ROLE_NAME = "CREATE_SCHEMA";
    public static final String CHANGE_AUTH_ROLE_NAME = "CHANGE_AUTHORIZATION";
    public static final String SYSTEM_SUBQUERY = "SYSTEM_SUBQUERY";
    public static final String PUBLIC_ROLE_NAME = "PUBLIC";
    public static final String SYSTEM_SCHEMA = "SYSTEM_SCHEMA";
    public static final String LOBS_SCHEMA = "SYSTEM_LOBS";
    public static final String DEFINITION_SCHEMA = "DEFINITION_SCHEMA";
    public static final String INFORMATION_SCHEMA = "INFORMATION_SCHEMA";
    public static final String SQLJ_SCHEMA = "SQLJ";
    public static final String PUBLIC_SCHEMA = "PUBLIC";
    public static final String CLASSPATH_NAME = "CLASSPATH";
    public static final HsqlNameManager.HsqlName INFORMATION_SCHEMA_HSQLNAME = HsqlNameManager.newSystemObjectName("INFORMATION_SCHEMA", 2);
    public static final HsqlNameManager.HsqlName SYSTEM_SCHEMA_HSQLNAME = HsqlNameManager.newSystemObjectName("SYSTEM_SCHEMA", 2);
    public static final HsqlNameManager.HsqlName LOBS_SCHEMA_HSQLNAME = HsqlNameManager.newSystemObjectName("SYSTEM_LOBS", 2);
    public static final HsqlNameManager.HsqlName SQLJ_SCHEMA_HSQLNAME = HsqlNameManager.newSystemObjectName("SQLJ", 2);
    public static final HsqlNameManager.HsqlName SYSTEM_SUBQUERY_HSQLNAME = HsqlNameManager.newSystemObjectName("SYSTEM_SUBQUERY", 3);
    public static final Charset SQL_TEXT;
    public static final Charset SQL_IDENTIFIER_CHARSET;
    public static final Charset SQL_CHARACTER;
    public static final Charset ASCII_GRAPHIC;
    public static final Charset GRAPHIC_IRV;
    public static final Charset ASCII_FULL;
    public static final Charset ISO8BIT;
    public static final Charset LATIN1;
    public static final Charset UTF32;
    public static final Charset UTF16;
    public static final Charset UTF8;
    public static final Type CARDINAL_NUMBER;
    public static final Type YES_OR_NO;
    public static final Type CHARACTER_DATA;
    public static final Type SQL_IDENTIFIER;
    public static final Type TIME_STAMP;

    public static final void checkSchemaNameNotSystem(String string) {
        if (SqlInvariants.isSchemaNameSystem(string)) {
            throw Error.error(5503, string);
        }
    }

    public static final boolean isSchemaNameSystem(String string) {
        return DEFINITION_SCHEMA.equals(string) || INFORMATION_SCHEMA.equals(string) || SYSTEM_SCHEMA.equals(string) || SQLJ_SCHEMA.equals(string);
    }

    public static final boolean isSchemaNameSystem(HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName.schema != null) {
            hsqlName = hsqlName.schema;
        }
        return INFORMATION_SCHEMA_HSQLNAME.equals(hsqlName) || SYSTEM_SCHEMA_HSQLNAME.equals(hsqlName) || SQLJ_SCHEMA_HSQLNAME.equals(hsqlName);
    }

    static {
        SYSTEM_SUBQUERY_HSQLNAME.setSchemaIfNull(SYSTEM_SCHEMA_HSQLNAME);
        HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName("SQL_TEXT", false, 14);
        SQL_TEXT = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("SQL_IDENTIFIER", false, 14);
        SQL_IDENTIFIER_CHARSET = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("SQL_CHARACTER", false, 14);
        SQL_CHARACTER = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("LATIN1", false, 14);
        LATIN1 = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("ASCII_GRAPHIC", false, 14);
        ASCII_GRAPHIC = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("GRAPHIC_IRV", false, 14);
        GRAPHIC_IRV = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("ASCII_FULL", false, 14);
        ASCII_FULL = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("ISO8BIT", false, 14);
        ISO8BIT = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("UTF32", false, 14);
        UTF32 = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("UTF16", false, 14);
        UTF16 = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("UTF8", false, 14);
        UTF8 = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("CARDINAL_NUMBER", false, 13);
        CARDINAL_NUMBER = new NumberType(25, 0L, 0);
        SqlInvariants.CARDINAL_NUMBER.userTypeModifier = new UserTypeModifier(hsqlName, 13, CARDINAL_NUMBER);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("YES_OR_NO", false, 13);
        YES_OR_NO = new CharacterType(12, 3L);
        SqlInvariants.YES_OR_NO.userTypeModifier = new UserTypeModifier(hsqlName, 13, YES_OR_NO);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("CHARACTER_DATA", false, 13);
        CHARACTER_DATA = new CharacterType(12, 65536L);
        SqlInvariants.CHARACTER_DATA.userTypeModifier = new UserTypeModifier(hsqlName, 13, CHARACTER_DATA);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("SQL_IDENTIFIER", false, 13);
        SQL_IDENTIFIER = new CharacterType(12, 128L);
        SqlInvariants.SQL_IDENTIFIER.userTypeModifier = new UserTypeModifier(hsqlName, 13, SQL_IDENTIFIER);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("TIME_STAMP", false, 13);
        TIME_STAMP = new DateTimeType(93, 93, 6);
        SqlInvariants.TIME_STAMP.userTypeModifier = new UserTypeModifier(hsqlName, 13, TIME_STAMP);
    }
}

