/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.Type;

public class StatementSession
extends Statement {
    Expression[] expressions;
    Object[] parameters;

    StatementSession(int n, Expression[] expressionArray) {
        super(n);
        this.expressions = expressionArray;
        this.isTransactionStatement = false;
        switch (n) {
            case 66: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 136: {
                this.group = 2008;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StateemntSession");
            }
        }
    }

    StatementSession(int n, Object[] objectArray) {
        super(n);
        this.parameters = objectArray;
        this.isTransactionStatement = false;
        this.isLogged = false;
        switch (n) {
            case 74: {
                this.group = 2008;
                this.isLogged = true;
                break;
            }
            case 1074: {
                this.group = 2011;
                this.isLogged = true;
                break;
            }
            case 1: {
                this.group = 2003;
                break;
            }
            case 2: 
            case 15: 
            case 16: {
                this.group = 2016;
                break;
            }
            case 38: {
                this.group = 2004;
                break;
            }
            case 37: 
            case 39: 
            case 40: {
                this.group = 2003;
                break;
            }
            case 45: 
            case 47: 
            case 53: 
            case 98: 
            case 99: {
                this.group = 2003;
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                this.group = 2016;
                break;
            }
            case 22: {
                this.group = 2006;
                break;
            }
            case 67: 
            case 68: 
            case 70: 
            case 109: 
            case 118: 
            case 1040: 
            case 1064: 
            case 1065: 
            case 1066: {
                this.group = 2011;
                break;
            }
            case 11: 
            case 57: 
            case 62: 
            case 63: 
            case 75: 
            case 111: 
            case 1067: {
                this.group = 2005;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSession");
            }
        }
    }

    StatementSession(int n, HsqlNameManager.HsqlName[] hsqlNameArray, HsqlNameManager.HsqlName[] hsqlNameArray2) {
        super(n);
        this.isTransactionStatement = true;
        this.readTableNames = hsqlNameArray;
        this.writeTableNames = hsqlNameArray2;
        switch (n) {
            case 1063: {
                this.group = 2015;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSession");
            }
        }
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        try {
            if (this.isLogged) {
                session.database.logger.writeToLog(session, this.sql);
            }
        }
        catch (Throwable throwable) {
            return Result.newErrorResult(throwable, this.sql);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    Result getResult(Session var1_1) {
        var2_2 = false;
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(var1_1));
        }
        switch (this.type) {
            case 1: 
            case 2: {
                return Result.updateZeroResult;
            }
            case 11: {
                try {
                    var3_3 = this.parameters != null;
                    var1_1.commit(var3_3);
                    return Result.updateZeroResult;
                }
                catch (HsqlException var3_4) {
                    return Result.newErrorResult(var3_4, this.sql);
                }
            }
            case 15: 
            case 16: {
                return Result.updateZeroResult;
            }
            case 22: {
                var1_1.close();
                return Result.updateZeroResult;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 98: 
            case 99: {
                return Result.updateZeroResult;
            }
            case 1063: {
                return Result.updateZeroResult;
            }
            case 57: {
                var3_5 = (String)this.parameters[0];
                try {
                    var1_1.releaseSavepoint(var3_5);
                    return Result.updateZeroResult;
                }
                catch (HsqlException var4_25) {
                    return Result.newErrorResult(var4_25, this.sql);
                }
            }
            case 62: {
                var3_6 = (Boolean)this.parameters[0];
                var1_1.rollback(var3_6);
                return Result.updateZeroResult;
            }
            case 1067: {
                var3_7 = (String)this.parameters[0];
                try {
                    var1_1.rollbackToSavepoint(var3_7);
                    return Result.updateZeroResult;
                }
                catch (HsqlException var4_26) {
                    return Result.newErrorResult(var4_26, this.sql);
                }
            }
            case 63: {
                var3_8 = (String)this.parameters[0];
                var1_1.savepoint(var3_8);
                return Result.updateZeroResult;
            }
            case 66: {
                try {
                    var3_9 = (String)this.expressions[0].getValue(var1_1);
                    var3_9 = (String)Type.SQL_VARCHAR.trim(var1_1, var3_9, 32, true, true);
                    if (var1_1.database.getCatalogName().name.equals(var3_9)) {
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(Error.error(4840), this.sql);
                }
                catch (HsqlException var4_27) {
                    return Result.newErrorResult(var4_27, this.sql);
                }
            }
            case 67: 
            case 68: 
            case 70: {
                return Result.updateZeroResult;
            }
            case 71: {
                var3_10 = null;
                if (this.expressions[0].getType() == 1 && this.expressions[0].getConstantValueNoCheck(var1_1) == null) {
                    var1_1.setZoneSeconds(var1_1.sessionTimeZoneSeconds);
                    return Result.updateZeroResult;
                }
                try {
                    var3_10 = this.expressions[0].getValue(var1_1);
                }
                catch (HsqlException var4_28) {
                    // empty catch block
                }
                if (!(var3_10 instanceof Result)) ** GOTO lbl78
                var4_29 = (Result)var3_10;
                if (!var4_29.isData()) ** GOTO lbl77
                var5_37 = var4_29.getNavigator().getNext();
                v0 = var6_41 = var4_29.getNavigator().next() == false;
                if (var6_41 && var5_37 != null && var5_37[0] != null) {
                    var3_10 = var5_37[0];
                    var4_29.getNavigator().close();
                } else {
                    var4_29.getNavigator().close();
                    return Result.newErrorResult(Error.error(3409), this.sql);
lbl77:
                    // 1 sources

                    return Result.newErrorResult(Error.error(3409), this.sql);
lbl78:
                    // 1 sources

                    if (var3_10 == null) {
                        return Result.newErrorResult(Error.error(3409), this.sql);
                    }
                }
                if (-50400L <= (var4_30 = ((IntervalSecondData)var3_10).getSeconds()) && var4_30 <= 50400L) {
                    var1_1.setZoneSeconds((int)var4_30);
                    return Result.updateZeroResult;
                }
                return Result.newErrorResult(Error.error(3409), this.sql);
            }
            case 72: {
                return Result.updateZeroResult;
            }
            case 69: {
                return Result.updateZeroResult;
            }
            case 73: {
                var4_31 = null;
                try {
                    var3_11 = (String)this.expressions[0].getValue(var1_1);
                    if (var3_11 != null) {
                        var3_11 = (String)Type.SQL_VARCHAR.trim(var1_1, var3_11, 32, true, true);
                        var4_31 = var1_1.database.granteeManager.getRole(var3_11);
                    }
                }
                catch (HsqlException var5_38) {
                    return Result.newErrorResult(Error.error(2200), this.sql);
                }
                if (var1_1.isInMidTransaction()) {
                    return Result.newErrorResult(Error.error(3701), this.sql);
                }
                if (var4_31 == null) {
                    var1_1.setRole(null);
                }
                if (var1_1.getGrantee().hasRole(var4_31)) {
                    var1_1.setRole(var4_31);
                    return Result.updateZeroResult;
                }
                return Result.newErrorResult(Error.error(2200), this.sql);
            }
            case 74: {
                try {
                    var3_12 = this.expressions == null ? ((HsqlNameManager.HsqlName)this.parameters[0]).name : (String)this.expressions[0].getValue(var1_1);
                    var3_12 = (String)Type.SQL_VARCHAR.trim(var1_1, var3_12, 32, true, true);
                    var4_32 = var1_1.database.schemaManager.getSchemaHsqlName(var3_12);
                    var1_1.setSchema(var4_32.name);
                    return Result.updateZeroResult;
                }
                catch (HsqlException var5_39) {
                    return Result.newErrorResult(var5_39, this.sql);
                }
            }
            case 76: {
                if (var1_1.isInMidTransaction()) {
                    return Result.newErrorResult(Error.error(3701), this.sql);
                }
                try {
                    var4_33 = null;
                    var3_13 = (String)this.expressions[0].getValue(var1_1);
                    var3_13 = (String)Type.SQL_VARCHAR.trim(var1_1, var3_13, 32, true, true);
                    if (this.expressions[1] != null) {
                        var4_33 = (String)this.expressions[1].getValue(var1_1);
                    }
                    if ((var5_40 = var4_33 == null ? var1_1.database.userManager.get(var3_13) : var1_1.database.getUserManager().getUser(var3_13, var4_33)) == null) {
                        throw Error.error(4001);
                    }
                    this.sql = var5_40.getConnectUserSQL();
                    if (var5_40 == var1_1.getGrantee()) {
                        return Result.updateZeroResult;
                    }
                    if (var1_1.getGrantee().canChangeAuthorisation()) {
                        var1_1.setUser(var5_40);
                        var1_1.setRole(null);
                        var1_1.resetSchema();
                        return Result.updateZeroResult;
                    }
                    throw Error.error(4000);
                }
                catch (HsqlException var3_14) {
                    return Result.newErrorResult(var3_14, this.sql);
                }
            }
            case 109: {
                try {
                    if (this.parameters[0] != null) {
                        var3_15 = ((Boolean)this.parameters[0]).booleanValue();
                        var1_1.setReadOnlyDefault((boolean)var3_15);
                    }
                    if (this.parameters[1] != null) {
                        var3_15 = (Integer)this.parameters[1];
                        var1_1.setIsolationDefault(var3_15);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException var3_16) {
                    return Result.newErrorResult(var3_16, this.sql);
                }
            }
            case 136: {
                return Result.updateZeroResult;
            }
            case 118: {
                return Result.updateZeroResult;
            }
            case 111: {
                var2_2 = true;
            }
            case 75: {
                try {
                    if (this.parameters[0] != null) {
                        var3_17 = ((Boolean)this.parameters[0]).booleanValue();
                        var1_1.setReadOnly((boolean)var3_17);
                    }
                    if (this.parameters[1] != null) {
                        var3_17 = (Integer)this.parameters[1];
                        var1_1.setIsolation(var3_17);
                    }
                    if (var2_2) {
                        var1_1.startTransaction();
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException var3_18) {
                    return Result.newErrorResult(var3_18, this.sql);
                }
            }
            case 1064: {
                var3_19 = (Boolean)this.parameters[0];
                try {
                    var1_1.setAutoCommit(var3_19);
                    return Result.updateZeroResult;
                }
                catch (HsqlException var4_34) {
                    return Result.newErrorResult(var4_34, this.sql);
                }
            }
            case 1074: {
                var3_20 = (ColumnSchema[])this.parameters[0];
                try {
                    for (var4_35 = 0; var4_35 < var3_20.length; ++var4_35) {
                        var1_1.sessionContext.addSessionVariable(var3_20[var4_35]);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException var4_36) {
                    return Result.newErrorResult(var4_36, this.sql);
                }
            }
            case 1065: {
                var3_21 = (Integer)this.parameters[0];
                var1_1.setSQLMaxRows(var3_21);
                return Result.updateZeroResult;
            }
            case 1066: {
                var3_22 = (Integer)this.parameters[0];
                var1_1.setResultMemoryRowCount(var3_22);
                return Result.updateZeroResult;
            }
            case 1040: {
                try {
                    var3_23 = (Boolean)this.parameters[0];
                    var1_1.setIgnoreCase(var3_23);
                    return Result.updateZeroResult;
                }
                catch (HsqlException var3_24) {
                    return Result.newErrorResult(var3_24, this.sql);
                }
            }
        }
        throw Error.runtimeError(201, "StatementSession");
    }

    @Override
    public boolean isAutoCommitStatement() {
        return false;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }
}

