/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.QueryExpression;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TextTable;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.types.Type;

public class TableUtil {
    static Table newTable(Database database, int n, HsqlNameManager.HsqlName hsqlName) {
        switch (n) {
            case 5: 
            case 6: {
                return new TextTable(database, hsqlName, n);
            }
        }
        return new Table(database, hsqlName, n);
    }

    static TableDerived newSubqueryTable(Database database, QueryExpression queryExpression) {
        HsqlNameManager.HsqlName hsqlName = database.nameManager.getSubqueryTableName();
        try {
            return new TableDerived(database, hsqlName, 1, queryExpression);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Table newLookupTable(Database database) {
        try {
            TableDerived tableDerived = TableUtil.newSubqueryTable(database, null);
            ColumnSchema columnSchema = new ColumnSchema(HsqlNameManager.getAutoColumnName(0), Type.SQL_INTEGER, false, true, null);
            tableDerived.addColumn(columnSchema);
            tableDerived.createPrimaryKeyConstraint(tableDerived.getName(), new int[]{0}, true);
            return tableDerived;
        }
        catch (HsqlException hsqlException) {
            return null;
        }
    }

    static void setTableColumnsForSubquery(Table table, QueryExpression queryExpression, boolean bl) {
        table.columnList = queryExpression.getColumns();
        table.columnCount = queryExpression.getColumnCount();
        table.createPrimaryKey();
        if (bl) {
            int[] nArray = null;
            nArray = table.getNewColumnMap();
            ArrayUtil.fillSequence(nArray);
            table.fullIndex = table.createIndexForColumns(nArray);
        }
    }

    static void setTableColumnsForSubquery(Table table, Type[] typeArray, boolean bl, boolean bl2) {
        TableUtil.addAutoColumns(table, typeArray);
        int[] nArray = null;
        if (bl) {
            nArray = new int[typeArray.length];
            ArrayUtil.fillSequence(nArray);
        }
        table.createPrimaryKey(null, (int[])(bl2 ? nArray : null), false);
        if (bl2) {
            table.fullIndex = table.getPrimaryIndex();
        } else if (bl) {
            table.fullIndex = table.createIndexForColumns(nArray);
        }
    }

    public static void addAutoColumns(Table table, Type[] typeArray) {
        for (int i = 0; i < typeArray.length; ++i) {
            ColumnSchema columnSchema = new ColumnSchema(HsqlNameManager.getAutoColumnName(i), typeArray[i], true, false, null);
            table.addColumnNoCheck(columnSchema);
        }
    }

    public static void setColumnsInSchemaTable(Table table, HsqlNameManager.HsqlName[] hsqlNameArray, Type[] typeArray) {
        for (int i = 0; i < hsqlNameArray.length; ++i) {
            HsqlNameManager.HsqlName hsqlName = hsqlNameArray[i];
            hsqlName = table.database.nameManager.newColumnSchemaHsqlName(table.getName(), hsqlName);
            ColumnSchema columnSchema = new ColumnSchema(hsqlName, typeArray[i], true, false, null);
            table.addColumn(columnSchema);
        }
        table.setColumnStructures();
    }
}

