/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.Set;

public class OrderedHashSet
extends HashSet
implements HsqlList,
Set {
    public OrderedHashSet() {
        super(8);
        this.isList = true;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.size();
        super.removeObject(object, true);
        return n != this.size();
    }

    @Override
    public Object remove(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        Object object = this.objectKeyTable[n];
        this.remove(object);
        return object;
    }

    public boolean insert(int n, Object object) throws IndexOutOfBoundsException {
        int n2;
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.contains(object)) {
            return false;
        }
        if (n == this.size()) {
            return this.add(object);
        }
        Object[] objectArray = this.toArray(new Object[this.size()]);
        super.clear();
        for (n2 = 0; n2 < n; ++n2) {
            this.add(objectArray[n2]);
        }
        this.add(object);
        for (n2 = n; n2 < objectArray.length; ++n2) {
            this.add(objectArray[n2]);
        }
        return true;
    }

    @Override
    public Object set(int n, Object object) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void add(int n, Object object) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object get(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        return this.objectKeyTable[n];
    }

    public int getIndex(Object object) {
        return this.getLookup(object, object.hashCode());
    }

    public int getLargestIndex(OrderedHashSet orderedHashSet) {
        int n = -1;
        int n2 = orderedHashSet.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getIndex(orderedHashSet.get(i));
            if (n3 <= n) continue;
            n = n3;
        }
        return n;
    }

    public int getCommonElementCount(Set set) {
        int n = 0;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (!set.contains(this.objectKeyTable[i])) continue;
            ++n;
        }
        return n;
    }

    private void checkRange(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

