/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.ColumnSchema;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.types.Type;

public abstract class RowStoreAVL
implements PersistentStore {
    PersistentStoreCollection manager;
    Index[] indexList = Index.emptyArray;
    CachedObject[] accessorList = CachedObject.emptyArray;
    TableBase table;
    long timestamp;

    @Override
    public TableBase getTable() {
        return this.table;
    }

    @Override
    public long getCreationTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public abstract int getAccessCount();

    @Override
    public abstract void set(CachedObject var1);

    @Override
    public abstract CachedObject get(int var1, boolean var2);

    @Override
    public abstract CachedObject get(CachedObject var1, boolean var2);

    @Override
    public abstract int getStorageSize(int var1);

    @Override
    public abstract void add(CachedObject var1);

    @Override
    public abstract CachedObject get(RowInputInterface var1);

    @Override
    public abstract CachedObject getNewInstance(int var1);

    @Override
    public abstract CachedObject getNewCachedObject(Session var1, Object var2);

    @Override
    public abstract void removePersistence(int var1);

    @Override
    public abstract void removeAll();

    @Override
    public abstract void remove(int var1);

    @Override
    public abstract void release(int var1);

    @Override
    public abstract void commitPersistence(CachedObject var1);

    @Override
    public abstract DataFileCache getCache();

    @Override
    public abstract void setCache(DataFileCache var1);

    @Override
    public abstract void release();

    @Override
    public PersistentStore getAccessorStore(Index index) {
        return null;
    }

    @Override
    public CachedObject getAccessor(Index index) {
        int n = index.getPosition();
        if (n >= this.accessorList.length) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        return this.accessorList[n];
    }

    @Override
    public void delete(Row row) {
        row = (Row)this.get(row, false);
        for (int i = this.indexList.length - 1; i >= 0; --i) {
            this.indexList[i].delete(this, row);
        }
        row.delete(this);
    }

    @Override
    public void indexRow(Session session, Row row) {
        int n;
        try {
            for (n = 0; n < this.indexList.length; ++n) {
                this.indexList[n].insert(session, this, row);
            }
        }
        catch (HsqlException hsqlException) {
            --n;
            while (n >= 0) {
                this.indexList[n].delete(this, row);
                --n;
            }
            this.remove(row.getPos());
            throw hsqlException;
        }
    }

    @Override
    public final void indexRows() {
        RowIterator rowIterator = this.rowIterator();
        for (int i = 1; i < this.indexList.length; ++i) {
            this.setAccessor(this.indexList[i], null);
        }
        while (rowIterator.hasNext()) {
            Row row = rowIterator.getNextRow();
            ((RowAVL)row).clearNonPrimaryNodes();
            for (int i = 1; i < this.indexList.length; ++i) {
                this.indexList[i].insert(null, this, row);
            }
        }
    }

    @Override
    public final RowIterator rowIterator() {
        if (this.indexList.length == 0 || this.indexList[0] == null) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        return this.indexList[0].firstRow(this, false);
    }

    @Override
    public abstract void setAccessor(Index var1, CachedObject var2);

    @Override
    public abstract void setAccessor(Index var1, int var2);

    @Override
    public abstract void resetAccessorKeys(Index[] var1);

    @Override
    public final void moveData(Session session, PersistentStore persistentStore, int n, int n2) {
        Object object;
        Object object2 = null;
        Type type = null;
        Type type2 = null;
        if (n2 >= 0 && n != -1) {
            object = ((Table)this.table).getColumn(n);
            object2 = ((ColumnSchema)object).getDefaultValue(session);
            if (n2 == 0) {
                type = ((Table)persistentStore.getTable()).getColumnTypes()[n];
                type2 = ((Table)this.table).getColumnTypes()[n];
            }
        }
        object = persistentStore.rowIterator();
        Table table = (Table)this.table;
        try {
            while (object.hasNext()) {
                Row row = object.getNextRow();
                Object[] objectArray = row.getData();
                Object[] objectArray2 = table.getEmptyRowData();
                if (n2 == 0 && n != -1) {
                    object2 = type2.convertToType(session, objectArray[n], type);
                }
                ArrayUtil.copyAdjustArray(objectArray, objectArray2, object2, n, n2);
                table.systemSetIdentityColumn(session, objectArray2);
                table.enforceTypeLimits(session, objectArray2);
                table.enforceRowConstraints(session, objectArray2);
                Row row2 = (Row)this.getNewCachedObject(null, objectArray2);
                this.indexRow(null, row2);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw Error.error(460);
        }
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
    }

    void dropIndexFromRows(Index index, Index index2) {
        RowIterator rowIterator = index.firstRow(this, false);
        int n = index2.getPosition() - 1;
        while (rowIterator.hasNext()) {
            Row row = rowIterator.getNextRow();
            int n2 = n - 1;
            NodeAVL nodeAVL = ((RowAVL)row).getNode(0);
            while (n2-- > 0) {
                nodeAVL = nodeAVL.nNext;
            }
            nodeAVL.nNext = nodeAVL.nNext.nNext;
        }
    }

    boolean insertIndexNodes(Index index, Index index2) {
        int n = index2.getPosition();
        RowIterator rowIterator = index.firstRow(this, false);
        int n2 = 0;
        HsqlException hsqlException = null;
        try {
            while (rowIterator.hasNext()) {
                Row row = rowIterator.getNextRow();
                ((RowAVL)row).insertNode(n);
                ++n2;
                index2.insert(null, this, row);
            }
            return true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            hsqlException = Error.error(460);
        }
        catch (HsqlException hsqlException2) {
            hsqlException = hsqlException2;
        }
        rowIterator = index.firstRow(this, false);
        for (int i = 0; i < n2; ++i) {
            Row row = rowIterator.getNextRow();
            NodeAVL nodeAVL = ((RowAVL)row).getNode(0);
            int n3 = n;
            while (--n3 > 0) {
                nodeAVL = nodeAVL.nNext;
            }
            nodeAVL.nNext = nodeAVL.nNext.nNext;
        }
        throw hsqlException;
    }

    void reindex(Session session, Index index) {
        this.setAccessor(index, null);
        RowIterator rowIterator = this.table.rowIterator(this);
        while (rowIterator.hasNext()) {
            Row row = rowIterator.getNextRow();
            index.insert(session, this, row);
        }
    }
}

