/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputTextLog;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class ScriptReaderText
extends ScriptReaderBase {
    BufferedReader dataStreamIn;
    RowInputTextLog rowIn;
    boolean isInsert;

    public ScriptReaderText(Database database) {
        super(database);
    }

    public ScriptReaderText(Database database, String string) throws IOException {
        super(database);
        InputStream inputStream = this.database.logger.getFileAccess().openInputStreamElement(string);
        this.dataStreamIn = new BufferedReader(new InputStreamReader(new BufferedInputStream(inputStream)));
        this.rowIn = new RowInputTextLog(database.databaseProperties.isVersion18());
    }

    @Override
    protected void readDDL(Session session) throws IOException {
        while (this.readLoggedStatement(session)) {
            Statement statement = null;
            Result result = null;
            if (this.rowIn.getStatementType() == 3) {
                this.isInsert = true;
                break;
            }
            try {
                statement = session.compileStatement(this.statement, 0);
                result = session.executeCompiledStatement(statement, ValuePool.emptyObjectArray);
                if (statement.getType() == 64) {
                    HsqlNameManager.HsqlName hsqlName = statement.getSchemaName();
                    session.setSchema(hsqlName.name);
                }
            }
            catch (HsqlException hsqlException) {
                result = Result.newErrorResult(hsqlException);
            }
            if (result.isError() && statement != null && (statement.getType() == 48 || statement.getType() == 14 && result.getMainString().contains("org.hsqldb.Library")) || !result.isError()) continue;
            this.database.logger.logWarningEvent(result.getMainString(), result.getException());
            if (statement != null && statement.getType() == 14) continue;
            throw Error.error(result.getException(), 461, 24, new Object[]{new Integer(this.lineCount), result.getMainString()});
        }
    }

    @Override
    protected void readExistingData(Session session) throws IOException {
        try {
            String string = null;
            this.database.setReferentialIntegrity(false);
            while (this.isInsert || this.readLoggedStatement(session)) {
                if (this.statementType == 6) {
                    session.setSchema(this.currentSchema);
                } else if (this.statementType == 3) {
                    if (!this.rowIn.getTableName().equals(string)) {
                        string = this.rowIn.getTableName();
                        String string2 = session.getSchemaName(this.currentSchema);
                        this.currentTable = this.database.schemaManager.getUserTable(session, string, string2);
                        this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
                    }
                    this.currentTable.insertFromScript(this.currentStore, this.rowData);
                }
                this.isInsert = false;
            }
            this.database.setReferentialIntegrity(true);
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("readExistingData failed", throwable);
            throw Error.error(throwable, 461, 25, new Object[]{throwable.getMessage(), new Integer(this.lineCount)});
        }
    }

    @Override
    public boolean readLoggedStatement(Session session) throws IOException {
        if (!this.sessionChanged) {
            String string = this.dataStreamIn.readLine();
            ++this.lineCount;
            this.statement = StringConverter.unicodeStringToString(string);
            if (this.statement == null) {
                return false;
            }
        }
        this.processStatement(session);
        return true;
    }

    void processStatement(Session session) throws IOException {
        try {
            if (this.statement.startsWith("/*C")) {
                int n = this.statement.indexOf(42, 4);
                this.sessionNumber = Integer.parseInt(this.statement.substring(3, n));
                this.statement = this.statement.substring(n + 2);
                this.sessionChanged = true;
                this.statementType = 5;
                return;
            }
            this.sessionChanged = false;
            this.rowIn.setSource(this.statement);
            this.statementType = this.rowIn.getStatementType();
            if (this.statementType == 1) {
                this.rowData = null;
                this.currentTable = null;
                return;
            }
            if (this.statementType == 4) {
                this.rowData = null;
                this.currentTable = null;
                return;
            }
            if (this.statementType == 6) {
                this.rowData = null;
                this.currentTable = null;
                this.currentSchema = this.rowIn.getSchemaName();
                return;
            }
            String string = this.rowIn.getTableName();
            String string2 = session.getCurrentSchemaHsqlName().name;
            this.currentTable = this.database.schemaManager.getUserTable(session, string, string2);
            this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
            Type[] typeArray = this.statementType == 3 ? this.currentTable.getColumnTypes() : (this.currentTable.hasPrimaryKey() ? this.currentTable.getPrimaryKeyTypes() : this.currentTable.getColumnTypes());
            this.rowData = this.rowIn.readData(typeArray);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    @Override
    public void close() {
        try {
            this.dataStreamIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

