/*
 * Decompiled with CFR 0.152.
 */
package rcon;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import rcon.ConfigurationException;

public class DaemonConfiguration {
    private Properties config = new Properties();

    public DaemonConfiguration(String filename) throws IOException {
        File f = new File(filename);
        if (!f.exists()) {
            throw new IOException("No such file.");
        }
        FileInputStream in = new FileInputStream(filename);
        this.config.load(in);
        in.close();
    }

    public String getServerHost() {
        return this.getString("server.host");
    }

    public int getServerPort() {
        return this.getInt("server.port");
    }

    public String getServerPassword() {
        return this.getString("server.password");
    }

    public int getServerReconnectDelay() {
        return this.getInt("server.reconnectDelay", -1);
    }

    public int getServerTimeout() {
        return this.getInt("server.timeout", 5000);
    }

    public String getServerConfig() {
        return this.getString("server.config", "config.properties");
    }

    public boolean getServerConfigAutoApply() {
        return this.getBoolean("server.config.autoapply", false);
    }

    public String getDatabaseDriver() {
        return this.getString("database.driver");
    }

    public String getDatabaseUrl() {
        return this.getString("database.url");
    }

    public String getDatabaseUser() {
        return this.getString("database.user");
    }

    public String getDatabasePassword() {
        return this.getString("database.password");
    }

    public boolean isHeartbeatsEnabled() {
        return this.getBoolean("heartbeat.enabled", false);
    }

    public int getHeartbeatInterval() {
        return this.getInt("heartbeat.interval", 30000);
    }

    public boolean getHttpdEnabled() {
        return this.getBoolean("httpd.enabled", false);
    }

    public int getHttpdPort() {
        return this.getInt("httpd.port", 5391);
    }

    public boolean getClientsEnabled() {
        return this.getBoolean("clients.enabled", false);
    }

    public int getClientsPort() {
        return this.getInt("clients.port", 5390);
    }

    public String getTimeZone() {
        return this.getString("daemon.timeZone", "GMT");
    }

    public String getDateFormat() {
        return this.getString("daemon.dateFormat", "MMMM d, yyyy HH:mm:ss zzz");
    }

    public String getDaemonId() {
        return this.getString("daemon.id", "tgac-main");
    }

    public String getBannedMessage() {
        return this.getString("ban.message", "You are banned until %1$s for %2$s.");
    }

    public int getPlayerUpdateInterval() {
        return this.getInt("players.updateInterval", 30000);
    }

    public boolean isServerMessageEnabled() {
        return this.getBoolean("messages.enabled", true);
    }

    public int getServerMessageInterval() {
        return this.getInt("messages.interval", 60000);
    }

    public String getServerMessageFile() {
        return this.getString("messages.file", "messages.txt");
    }

    public boolean isKillStreaksEnabled() {
        return this.getBoolean("streaks.enabled", true);
    }

    public int getStreakModulus() {
        return this.getInt("streaks.modulus", 5);
    }

    public int getStreakAwesomeLimit() {
        return this.getInt("streaks.awesome", 15);
    }

    public boolean isAutoConfigEnabled() {
        return this.getBoolean("autoconfig.enabled", false);
    }

    public String getWelcomeMessage() {
        return this.getString("server.welcome", "");
    }

    public boolean isKDNotificationsEnabled() {
        return this.getBoolean("kdnotify.enabled", true);
    }

    public double getKDRatio() {
        return this.getDouble("kdnotify.ratio", 5);
    }

    public int getKDMinKills() {
        return this.getInt("kdnotify.kills", 20);
    }

    private int getInt(String name) {
        try {
            return Integer.parseInt(this.getString(name));
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Expected numeric value for " + name + ".", e);
        }
    }

    private double getDouble(String name, int i) {
        try {
            return Double.parseDouble(this.getString(name));
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Expected numeric value for " + name + ".", e);
        }
    }

    private String getString(String name) {
        String ret = this.config.getProperty(name);
        if (ret == null) {
            throw new ConfigurationException("Missing configuration value for " + name + ".");
        }
        return ret;
    }

    private String getString(String name, String def) {
        return this.config.getProperty(name, def);
    }

    private int getInt(String name, int def) {
        try {
            return Integer.parseInt(this.getString(name, String.valueOf(def)));
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Expected numeric value for " + name + ".", e);
        }
    }

    private boolean getBoolean(String name) {
        String value = this.getString(name);
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no")) {
            return false;
        }
        throw new ConfigurationException("Expected boolean value (true or false) for " + name + ".");
    }

    private boolean getBoolean(String name, boolean def) {
        String value = this.getString(name, String.valueOf(def));
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no")) {
            return false;
        }
        throw new ConfigurationException("Expected boolean value (true or false) for " + name + ".");
    }

    public int getServerAdminId() {
        return this.getInt("server.admin.id", 0);
    }
}

