/*
 * Decompiled with CFR 0.152.
 */
package rcon;

import akuma.Daemon;
import httpd.RCONHTTPD;
import java.io.IOException;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import rcon.DaemonConfiguration;
import rcon.RCONDaemon;

public class Main {
    static Logger logger = Logger.getLogger(Main.class);

    public static void main(String[] args) {
        boolean daemonize = false;
        String configFile = null;
        String pidFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--daemonize")) {
                daemonize = true;
                continue;
            }
            if (args[i].equals("--pidfile")) {
                if (++i < args.length) {
                    pidFile = args[i];
                    continue;
                }
                System.err.println("Expected path to pidfile.");
                System.exit(1);
                continue;
            }
            if (args[i].equals("--logfile")) {
                if (++i < args.length) {
                    String logFile = args[i];
                    FileAppender fa = (FileAppender)Logger.getRootLogger().getAppender("main");
                    if (fa == null) continue;
                    fa.setFile(logFile);
                    fa.activateOptions();
                    continue;
                }
                System.err.println("Expected path to logfile.");
                System.exit(1);
                continue;
            }
            if (configFile == null) {
                configFile = args[i];
                continue;
            }
            System.err.println("Unknown argument " + args[i] + ".");
            System.exit(1);
        }
        if (configFile == null) {
            System.err.println("Missing config file path!");
            System.exit(1);
        }
        Daemon d = new Daemon();
        try {
            if (d.isDaemonized()) {
                d.init(pidFile);
            } else if (daemonize) {
                d.daemonize();
                System.exit(0);
            }
        }
        catch (Exception e1) {
            logger.error("Error during deamonization.", e1);
            System.exit(1);
        }
        DaemonConfiguration config = null;
        try {
            config = new DaemonConfiguration(configFile);
        }
        catch (IOException e2) {
            logger.error("Could not load daemon configuration file. " + e2.getMessage());
            System.exit(1);
        }
        RCONDaemon daemon = new RCONDaemon(config);
        if (daemon.init()) {
            if (config.getHttpdEnabled()) {
                try {
                    new RCONHTTPD(config.getHttpdPort(), daemon);
                }
                catch (IOException e) {
                    logger.error("Failed to start HTTPD. Running without HTTPD support. " + e.getMessage());
                }
            }
            daemon.start();
        } else {
            logger.error("Failed to start daemon.");
        }
    }
}

