/*
 * Decompiled with CFR 0.152.
 */
package rcon.client;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rcon.RCONDaemon;
import rcon.client.ClientConnection;

public class ClientHandler
extends Thread {
    private List<ClientConnection> clients;
    private RCONDaemon daemon;
    private int port;
    private ServerSocket socket;

    public ClientHandler(RCONDaemon daemon, int port) {
        this.daemon = daemon;
        this.port = port;
        this.clients = Collections.synchronizedList(new ArrayList());
    }

    public int getClientCount() {
        return this.clients.size();
    }

    public void run() {
        try {
            this.socket = new ServerSocket(this.port);
            while (!this.socket.isClosed()) {
                Socket clientSocket = this.socket.accept();
                try {
                    ClientConnection clientConnection = new ClientConnection(clientSocket, this, this.daemon);
                    this.clients.add(clientConnection);
                    clientConnection.start();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void onClientDisconnect(ClientConnection clientConnection) {
        this.clients.remove(clientConnection);
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (!this.clients.isEmpty()) {
            this.clients.remove(0).close();
        }
        try {
            this.join(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

