/*
 * Decompiled with CFR 0.152.
 */
package rcon.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import rcon.RCONDaemon;
import rcon.client.CommandModule;
import rcon.commands.Command;
import rcon.ingame.ServerMessage;
import rcon.ingame.ServerMessages;
import rcon.net.RCONOutputStream;
import rcon.players.Admin;

public class MessageModule
extends CommandModule {
    public MessageModule(RCONOutputStream out, RCONDaemon daemon) {
        super(out, daemon);
    }

    public void list(Admin user, Command request) throws IOException {
        ServerMessages serverMessages = this.daemon.getServer().getServerMessages();
        ArrayList<ServerMessage> messages = serverMessages.getMessages();
        String[] arguments = new String[1 + 2 * messages.size()];
        arguments[0] = String.valueOf(messages.size());
        for (int i = 0; i < messages.size(); ++i) {
            arguments[1 + 2 * i] = String.valueOf(messages.get(i).getId());
            arguments[1 + 2 * i + 1] = messages.get(i).getMessage();
        }
        this.reply(request, "OK", arguments);
    }

    public void add(Admin user, Command request) throws IOException {
        if (request.size() == 1) {
            String message = request.get(0);
            ServerMessages serverMessages = this.daemon.getServer().getServerMessages();
            ServerMessage m = serverMessages.addMessage(message);
            this.log(user, "Added server message '" + message + "'.");
            this.reply(request, "OK", String.valueOf(m.getId()));
        } else {
            this.reply(request, "InvalidArguments", new String[0]);
        }
    }

    public void edit(Admin user, Command request) throws IOException {
        if (request.size() == 2) {
            int id = request.getInt(0);
            String message = request.get(1);
            ServerMessages serverMessages = this.daemon.getServer().getServerMessages();
            try {
                serverMessages.setMessage(id, message);
                this.log(user, "Changed server message to '" + message + "'.");
                this.reply(request, "OK", new String[0]);
            }
            catch (NoSuchElementException e) {
                this.reply(request, "UnknownMessage", new String[0]);
            }
        } else {
            this.reply(request, "InvalidArguments", new String[0]);
        }
    }

    public void remove(Admin user, Command request) throws IOException {
        if (request.size() == 1) {
            int id = request.getInt(0);
            ServerMessages serverMessages = this.daemon.getServer().getServerMessages();
            try {
                ServerMessage m = serverMessages.get(id);
                serverMessages.remove(id);
                if (m != null) {
                    this.log(user, "Removed server message '" + m.getMessage() + "'.");
                }
                this.reply(request, "OK", new String[0]);
            }
            catch (NoSuchElementException e) {
                this.reply(request, "UnknownMessage", new String[0]);
            }
        } else {
            this.reply(request, "InvalidArguments", new String[0]);
        }
    }
}

