/*
 * Decompiled with CFR 0.152.
 */
package rcon.client.swing;

import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import rcon.client.swing.ConnectionDialog;
import rcon.client.swing.DaemonConnection;
import rcon.client.swing.MainWindow;

public class Main {
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        ConnectionDialog connection = new ConnectionDialog();
        connection.setVisible(true);
        while (connection.isSubmitted()) {
            try {
                Socket socket = new Socket(connection.getHost(), Integer.parseInt(connection.getPort()));
                DaemonConnection daemon = new DaemonConnection(socket);
                char[] passwordChars = connection.getPassword();
                String password = new String(passwordChars);
                Arrays.fill(passwordChars, '\u0000');
                if (daemon.login(connection.getUsername(), password)) {
                    new MainWindow(daemon);
                    break;
                }
                JOptionPane.showMessageDialog(null, "Invalid login.");
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "Invalid port.");
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Failed to connect to daemon.");
            }
            connection.setVisible(true);
        }
        connection.dispose();
    }
}

