/*
 * Decompiled with CFR 0.152.
 */
package rcon.client.swing;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rcon.client.swing.DaemonConnection;
import rcon.client.swing.PlayerSearchPane;
import rcon.players.Player;

public class PlayerSearchDialog
extends JDialog
implements ActionListener {
    private boolean submitted = false;
    private JButton ok;
    private JButton cancel;
    private PlayerSearchPane search;

    public PlayerSearchDialog(DaemonConnection daemon) {
        super((Dialog)null, "Search player", true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.search = new PlayerSearchPane(daemon);
        this.add(this.search);
        JPanel panel = new JPanel();
        this.add(panel);
        this.ok = new JButton("Ok");
        panel.add(this.ok);
        this.cancel = new JButton("Cancel");
        panel.add(this.cancel);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.getRootPane().setDefaultButton(this.ok);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                PlayerSearchDialog.this.search.requestFocusInWindow();
            }
        });
        this.pack();
    }

    public Player getPlayer() {
        return this.search.getSelectedPlayer();
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            if (this.search.getSelectedPlayer() == null) {
                JOptionPane.showMessageDialog(null, "Please select a player.");
            } else {
                this.submitted = true;
                this.setVisible(false);
            }
        } else {
            this.submitted = false;
            this.setVisible(false);
        }
    }
}

