/*
 * Decompiled with CFR 0.152.
 */
package rcon.client.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import rcon.client.swing.DaemonConnection;
import rcon.players.Player;

public class PlayerSearchPane
extends JPanel
implements DocumentListener,
ActionListener {
    private DaemonConnection daemon;
    private JTextField search;
    private JTable table;
    private ArrayList<Player> players;
    private String current;
    private Timer refreshTimer;
    private PlayerTableModel model;

    public PlayerSearchPane(DaemonConnection daemon) {
        this.daemon = daemon;
        this.refreshTimer = new Timer(500, this);
        this.refreshTimer.setRepeats(false);
        this.current = "";
        this.players = new ArrayList();
        this.setLayout(new BorderLayout());
        this.search = new JTextField();
        this.add((Component)this.search, "North");
        this.table = new JTable();
        this.add((Component)new JScrollPane(this.table), "Center");
        this.model = new PlayerTableModel();
        this.table.setModel(this.model);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(300);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.search.getDocument().addDocumentListener(this);
    }

    public boolean requestFocusInWindow() {
        return this.search.requestFocusInWindow();
    }

    public Player getSelectedPlayer() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return this.players.get(row);
    }

    private void refresh() {
        try {
            this.current = this.search.getText();
            this.players = this.daemon.searchPlayers(this.current, 0, 100);
            this.model.update();
            if (!this.players.isEmpty()) {
                this.table.setRowSelectionInterval(0, 0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.refreshTimer) {
            System.out.println("Timer");
            if (!this.search.getText().equals(this.current) && this.search.getText().length() >= 3) {
                this.refresh();
            }
        }
    }

    public void changedUpdate(DocumentEvent arg0) {
        this.refreshTimer.restart();
    }

    public void insertUpdate(DocumentEvent arg0) {
        this.refreshTimer.restart();
    }

    public void removeUpdate(DocumentEvent arg0) {
        this.refreshTimer.restart();
    }

    private class PlayerTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"ID", "Name", "Guid", "IP"};

        private PlayerTableModel() {
        }

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return PlayerSearchPane.this.players.size();
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Player p = (Player)PlayerSearchPane.this.players.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return p.getId();
                }
                case 1: {
                    return p.getName();
                }
                case 2: {
                    return p.getPbGuid();
                }
                case 3: {
                    return p.getIp();
                }
            }
            return null;
        }

        public void update() {
            this.fireTableDataChanged();
        }
    }
}

