/*
 * Decompiled with CFR 0.152.
 */
package rcon.client.swing.admin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rcon.client.swing.DaemonConnection;
import rcon.client.swing.ModulePane;
import rcon.client.swing.admin.AdminInformationPanel;
import rcon.client.swing.admin.RegisterAdminDialog;
import rcon.players.Admin;
import rcon.players.Right;

public class AdminPane
extends ModulePane
implements ActionListener,
ListSelectionListener {
    private ArrayList<Admin> admins = new ArrayList();
    private JList list;
    private JButton register;
    private JSplitPane split;

    public AdminPane(DaemonConnection daemon) {
        super(daemon);
        this.setLayout(new BoxLayout(this, 0));
        this.list = new JList(new AdminListModel());
        JScrollPane scroll = new JScrollPane(this.list);
        this.register = new JButton("Register...");
        this.register.addActionListener(this);
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.add((Component)scroll, "Center");
        listPanel.add((Component)this.register, "South");
        listPanel.setMinimumSize(new Dimension(150, 50));
        JPanel infoPanel = new JPanel();
        this.split = new JSplitPane(1, true, listPanel, infoPanel);
        this.split.setDividerLocation(150);
        this.add(this.split);
        this.list.addListSelectionListener(this);
    }

    public void onSelected() {
        this.refresh();
    }

    private void refresh() {
        try {
            this.admins = this.daemon.getAdmins();
            Collections.sort(this.admins, new Comparator<Admin>(){

                @Override
                public int compare(Admin o1, Admin o2) {
                    return o1.getUserName().compareTo(o2.getUserName());
                }
            });
            this.list.setModel(new AdminListModel());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.register) {
            RegisterAdminDialog dialog = new RegisterAdminDialog(this.daemon);
            while (true) {
                dialog.setVisible(true);
                if (!dialog.isSubmitted()) break;
                String username = dialog.getUsername();
                String password = dialog.getPassword();
                String guid = dialog.getGuid();
                Admin admin = new Admin(0, guid, username, password, EnumSet.noneOf(Right.class));
                try {
                    if (this.daemon.registerAdmin(admin)) {
                        this.refresh();
                        break;
                    }
                    JOptionPane.showMessageDialog(this, "That GUID or user name is not available.");
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(this, "Failed to register admin.");
                    break;
                }
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.refreshInfo();
        }
    }

    void refreshInfo() {
        int index = this.list.getSelectedIndex();
        if (index == -1) {
            this.split.setRightComponent(new JLabel("No admin selected."));
        } else {
            Admin selected = this.admins.get(index);
            try {
                selected = this.daemon.getAdmin(selected.getId());
                this.split.setRightComponent(new AdminInformationPanel(this, this.daemon, selected));
            }
            catch (IOException e1) {
                this.split.setRightComponent(new JLabel("Failed to load " + selected.getUserName() + "."));
            }
        }
    }

    private class AdminListModel
    extends AbstractListModel {
        private AdminListModel() {
        }

        public Object getElementAt(int index) {
            return ((Admin)AdminPane.this.admins.get(index)).getUserName();
        }

        public int getSize() {
            return AdminPane.this.admins.size();
        }
    }
}

