/*
 * Decompiled with CFR 0.152.
 */
package rcon.client.swing.ban;

import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import rcon.players.Punishment;
import rcon.players.PunishmentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BanTable
extends JTable {
    private ArrayList<Punishment> punishments = new ArrayList();
    private BanTableModel model;

    public BanTable() {
        this(new ArrayList<Punishment>());
    }

    public BanTable(ArrayList<Punishment> punishments) {
        this.punishments.addAll(punishments);
        this.model = new BanTableModel();
        this.setModel(this.model);
        TableColumnModel columns = this.getColumnModel();
        columns.getColumn(0).setPreferredWidth(150);
        columns.getColumn(1).setPreferredWidth(400);
        columns.getColumn(2).setPreferredWidth(75);
        columns.getColumn(3).setPreferredWidth(100);
        columns.getColumn(4).setPreferredWidth(100);
        columns.getColumn(5).setPreferredWidth(200);
        columns.getColumn(6).setPreferredWidth(150);
        columns.getColumn(7).setPreferredWidth(150);
    }

    public void setBans(ArrayList<Punishment> punishments) {
        this.punishments.clear();
        this.punishments.addAll(punishments);
        this.model.update();
    }

    public Punishment getSelectedBan() {
        int index = this.getSelectedRow();
        if (index == -1) {
            return null;
        }
        return this.punishments.get(index);
    }

    private class BanTableModel
    extends AbstractTableModel {
        private final String[] columns = new String[]{"Name", "GUID", "Type", "Start", "End", "Reason", "Admin", "Status"};

        private BanTableModel() {
        }

        public int getColumnCount() {
            return this.columns.length;
        }

        public void update() {
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return BanTable.this.punishments.size();
        }

        public String getColumnName(int column) {
            return this.columns[column];
        }

        public Object getValueAt(int row, int col) {
            Punishment p = (Punishment)BanTable.this.punishments.get(row);
            switch (col) {
                case 0: {
                    return p.getName();
                }
                case 1: {
                    return p.getPbGuid();
                }
                case 2: {
                    return p.getType().name();
                }
                case 3: {
                    return p.getStart();
                }
                case 4: {
                    return p.getEnd();
                }
                case 5: {
                    return p.getReason();
                }
                case 6: {
                    return p.getIssuer().getUserName();
                }
                case 7: {
                    if (!p.isEnabled()) {
                        return "lifted";
                    }
                    if (p.getType() == PunishmentType.ban) {
                        if (p.getEnd() > System.currentTimeMillis() / 1000L) {
                            return "in effect";
                        }
                        return "expired";
                    }
                    return "";
                }
            }
            return null;
        }
    }
}

