/*
 * Decompiled with CFR 0.152.
 */
package rcon.commands;

import rcon.MessageType;

public class Command {
    public static final Command EOF = new Command();
    private String name;
    private String[] arguments;
    private int seq;
    private MessageType type;

    public Command(String name, MessageType type, int seq, String ... arguments) {
        this.name = name;
        this.arguments = arguments;
        this.type = type;
        this.seq = seq;
    }

    public Command(String name, MessageType type, String ... arguments) {
        this.name = name;
        this.arguments = arguments;
        this.type = type;
        this.seq = 0;
    }

    private Command() {
    }

    public String getName() {
        return this.name;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    protected void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public int size() {
        return this.arguments.length;
    }

    public String get(int i) {
        return this.arguments[i];
    }

    public int getInt(int i) {
        return Integer.parseInt(this.get(i));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.seq);
        sb.append(',');
        sb.append((Object)this.getType());
        sb.append(']');
        sb.append(' ');
        sb.append(this.name);
        sb.append(' ');
        for (String argument : this.arguments) {
            sb.append(argument);
            sb.append(' ');
        }
        return sb.toString();
    }

    public MessageType getType() {
        return this.type;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int i) {
        this.seq = i;
    }

    public boolean is(String string) {
        return this.name.equals(string);
    }
}

