/*
 * Decompiled with CFR 0.152.
 */
package rcon.event;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import rcon.database.Database;
import rcon.event.RCONEventAdapter;
import rcon.players.Player;
import rcon.players.PlayerInfo;
import rcon.players.Punishment;
import rcon.players.PunishmentType;
import rcon.server.GameServer;

public class BanEnforcerHandler
extends RCONEventAdapter {
    static Logger logger = Logger.getLogger(BanEnforcerHandler.class);
    private Database db;
    private GameServer server;
    private SimpleDateFormat dateFormat;
    private TimeZone timeZone;
    private String message;

    public BanEnforcerHandler(GameServer server, Database db, String dateFormat, String timeZone, String bannedMessage) {
        this.server = server;
        this.db = db;
        this.dateFormat = new SimpleDateFormat(dateFormat);
        this.timeZone = TimeZone.getTimeZone(timeZone);
        this.dateFormat.setTimeZone(this.timeZone);
        this.message = bannedMessage;
    }

    public void onPbInfo(Player player, String pbGuid, String ip) {
        this.checkBans(player);
    }

    public void onAuthenticated(Player p) {
        this.checkBans(p);
    }

    public void onJoin(Player player, String eaGuid) {
        this.checkBans(player);
    }

    public void onPlayerInfo(Player p, PlayerInfo oldInfo, PlayerInfo info) {
        this.checkBans(p);
    }

    private void checkBans(Player player) {
        try {
            Punishment longest = this.getBans(player);
            if (longest != null) {
                logger.info("Enforcing ban for player " + player.getName() + ".");
                this.enforceBan(player, longest);
            }
        }
        catch (SQLException e) {
            logger.error("Database exception when checking and/or enforcing ban.", e);
        }
    }

    private void enforceBan(Player player, Punishment longest) throws SQLException {
        Calendar endTime = Calendar.getInstance(this.timeZone);
        System.out.println(endTime.getTimeZone());
        endTime.setTimeInMillis(longest.getEnd() * 1000L);
        String message = String.format(this.message, this.dateFormat.format(endTime.getTime()), this.db.bans.getReason(longest.getReason()));
        this.server.disconnect(player, message);
    }

    private Punishment getBans(Player player) throws SQLException {
        ArrayList<Punishment> bans = this.db.bans.getActive(player, PunishmentType.ban);
        Punishment longest = null;
        for (Punishment ban : bans) {
            if (!ban.isEnabled() || longest != null && ban.getEnd() <= longest.getEnd()) continue;
            longest = ban;
        }
        return longest;
    }
}

