/*
 * Decompiled with CFR 0.152.
 */
package rcon.map;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import rcon.map.Map;
import rcon.map.Playlist;

public class Maps {
    private String filename;
    private Playlist playlist;

    public Maps(String filename) {
        this.filename = filename;
        this.playlist = new Playlist();
    }

    public Playlist getPlaylist() {
        return this.playlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        Document doc;
        try {
            doc = this.getDocument(this.filename);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        Playlist playlist = this.playlist;
        synchronized (playlist) {
            this.playlist.clear();
            Element root = doc.getDocumentElement();
            if (root.getNodeName().equals("maps")) {
                for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1 || !node.getNodeName().equals("map")) continue;
                    Element mapNode = (Element)node;
                    this.parseMap(mapNode);
                }
            } else {
                throw new IOException("Invalid root node.");
            }
        }
    }

    private Document getDocument(String filename) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = this.getDocumentBuilder();
        Document doc = builder.parse(filename);
        return doc;
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        return builder;
    }

    private void parseMap(Element mapNode) {
        Map map;
        String name = mapNode.getAttribute("name");
        String roundString = mapNode.getAttribute("rounds");
        int rounds = 2;
        if (!roundString.isEmpty()) {
            try {
                rounds = Integer.parseInt(roundString);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if ((map = name.isEmpty() ? null : Map.get(name)) == null) {
            System.out.println("Unknown or invalid map '" + name + "'. Skipping.");
        } else {
            this.playlist.append(map, rounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        Document doc;
        try {
            doc = this.getDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        Playlist playlist = this.playlist;
        synchronized (playlist) {
            Element root = doc.createElement("maps");
            for (Playlist.Entry map : this.playlist.get()) {
                Element mapNode = doc.createElement("map");
                mapNode.setAttribute("name", map.getMap().getLevel());
                mapNode.setAttribute("rounds", String.valueOf(map.getRounds()));
                root.appendChild(mapNode);
            }
        }
        this.saveDocument(doc, this.filename);
    }

    private void saveDocument(Document doc, String filename) throws IOException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            DOMSource source = new DOMSource(doc);
            FileWriter fw = new FileWriter(filename);
            BufferedWriter w = new BufferedWriter(fw);
            StreamResult result = new StreamResult(w);
            t.transform(source, result);
            w.close();
            fw.close();
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }
}

