/*
 * Decompiled with CFR 0.152.
 */
package rcon.map;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rcon.map.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Playlist {
    private final List<Entry> playlist = new ArrayList<Entry>();

    public synchronized void append(Map map, int rounds) {
        this.playlist.add(new Entry(map, rounds));
    }

    public synchronized void insert(int index, Map map, int rounds) {
        this.playlist.add(index, new Entry(map, rounds));
    }

    public synchronized void remove(int index) {
        this.playlist.remove(index);
    }

    public synchronized Entry get(int index) {
        return this.playlist.get(index);
    }

    public synchronized List<Entry> get() {
        return new ArrayList<Entry>(this.playlist);
    }

    public synchronized int size() {
        return this.playlist.size();
    }

    public synchronized void clear() {
        this.playlist.clear();
    }

    public synchronized Entry getNext(Entry previous) {
        if (this.playlist.isEmpty()) {
            return null;
        }
        Iterator<Entry> it = this.playlist.iterator();
        while (it.hasNext()) {
            Entry next = it.next();
            if (next != previous) continue;
            if (it.hasNext()) {
                return it.next();
            }
            return this.playlist.get(0);
        }
        return this.playlist.get(0);
    }

    public static class Entry {
        private final Map map;
        private final int rounds;

        private Entry(Map map, int rounds) {
            this.map = map;
            this.rounds = rounds;
        }

        public Map getMap() {
            return this.map;
        }

        public int getRounds() {
            return this.rounds;
        }
    }
}

