/*
 * Decompiled with CFR 0.152.
 */
package rcon.server;

import java.io.IOException;
import org.apache.log4j.Logger;
import rcon.commands.Command;
import rcon.net.RCONInputStream;
import rcon.server.ServerConnection;

public class ReceiverThread
extends Thread {
    static Logger logger = Logger.getLogger(ReceiverThread.class);
    private RCONInputStream rin;
    private ServerConnection server;

    public ReceiverThread(RCONInputStream rin, ServerConnection server) {
        super("ReceiverThread");
        this.rin = rin;
        this.server = server;
    }

    public void run() {
        try {
            while (true) {
                Command command = this.rin.readCommand();
                switch (command.getType()) {
                    case server_request: 
                    case client_request: {
                        this.server.addEvent(command);
                        break;
                    }
                    case server_response: 
                    case client_response: {
                        this.server.addResponse(command);
                    }
                }
            }
        }
        catch (IOException e) {
            logger.trace("Message receiving stopped.");
            return;
        }
    }
}

