/*
 * Decompiled with CFR 0.152.
 */
package akuma;

import akuma.CLibrary;
import akuma.Daemon;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.ptr.IntByReference;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaVMArguments
extends ArrayList<String> {
    private static final boolean IS_LITTLE_ENDIAN = "little".equals(System.getProperty("sun.cpu.endian"));
    private static final Logger LOGGER = Logger.getLogger(JavaVMArguments.class.getName());

    public JavaVMArguments() {
    }

    public JavaVMArguments(Collection<? extends String> c) {
        super(c);
    }

    public void removeSystemProperty(String name) {
        name = "-D" + name;
        String nameeq = name + '=';
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            String s = (String)itr.next();
            if (!s.equals(name) && !s.startsWith(nameeq)) continue;
            itr.remove();
        }
    }

    public void setSystemProperty(String name, String value) {
        this.removeSystemProperty(name);
        this.add(1, "-D" + name + "=" + value);
    }

    public void removeTail(int n) {
        this.removeAll(this.subList(this.size() - n, this.size()));
    }

    StringArray toStringArray() {
        return new StringArray(this.toArray(new String[this.size()]));
    }

    public static JavaVMArguments current() throws IOException {
        return JavaVMArguments.of(-1);
    }

    public static JavaVMArguments of(int pid) throws IOException {
        String os = System.getProperty("os.name");
        if ("Linux".equals(os)) {
            return JavaVMArguments.ofLinux(pid);
        }
        if ("SunOS".equals(os)) {
            return JavaVMArguments.ofSolaris(pid);
        }
        if ("Mac OS X".equals(os)) {
            return JavaVMArguments.ofMac(pid);
        }
        throw new UnsupportedOperationException("Unsupported Operating System " + os);
    }

    private static JavaVMArguments ofLinux(int pid) throws IOException {
        pid = JavaVMArguments.resolvePID(pid);
        String cmdline = JavaVMArguments.readFile(new File("/proc/" + pid + "/cmdline"));
        JavaVMArguments args = new JavaVMArguments((Collection<? extends String>)Arrays.asList(cmdline.split("\u0000")));
        args.removeSystemProperty(Daemon.class.getName());
        return args;
    }

    private static int resolvePID(int pid) {
        if (pid == -1) {
            pid = CLibrary.LIBC.getpid();
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavaVMArguments ofSolaris(int pid) throws IOException {
        JavaVMArguments javaVMArguments;
        boolean areWe64 = "64".equals(System.getProperty("sun.arch.data.model"));
        pid = JavaVMArguments.resolvePID(pid);
        RandomAccessFile psinfo = new RandomAccessFile(new File("/proc/" + pid + "/psinfo"), "r");
        psinfo.seek(8L);
        if (JavaVMArguments.adjust(psinfo.readInt()) != pid) {
            throw new IOException("psinfo PID mismatch");
        }
        psinfo.seek(areWe64 ? 236L : 188L);
        int argc = JavaVMArguments.adjust(psinfo.readInt());
        long argp = JavaVMArguments.adjust(areWe64 ? psinfo.readLong() : JavaVMArguments.to64(psinfo.readInt()));
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("argc=%d,argp=%X", argc, argp));
        }
        File asFile = new File("/proc/" + pid + "/as");
        if (areWe64) {
            CLibrary.FILE fp = CLibrary.LIBC.fopen(asFile.getPath(), "r");
            try {
                JavaVMArguments args = new JavaVMArguments();
                Memory m = new Memory(8L);
                for (int n = 0; n < argc; ++n) {
                    JavaVMArguments.seek64(fp, argp + (long)(n * 8));
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest(String.format("Seeked to %X", CLibrary.LIBC.ftell(fp)));
                    }
                    m.setLong(0L, 0L);
                    CLibrary.LIBC.fread(m, 1, 8, fp);
                    long p = m.getLong(0L);
                    args.add(JavaVMArguments.readLine(fp, p, "argv[" + n + "]"));
                }
                JavaVMArguments n = args;
                return n;
            }
            finally {
                CLibrary.LIBC.fclose(fp);
            }
        }
        RandomAccessFile as = new RandomAccessFile(asFile, "r");
        try {
            JavaVMArguments args = new JavaVMArguments();
            for (int n = 0; n < argc; ++n) {
                as.seek(argp + (long)(n * 4));
                int p = JavaVMArguments.adjust(as.readInt());
                args.add(JavaVMArguments.readLine(as, p, "argv[" + n + "]"));
            }
            javaVMArguments = args;
        }
        catch (Throwable throwable) {
            as.close();
            throw throwable;
        }
        as.close();
        return javaVMArguments;
        finally {
            psinfo.close();
        }
    }

    private static void seek64(CLibrary.FILE fp, long upos) {
        CLibrary.LIBC.fseek(fp, 0L, 0);
        while (upos < 0L) {
            long chunk = Long.MAX_VALUE;
            upos -= chunk;
            CLibrary.LIBC.fseek(fp, chunk, 1);
        }
        CLibrary.LIBC.fseek(fp, upos, 1);
    }

    private static int adjust(int i) {
        if (IS_LITTLE_ENDIAN) {
            return i << 24 | i << 8 & 0xFF0000 | i >> 8 & 0xFF00 | i >>> 24;
        }
        return i;
    }

    private static long adjust(long i) {
        if (IS_LITTLE_ENDIAN) {
            return i << 56 | i << 40 & 0xFF000000000000L | i << 24 & 0xFF0000000000L | i << 8 & 0xFF00000000L | i >> 8 & 0xFF000000L | i >> 24 & 0xFF0000L | i >> 40 & 0xFF00L | i >> 56;
        }
        return i;
    }

    private static long to64(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    private static String readLine(RandomAccessFile as, int p, String prefix) throws IOException {
        int ch;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("Reading %s at %X", prefix, p));
        }
        as.seek(JavaVMArguments.to64(p));
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int i = 0;
        while ((ch = as.read()) > 0) {
            if (++i % 100 == 0 && LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest(prefix + " is so far " + buf.toString());
            }
            buf.write(ch);
        }
        String line = buf.toString();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(prefix + " was " + line);
        }
        return line;
    }

    private static String readLine(CLibrary.FILE as, long p, String prefix) throws IOException {
        byte b;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("Reading %s at %X", prefix, p));
        }
        JavaVMArguments.seek64(as, p);
        Memory m = new Memory(1L);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int i = 0;
        while (CLibrary.LIBC.fread(m, 1, 1, as) != 0 && (b = m.getByte(0L)) != 0) {
            if (++i % 100 == 0 && LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest(prefix + " is so far " + buf.toString());
            }
            buf.write(b);
        }
        String line = buf.toString();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(prefix + " was " + line);
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File f) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream fin = new FileInputStream(f);
        try {
            int sz;
            byte[] buf = new byte[1024];
            while ((sz = fin.read(buf)) >= 0) {
                baos.write(buf, 0, sz);
            }
            String string = baos.toString();
            return string;
        }
        finally {
            fin.close();
        }
    }

    private static JavaVMArguments ofMac(int pid) {
        boolean CTL_KERN = true;
        int KERN_ARGMAX = 8;
        int KERN_PROCARGS2 = 49;
        final int sizeOfInt = Native.getNativeSize(Integer.TYPE);
        IntByReference _ = new IntByReference();
        IntByReference argmaxRef = new IntByReference(0);
        IntByReference size = new IntByReference(sizeOfInt);
        if (CLibrary.LIBC.sysctl(new int[]{1, 8}, 2, argmaxRef.getPointer(), size, Pointer.NULL, _) != 0) {
            throw new UnsupportedOperationException("Failed to get kernl.argmax: " + CLibrary.LIBC.strerror(Native.getLastError()));
        }
        int argmax = argmaxRef.getValue();
        LOGGER.fine("argmax=" + argmax);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class StringArrayMemory
        extends Memory {
            private long offset;

            StringArrayMemory(long l) {
                super(l);
                this.offset = 0L;
            }

            int readInt() {
                int r = this.getInt(this.offset);
                this.offset += (long)sizeOfInt;
                return r;
            }

            byte peek() {
                return this.getByte(this.offset);
            }

            String readString() {
                byte ch;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((ch = this.getByte(this.offset++)) != 0) {
                    baos.write(ch);
                }
                return baos.toString();
            }

            void skip0() {
                while (this.getByte(this.offset) == 0) {
                    ++this.offset;
                }
            }
        }
        StringArrayMemory m = new StringArrayMemory((long)argmax);
        size.setValue(argmax);
        if (CLibrary.LIBC.sysctl(new int[]{1, 49, JavaVMArguments.resolvePID(pid)}, 3, m, size, Pointer.NULL, _) != 0) {
            throw new UnsupportedOperationException("Failed to obtain ken.procargs2: " + CLibrary.LIBC.strerror(Native.getLastError()));
        }
        JavaVMArguments args = new JavaVMArguments();
        int nargs = m.readInt();
        m.readString();
        for (int i = 0; i < nargs; ++i) {
            m.skip0();
            args.add(m.readString());
        }
        return args;
    }

    public static void main(String[] args) throws IOException {
        System.out.println("sun.arch.data.model=" + System.getProperty("sun.arch.data.model"));
        System.out.println("sun.cpu.endian=" + System.getProperty("sun.cpu.endian"));
        LOGGER.setLevel(Level.ALL);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.ALL);
        LOGGER.addHandler(handler);
        if (args.length == 0) {
            System.out.println(JavaVMArguments.current());
        } else {
            for (String arg : args) {
                System.out.println(JavaVMArguments.of(Integer.valueOf(arg)));
            }
        }
    }
}

