/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ConstraintCore;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public final class Constraint
implements SchemaObject {
    ConstraintCore core;
    private HsqlNameManager.HsqlName name;
    int constType;
    boolean isForward;
    Expression check;
    private boolean isNotNull;
    int notNullColumnIndex;
    RangeVariable rangeVariable;
    OrderedHashSet mainColSet;
    OrderedHashSet refColSet;
    public static final Constraint[] emptyArray = new Constraint[0];

    private Constraint() {
    }

    public Constraint(HsqlNameManager.HsqlName hsqlName, Table table, Index index, int n) {
        this.core = new ConstraintCore();
        this.name = hsqlName;
        this.constType = n;
        this.core.mainTable = table;
        this.core.mainIndex = index;
        this.core.mainCols = index.getColumns();
        for (int i = 0; i < this.core.mainCols.length; ++i) {
            Type type = table.getColumn(this.core.mainCols[i]).getDataType();
            if (!type.isLobType()) continue;
            throw Error.error(5534);
        }
    }

    public Constraint(HsqlNameManager.HsqlName hsqlName, Constraint constraint) {
        this.name = hsqlName;
        this.constType = 1;
        this.core = constraint.core;
    }

    public Constraint(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2, OrderedHashSet orderedHashSet, HsqlNameManager.HsqlName hsqlName3, OrderedHashSet orderedHashSet2, int n, int n2, int n3, int n4) {
        this.core = new ConstraintCore();
        this.name = hsqlName;
        this.constType = n;
        this.mainColSet = orderedHashSet2;
        this.core.refTableName = hsqlName2;
        this.core.mainTableName = hsqlName3;
        this.refColSet = orderedHashSet;
        this.core.deleteAction = n2;
        this.core.updateAction = n3;
        this.core.matchType = n4;
        switch (this.core.deleteAction) {
            case 0: 
            case 2: 
            case 4: {
                this.core.hasDeleteAction = true;
            }
        }
        switch (this.core.updateAction) {
            case 0: 
            case 2: 
            case 4: {
                this.core.hasUpdateAction = true;
            }
        }
    }

    public Constraint(HsqlNameManager.HsqlName hsqlName, OrderedHashSet orderedHashSet, int n) {
        this.core = new ConstraintCore();
        this.name = hsqlName;
        this.constType = n;
        this.mainColSet = orderedHashSet;
    }

    Constraint duplicate() {
        Constraint constraint = new Constraint();
        constraint.core = this.core.duplicate();
        constraint.name = this.name;
        constraint.constType = this.constType;
        constraint.isForward = this.isForward;
        constraint.check = this.check;
        constraint.isNotNull = this.isNotNull;
        constraint.notNullColumnIndex = this.notNullColumnIndex;
        constraint.rangeVariable = this.rangeVariable;
        return constraint;
    }

    void setColumnsIndexes(Table table) {
        block8: {
            block7: {
                if (this.constType != 0) break block7;
                if (this.mainColSet == null) {
                    this.core.mainCols = this.core.mainTable.getPrimaryKey();
                    if (this.core.mainCols == null) {
                        throw Error.error(5581);
                    }
                } else if (this.core.mainCols == null) {
                    this.core.mainCols = this.core.mainTable.getColumnIndexes(this.mainColSet);
                }
                if (this.core.refCols == null) {
                    this.core.refCols = table.getColumnIndexes(this.refColSet);
                }
                for (int i = 0; i < this.core.refCols.length; ++i) {
                    Type type = table.getColumn(this.core.refCols[i]).getDataType();
                    if (!type.isLobType()) continue;
                    throw Error.error(5534);
                }
                break block8;
            }
            if (this.mainColSet == null) break block8;
            this.core.mainCols = table.getColumnIndexes(this.mainColSet);
            for (int i = 0; i < this.core.mainCols.length; ++i) {
                Type type = table.getColumn(this.core.mainCols[i]).getDataType();
                if (!type.isLobType()) continue;
                throw Error.error(5534);
            }
        }
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        switch (this.constType) {
            case 3: {
                OrderedHashSet orderedHashSet = new OrderedHashSet();
                this.check.collectObjectNames(orderedHashSet);
                for (int i = orderedHashSet.size() - 1; i >= 0; --i) {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                    if (hsqlName.type != 9 && hsqlName.type != 3) continue;
                    orderedHashSet.remove(i);
                }
                return orderedHashSet;
            }
            case 0: {
                OrderedHashSet orderedHashSet = new OrderedHashSet();
                orderedHashSet.add(this.core.uniqueName);
                return orderedHashSet;
            }
        }
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.getConstraintType()) {
            case 4: {
                if (this.getMainColumns().length <= 1 && (this.getMainColumns().length != 1 || this.getName().isReservedName())) break;
                if (!this.getName().isReservedName()) {
                    stringBuffer.append("CONSTRAINT").append(' ');
                    stringBuffer.append(this.getName().statementName).append(' ');
                }
                stringBuffer.append("PRIMARY").append(' ').append("KEY");
                stringBuffer.append(this.getMain().getColumnListSQL(this.getMainColumns(), this.getMainColumns().length));
                break;
            }
            case 2: {
                if (!this.getName().isReservedName()) {
                    stringBuffer.append("CONSTRAINT").append(' ');
                    stringBuffer.append(this.getName().statementName);
                    stringBuffer.append(' ');
                }
                stringBuffer.append("UNIQUE");
                int[] nArray = this.getMainColumns();
                stringBuffer.append(this.getMain().getColumnListSQL(nArray, nArray.length));
                break;
            }
            case 0: {
                if (this.isForward) {
                    stringBuffer.append("ALTER").append(' ').append("TABLE").append(' ');
                    stringBuffer.append(this.getRef().getName().getSchemaQualifiedStatementName());
                    stringBuffer.append(' ').append("ADD").append(' ');
                    this.getFKStatement(stringBuffer);
                    break;
                }
                this.getFKStatement(stringBuffer);
                break;
            }
            case 3: {
                if (this.isNotNull()) break;
                if (!this.getName().isReservedName()) {
                    stringBuffer.append("CONSTRAINT").append(' ');
                    stringBuffer.append(this.getName().statementName).append(' ');
                }
                stringBuffer.append("CHECK").append('(');
                stringBuffer.append(this.check.getSQL());
                stringBuffer.append(')');
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    private void getFKStatement(StringBuffer stringBuffer) {
        if (!this.getName().isReservedName()) {
            stringBuffer.append("CONSTRAINT").append(' ');
            stringBuffer.append(this.getName().statementName);
            stringBuffer.append(' ');
        }
        stringBuffer.append("FOREIGN").append(' ').append("KEY");
        int[] nArray = this.getRefColumns();
        stringBuffer.append(this.getRef().getColumnListSQL(nArray, nArray.length));
        stringBuffer.append(' ').append("REFERENCES").append(' ');
        stringBuffer.append(this.getMain().getName().getSchemaQualifiedStatementName());
        nArray = this.getMainColumns();
        stringBuffer.append(this.getMain().getColumnListSQL(nArray, nArray.length));
        if (this.getDeleteAction() != 3) {
            stringBuffer.append(' ').append("ON").append(' ').append("DELETE").append(' ');
            stringBuffer.append(this.getDeleteActionString());
        }
        if (this.getUpdateAction() != 3) {
            stringBuffer.append(' ').append("ON").append(' ').append("UPDATE").append(' ');
            stringBuffer.append(this.getUpdateActionString());
        }
    }

    public HsqlNameManager.HsqlName getMainTableName() {
        return this.core.mainTableName;
    }

    public HsqlNameManager.HsqlName getMainName() {
        return this.core.mainName;
    }

    public HsqlNameManager.HsqlName getRefName() {
        return this.core.refName;
    }

    public HsqlNameManager.HsqlName getUniqueName() {
        return this.core.uniqueName;
    }

    public int getConstraintType() {
        return this.constType;
    }

    public Table getMain() {
        return this.core.mainTable;
    }

    Index getMainIndex() {
        return this.core.mainIndex;
    }

    public Table getRef() {
        return this.core.refTable;
    }

    Index getRefIndex() {
        return this.core.refIndex;
    }

    private static String getActionString(int n) {
        switch (n) {
            case 1: {
                return "RESTRICT";
            }
            case 0: {
                return "CASCADE";
            }
            case 4: {
                return "SET DEFAULT";
            }
            case 2: {
                return "SET NULL";
            }
        }
        return "NO ACTION";
    }

    public int getDeleteAction() {
        return this.core.deleteAction;
    }

    public String getDeleteActionString() {
        return Constraint.getActionString(this.core.deleteAction);
    }

    public int getUpdateAction() {
        return this.core.updateAction;
    }

    public String getUpdateActionString() {
        return Constraint.getActionString(this.core.updateAction);
    }

    public boolean hasTriggeredAction() {
        if (this.constType == 0) {
            switch (this.core.deleteAction) {
                case 0: 
                case 2: 
                case 4: {
                    return true;
                }
            }
            switch (this.core.updateAction) {
                case 0: 
                case 2: 
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    public int getDeferability() {
        return 0;
    }

    public int[] getMainColumns() {
        return this.core.mainCols;
    }

    public int[] getRefColumns() {
        return this.core.refCols;
    }

    public String getCheckSQL() {
        return this.check.getSQL();
    }

    public boolean isNotNull() {
        return this.isNotNull;
    }

    boolean hasColumnOnly(int n) {
        switch (this.constType) {
            case 3: {
                return this.rangeVariable.usedColumns[n] && ArrayUtil.countTrueElements(this.rangeVariable.usedColumns) == 1;
            }
            case 2: 
            case 4: {
                return this.core.mainCols.length == 1 && this.core.mainCols[0] == n;
            }
            case 1: {
                return this.core.mainCols.length == 1 && this.core.mainCols[0] == n && this.core.mainTable == this.core.refTable;
            }
            case 0: {
                return this.core.refCols.length == 1 && this.core.refCols[0] == n && this.core.mainTable == this.core.refTable;
            }
        }
        throw Error.runtimeError(201, "Constraint");
    }

    boolean hasColumnPlus(int n) {
        switch (this.constType) {
            case 3: {
                return this.rangeVariable.usedColumns[n] && ArrayUtil.countTrueElements(this.rangeVariable.usedColumns) > 1;
            }
            case 2: 
            case 4: {
                return this.core.mainCols.length != 1 && ArrayUtil.find(this.core.mainCols, n) != -1;
            }
            case 1: {
                return ArrayUtil.find(this.core.mainCols, n) != -1 && (this.core.mainCols.length != 1 || this.core.mainTable != this.core.refTable);
            }
            case 0: {
                return ArrayUtil.find(this.core.refCols, n) != -1 && (this.core.mainCols.length != 1 || this.core.mainTable == this.core.refTable);
            }
        }
        throw Error.runtimeError(201, "Constraint");
    }

    boolean hasColumn(int n) {
        switch (this.constType) {
            case 3: {
                return this.rangeVariable.usedColumns[n];
            }
            case 1: 
            case 2: 
            case 4: {
                return ArrayUtil.find(this.core.mainCols, n) != -1;
            }
            case 0: {
                return ArrayUtil.find(this.core.refCols, n) != -1;
            }
        }
        throw Error.runtimeError(201, "Constraint");
    }

    boolean isUniqueWithColumns(int[] nArray) {
        if (this.constType != 2 || this.core.mainCols.length != nArray.length) {
            return false;
        }
        return ArrayUtil.haveEqualSets(this.core.mainCols, nArray, nArray.length);
    }

    boolean isEquivalent(Table table, int[] nArray, Table table2, int[] nArray2) {
        if (this.constType != 1 && this.constType != 0) {
            return false;
        }
        if (table != this.core.mainTable || table2 != this.core.refTable) {
            return false;
        }
        return ArrayUtil.areEqualSets(this.core.mainCols, nArray) && ArrayUtil.areEqualSets(this.core.refCols, nArray2);
    }

    void updateTable(Session session, Table table, Table table2, int n, int n2) {
        if (table == this.core.mainTable) {
            this.core.mainTable = table2;
            if (this.core.mainIndex != null) {
                this.core.mainIndex = this.core.mainTable.getIndex(this.core.mainIndex.getName().name);
                this.core.mainCols = ArrayUtil.toAdjustedColumnArray(this.core.mainCols, n, n2);
                this.core.mainIndex.setTable(table2);
            }
        }
        if (table == this.core.refTable) {
            this.core.refTable = table2;
            if (this.core.refIndex != null) {
                this.core.refIndex = this.core.refTable.getIndex(this.core.refIndex.getName().name);
                this.core.refCols = ArrayUtil.toAdjustedColumnArray(this.core.refCols, n, n2);
                this.core.refIndex.setTable(table2);
            }
        }
        if (this.constType == 3) {
            this.recompile(session, table2);
        }
    }

    void checkInsert(Session session, Table table, Object[] objectArray, boolean bl) {
        switch (this.constType) {
            case 3: {
                if (!this.isNotNull) {
                    this.checkCheckConstraint(session, table, objectArray);
                }
                return;
            }
            case 0: {
                PersistentStore persistentStore = session.sessionData.getRowStore(this.core.mainTable);
                if (ArrayUtil.hasNull(objectArray, this.core.refCols)) {
                    if (this.core.matchType == 59) {
                        return;
                    }
                    if (this.core.refCols.length == 1) {
                        return;
                    }
                    if (ArrayUtil.hasAllNull(objectArray, this.core.refCols)) {
                        return;
                    }
                } else if (this.core.mainIndex.existsParent(session, persistentStore, objectArray, this.core.refCols)) {
                    return;
                }
                throw this.getException(objectArray);
            }
        }
    }

    void checkCheckConstraint(Session session, Table table, Object[] objectArray) {
        RangeVariable.RangeIteratorBase rangeIteratorBase = session.sessionContext.getCheckIterator(this.rangeVariable);
        rangeIteratorBase.currentData = objectArray;
        boolean bl = Boolean.FALSE.equals(this.check.getValue(session));
        rangeIteratorBase.currentData = null;
        if (bl) {
            Object[] objectArray2 = new String[]{this.name.name, table.tableName.name};
            throw Error.error(null, 157, 2, objectArray2);
        }
    }

    void checkCheckConstraint(Session session, Table table, Object object) {
        session.sessionData.currentValue = object;
        boolean bl = Boolean.FALSE.equals(this.check.getValue(session));
        session.sessionData.currentValue = null;
        if (bl) {
            if (table == null) {
                throw Error.error(157, this.name.name);
            }
            Object[] objectArray = new String[]{this.name.name, table.tableName.name};
            throw Error.error(null, 157, 2, objectArray);
        }
    }

    public HsqlException getException(Object[] objectArray) {
        switch (this.constType) {
            case 3: {
                Object[] objectArray2 = new String[]{this.name.name};
                return Error.error(null, 157, 2, objectArray2);
            }
            case 0: {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < this.core.refCols.length; ++i) {
                    Object object = objectArray[this.core.refCols[i]];
                    stringBuffer.append(this.core.refTable.getColumnTypes()[this.core.refCols[i]].convertToString(object));
                    stringBuffer.append(',');
                }
                Object[] objectArray3 = new String[]{this.getName().statementName, this.core.refTable.getName().statementName, stringBuffer.toString()};
                return Error.error(null, 177, 2, objectArray3);
            }
            case 2: 
            case 4: {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < this.core.mainCols.length; ++i) {
                    Object object = objectArray[this.core.mainCols[i]];
                    stringBuffer.append(this.core.mainTable.colTypes[this.core.mainCols[i]].convertToString(object));
                    stringBuffer.append(',');
                }
                return Error.error(null, 104, 2, new String[]{this.getName().statementName, this.core.mainTable.getName().statementName, stringBuffer.toString()});
            }
        }
        throw Error.runtimeError(201, "Constraint");
    }

    RowIterator findFkRef(Session session, Object[] objectArray) {
        if (objectArray == null || ArrayUtil.hasNull(objectArray, this.core.mainCols)) {
            return this.core.refIndex.emptyIterator();
        }
        PersistentStore persistentStore = session.sessionData.getRowStore(this.core.refTable);
        return this.core.refIndex.findFirstRow(session, persistentStore, objectArray, this.core.mainCols);
    }

    void checkReferencedRows(Session session, Table table) {
        Row row;
        RowIterator rowIterator = table.rowIterator(session);
        while ((row = rowIterator.getNextRow()) != null) {
            Object[] objectArray = row.getData();
            this.checkInsert(session, table, objectArray, false);
        }
    }

    public Expression getCheckExpression() {
        return this.check;
    }

    public OrderedHashSet getCheckColumnExpressions() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        Expression.collectAllExpressions(orderedHashSet, this.check, Expression.columnExpressionSet, Expression.emptyExpressionSet);
        return orderedHashSet;
    }

    void recompile(Session session, Table table) {
        Expression expression;
        String string = this.check.getSQL();
        Scanner scanner = new Scanner(string);
        ParserDQL parserDQL = new ParserDQL(session, scanner);
        parserDQL.read();
        parserDQL.isCheckOrTriggerCondition = true;
        this.check = expression = parserDQL.XreadBooleanValueExpression();
        QuerySpecification querySpecification = Expression.getCheckSelect(session, table, this.check);
        this.rangeVariable = querySpecification.rangeVariables[0];
        this.rangeVariable.setForCheckConstraint();
    }

    void prepareCheckConstraint(Session session, Table table, boolean bl) {
        this.check.checkValidCheckConstraint();
        if (table == null) {
            this.check.resolveTypes(session, null);
        } else {
            QuerySpecification querySpecification = Expression.getCheckSelect(session, table, this.check);
            Result result = querySpecification.getResult(session, 1);
            if (result.getNavigator().getSize() != 0) {
                Object[] objectArray = new String[]{table.getName().name, ""};
                throw Error.error(null, 157, 2, objectArray);
            }
            this.rangeVariable = querySpecification.rangeVariables[0];
            this.rangeVariable.setForCheckConstraint();
        }
        if (this.check.getType() == 48 && this.check.getLeftNode().getType() == 47 && this.check.getLeftNode().getLeftNode().getType() == 2) {
            this.notNullColumnIndex = this.check.getLeftNode().getLeftNode().getColumnIndex();
            this.isNotNull = true;
        }
    }
}

