/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Collation;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.SchemaManager;
import org.hsqldb.Session;
import org.hsqldb.SessionManager;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManager2PL;
import org.hsqldb.dbinfo.DatabaseInformation;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.LobManager;
import org.hsqldb.persist.Logger;
import org.hsqldb.persist.PersistentStoreCollectionDatabase;
import org.hsqldb.result.Result;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.User;
import org.hsqldb.rights.UserManager;
import org.hsqldb.types.Type;

public class Database {
    int databaseID;
    String databaseUniqueName;
    String databaseType;
    private final String canonicalPath;
    public HsqlProperties urlProperties;
    private final String path;
    DatabaseInformation dbInfo;
    private int dbState;
    public Logger logger;
    boolean databaseReadOnly;
    private boolean filesReadOnly;
    private boolean filesInJar;
    public boolean sqlEnforceSize;
    public boolean sqlEnforceNames;
    private boolean isReferentialIntegrity;
    public HsqlDatabaseProperties databaseProperties;
    private final boolean shutdownOnNoConnection;
    int resultMaxMemoryRows;
    public UserManager userManager;
    public GranteeManager granteeManager;
    public HsqlNameManager nameManager;
    public SessionManager sessionManager;
    public TransactionManager txManager;
    public int defaultIsolationLevel = 2;
    public SchemaManager schemaManager;
    public PersistentStoreCollectionDatabase persistentStoreCollection;
    public LobManager lobManager;
    public Collation collation;
    public static final int DATABASE_ONLINE = 1;
    public static final int DATABASE_OPENING = 2;
    public static final int DATABASE_CLOSING = 3;
    public static final int DATABASE_SHUTDOWN = 4;
    public static final int CLOSEMODE_IMMEDIATELY = 1;
    public static final int CLOSEMODE_NORMAL = 2;
    public static final int CLOSEMODE_COMPACT = 3;
    public static final int CLOSEMODE_SCRIPT = 4;

    Database(String string, String string2, String string3, HsqlProperties hsqlProperties) {
        this.setState(4);
        this.databaseType = string;
        this.path = string2;
        this.canonicalPath = string3;
        this.urlProperties = hsqlProperties;
        if (this.databaseType == "res:") {
            this.filesInJar = true;
            this.filesReadOnly = true;
        }
        this.logger = new Logger(this);
        this.shutdownOnNoConnection = this.urlProperties.isPropertyTrue("shutdown");
        this.lobManager = new LobManager(this);
    }

    synchronized void open() {
        if (!this.isShutdown()) {
            return;
        }
        this.reopen();
    }

    void reopen() {
        boolean bl = false;
        this.setState(2);
        try {
            this.nameManager = new HsqlNameManager(this);
            this.granteeManager = new GranteeManager(this);
            this.userManager = new UserManager(this);
            this.schemaManager = new SchemaManager(this);
            this.persistentStoreCollection = new PersistentStoreCollectionDatabase();
            this.isReferentialIntegrity = true;
            this.sessionManager = new SessionManager(this);
            Database database = this;
            this.collation = database.collation.getDefaultInstance();
            this.dbInfo = DatabaseInformation.newDatabaseInformation(this);
            this.txManager = new TransactionManager2PL(this);
            this.lobManager.createSchema();
            this.sessionManager.getSysLobSession().setSchema("SYSTEM_LOBS");
            this.logger.openPersistence();
            bl = this.logger.isNewDatabase;
            if (bl) {
                this.userManager.createSAUser();
                this.schemaManager.createPublicSchema();
                this.lobManager.initialiseLobSpace();
                this.logger.checkpoint(false);
            }
            this.lobManager.open();
            this.dbInfo.setWithContent(true);
        }
        catch (Throwable throwable) {
            HsqlException hsqlException;
            this.logger.closePersistence(1);
            this.logger.releaseLock();
            this.setState(4);
            this.clearStructures();
            DatabaseManager.removeDatabase(this);
            if (!(throwable instanceof HsqlException)) {
                hsqlException = Error.error(458, throwable);
            }
            this.logger.logSevereEvent("could not reopen database", hsqlException);
            throw hsqlException;
        }
        this.setState(1);
    }

    void clearStructures() {
        if (this.schemaManager != null) {
            this.schemaManager.clearStructures();
        }
        this.granteeManager = null;
        this.userManager = null;
        this.nameManager = null;
        this.schemaManager = null;
        this.sessionManager = null;
        this.dbInfo = null;
    }

    public int getDatabaseID() {
        return this.databaseID;
    }

    public String getUniqueName() {
        return this.databaseUniqueName;
    }

    public void setUniqueName(String string) {
        this.databaseUniqueName = string;
    }

    public String getType() {
        return this.databaseType;
    }

    public String getPath() {
        return this.path;
    }

    public HsqlNameManager.HsqlName getCatalogName() {
        return this.nameManager.getCatalogName();
    }

    public HsqlDatabaseProperties getProperties() {
        return this.databaseProperties;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public boolean isReadOnly() {
        return this.databaseReadOnly;
    }

    synchronized boolean isShutdown() {
        return this.dbState == 4;
    }

    synchronized Session connect(String string, String string2, String string3, int n) {
        if (string.equalsIgnoreCase("SA")) {
            string = "SA";
        }
        User user = this.userManager.getUser(string, string2);
        Session session = this.sessionManager.newSession(this, user, this.databaseReadOnly, false, string3, n);
        return session;
    }

    public void setReadOnly() {
        this.databaseReadOnly = true;
        this.filesReadOnly = true;
    }

    public void setFilesReadOnly() {
        this.filesReadOnly = true;
    }

    public boolean isFilesReadOnly() {
        return this.filesReadOnly;
    }

    public boolean isFilesInJar() {
        return this.filesInJar;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public GranteeManager getGranteeManager() {
        return this.granteeManager;
    }

    public void setReferentialIntegrity(boolean bl) {
        this.isReferentialIntegrity = bl;
    }

    public boolean isReferentialIntegrity() {
        return this.isReferentialIntegrity;
    }

    public int getResultMaxMemoryRows() {
        return this.resultMaxMemoryRows;
    }

    public void setResultMaxMemoryRows(int n) {
        this.resultMaxMemoryRows = n;
    }

    public void setStrictNames(boolean bl) {
        this.sqlEnforceNames = bl;
    }

    public void setStrictColumnSize(boolean bl) {
        this.sqlEnforceSize = bl;
    }

    public int getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    protected void finalize() {
        if (this.getState() != 1) {
            return;
        }
        try {
            this.close(1);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    void closeIfLast() {
        if (this.shutdownOnNoConnection && this.sessionManager.isEmpty()) {
            if (this.dbState == 1) {
                try {
                    this.close(2);
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
    }

    public void close(int n) {
        HsqlException hsqlException = null;
        this.setState(3);
        this.sessionManager.closeAllSessions();
        this.sessionManager.clearAll();
        if (this.filesReadOnly) {
            n = 1;
        }
        this.logger.closePersistence(n);
        this.lobManager.close();
        try {
            if (n == 3) {
                this.clearStructures();
                this.reopen();
                this.setState(3);
                this.logger.closePersistence(2);
                this.lobManager.close();
            }
        }
        catch (Throwable throwable) {
            hsqlException = throwable instanceof HsqlException ? (HsqlException)throwable : Error.error(458, throwable.toString());
        }
        this.logger.releaseLock();
        this.setState(4);
        this.clearStructures();
        DatabaseManager.removeDatabase(this);
        if (hsqlException != null) {
            throw hsqlException;
        }
    }

    public void setMetaDirty(boolean bl) {
        if (this.dbInfo != null) {
            this.dbInfo.setDirty();
        }
    }

    private synchronized void setState(int n) {
        this.dbState = n;
    }

    synchronized int getState() {
        return this.dbState;
    }

    String getStateString() {
        int n = this.getState();
        switch (n) {
            case 3: {
                return "DATABASE_CLOSING";
            }
            case 1: {
                return "DATABASE_ONLINE";
            }
            case 2: {
                return "DATABASE_OPENING";
            }
            case 4: {
                return "DATABASE_SHUTDOWN";
            }
        }
        return "UNKNOWN";
    }

    public String[] getSettingsSQL() {
        String[] stringArray;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        if (!this.getCatalogName().name.equals("PUBLIC")) {
            stringArray = this.getCatalogName().statementName;
            hsqlArrayList.add("ALTER CATALOG PUBLIC RENAME TO " + (String)stringArray);
        }
        if (this.collation.collator != null) {
            stringArray = this.collation.getName().statementName;
            hsqlArrayList.add("SET DATABASE COLLATION " + (String)stringArray);
        }
        stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    public Result getScript(boolean bl) {
        Result result = Result.newSingleColumnResult("COMMAND", Type.SQL_VARCHAR);
        String[] stringArray = this.logger.getPropertiesSQL();
        Database.addRows(result, stringArray);
        stringArray = this.getSettingsSQL();
        Database.addRows(result, stringArray);
        stringArray = this.getGranteeManager().getSQL();
        Database.addRows(result, stringArray);
        stringArray = this.schemaManager.getSQLArray();
        Database.addRows(result, stringArray);
        stringArray = this.getUserManager().getInitialSchemaSQL();
        Database.addRows(result, stringArray);
        stringArray = this.getGranteeManager().getRightstSQL();
        Database.addRows(result, stringArray);
        if (bl) {
            stringArray = this.schemaManager.getIndexRootsSQL();
            Database.addRows(result, stringArray);
        }
        stringArray = this.schemaManager.getTablePropsSQL(!bl);
        Database.addRows(result, stringArray);
        return result;
    }

    private static void addRows(Result result, String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object[] objectArray = new String[]{stringArray[i]};
            result.initialiseNavigator().add(objectArray);
        }
    }

    public String getURI() {
        return this.databaseType + this.canonicalPath;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public HsqlProperties getURLProperties() {
        return this.urlProperties;
    }
}

