/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionOp;
import org.hsqldb.FunctionSQL;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

public class ExpressionLogical
extends Expression {
    boolean noOptimisation;

    ExpressionLogical(int n) {
        super(n);
        this.dataType = Type.SQL_BOOLEAN;
    }

    ExpressionLogical(boolean bl) {
        super(1);
        this.dataType = Type.SQL_BOOLEAN;
        this.valueData = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    ExpressionLogical(RangeVariable rangeVariable, int n, RangeVariable rangeVariable2, int n2) {
        super(41);
        ExpressionColumn expressionColumn = new ExpressionColumn(rangeVariable, n);
        ExpressionColumn expressionColumn2 = new ExpressionColumn(rangeVariable2, n2);
        this.nodes = new Expression[2];
        this.dataType = Type.SQL_BOOLEAN;
        this.nodes[0] = expressionColumn;
        this.nodes[1] = expressionColumn2;
    }

    ExpressionLogical(Expression expression, Expression expression2) {
        super(41);
        this.nodes = new Expression[2];
        this.nodes[0] = expression;
        this.nodes[1] = expression2;
        if (expression.opType == 2 && expression2.opType == 2) {
            this.isColumnEqual = true;
        }
        this.dataType = Type.SQL_BOOLEAN;
    }

    ExpressionLogical(int n, Expression expression, Expression expression2) {
        super(n);
        this.nodes = new Expression[2];
        this.nodes[0] = expression;
        this.nodes[1] = expression2;
        switch (this.opType) {
            case 41: {
                if (expression.opType == 2 && expression2.opType == 2) {
                    this.isColumnEqual = true;
                }
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
    }

    ExpressionLogical(int n, Expression expression) {
        super(n);
        this.nodes = new Expression[1];
        this.nodes[0] = expression;
        switch (this.opType) {
            case 47: 
            case 48: 
            case 55: 
            case 57: {
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
    }

    ExpressionLogical(ColumnSchema columnSchema) {
        super(48);
        this.nodes = new Expression[1];
        this.dataType = Type.SQL_BOOLEAN;
        Expression expression = new ExpressionColumn(columnSchema);
        expression = new ExpressionLogical(47, expression);
        this.nodes[0] = expression;
    }

    static Expression andExpressions(Expression expression, Expression expression2) {
        if (expression == null) {
            return expression2;
        }
        if (expression2 == null) {
            return expression;
        }
        return new ExpressionLogical(49, expression, expression2);
    }

    static Expression orExpressions(Expression expression, Expression expression2) {
        if (expression == null) {
            return expression2;
        }
        if (expression2 == null) {
            return expression;
        }
        return new ExpressionLogical(50, expression, expression2);
    }

    public void addLeftColumnsForAllAny(OrderedIntHashSet orderedIntHashSet) {
        if (this.nodes.length == 0) {
            return;
        }
        for (int i = 0; i < this.nodes[0].nodes.length; ++i) {
            int n = this.nodes[0].nodes[i].getColumnIndex();
            if (n < 0) continue;
            orderedIntHashSet.add(n);
        }
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (this.opType == 1) {
            return super.getSQL();
        }
        String string = ExpressionLogical.getContextSQL(this.nodes[0]);
        String string2 = ExpressionLogical.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        switch (this.opType) {
            case 48: {
                if (this.nodes[0].opType == 47) {
                    stringBuffer.append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[0])).append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                    return stringBuffer.toString();
                }
                if (this.nodes[0].opType == 58) {
                    stringBuffer.append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[0])).append(' ').append("IS").append(' ').append("DISTINCT").append(' ').append("FROM").append(' ').append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[1]));
                    return stringBuffer.toString();
                }
                stringBuffer.append("NOT").append(' ').append(string);
                return stringBuffer.toString();
            }
            case 58: {
                stringBuffer.append("NOT").append(' ').append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[0])).append(' ').append("IS").append(' ').append("DISTINCT").append(' ').append("FROM").append(' ').append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[1]));
                return stringBuffer.toString();
            }
            case 47: {
                stringBuffer.append(string).append(' ').append("IS").append(' ').append("NULL");
                return stringBuffer.toString();
            }
            case 57: {
                stringBuffer.append(' ').append("UNIQUE").append(' ');
                break;
            }
            case 55: {
                stringBuffer.append(' ').append("EXISTS").append(' ');
                break;
            }
            case 41: {
                stringBuffer.append(string).append('=').append(string2);
                return stringBuffer.toString();
            }
            case 42: {
                stringBuffer.append(string).append(">=").append(string2);
                return stringBuffer.toString();
            }
            case 43: {
                stringBuffer.append(string).append('>').append(string2);
                return stringBuffer.toString();
            }
            case 44: {
                stringBuffer.append(string).append('<').append(string2);
                return stringBuffer.toString();
            }
            case 45: {
                stringBuffer.append(string).append("<=").append(string2);
                return stringBuffer.toString();
            }
            case 46: {
                if ("NULL".equals(string2)) {
                    stringBuffer.append(string).append(" IS NOT ").append(string2);
                } else {
                    stringBuffer.append(string).append("!=").append(string2);
                }
                return stringBuffer.toString();
            }
            case 49: {
                stringBuffer.append(string).append(' ').append("AND").append(' ').append(string2);
                return stringBuffer.toString();
            }
            case 50: {
                stringBuffer.append(string).append(' ').append("OR").append(' ').append(string2);
                return stringBuffer.toString();
            }
            case 54: {
                stringBuffer.append(string).append(' ').append("IN").append(' ').append(string2);
                return stringBuffer.toString();
            }
            case 59: {
                stringBuffer.append(string).append(' ').append("MATCH").append(' ').append(string2);
                return stringBuffer.toString();
            }
            case 60: {
                stringBuffer.append(string).append(' ').append("MATCH").append(' ').append(469).append(string2);
                return stringBuffer.toString();
            }
            case 61: {
                stringBuffer.append(string).append(' ').append("MATCH").append(' ').append(115).append(string2);
                return stringBuffer.toString();
            }
            case 62: {
                stringBuffer.append(string).append(' ').append("MATCH").append(' ').append(297).append(string2);
                return stringBuffer.toString();
            }
            case 63: {
                stringBuffer.append(string).append(' ').append("MATCH").append(' ').append(297).append(' ').append(469).append(string2);
                return stringBuffer.toString();
            }
            case 64: {
                stringBuffer.append(string).append(' ').append("MATCH").append(' ').append(297).append(' ').append(115).append(string2);
                return stringBuffer.toString();
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        switch (this.opType) {
            case 1: {
                stringBuffer.append("VALUE = ").append(this.valueData);
                stringBuffer.append(", TYPE = ").append(this.dataType.getNameString());
                return stringBuffer.toString();
            }
            case 48: {
                if (this.nodes[0].opType == 58) {
                    stringBuffer.append("DISTINCT");
                    return stringBuffer.toString();
                }
                stringBuffer.append("NOT ");
                break;
            }
            case 58: {
                stringBuffer.append("NOT ");
                stringBuffer.append("DISTINCT ");
                break;
            }
            case 41: {
                stringBuffer.append("EQUAL ");
                break;
            }
            case 42: {
                stringBuffer.append("GREATER_EQUAL ");
                break;
            }
            case 43: {
                stringBuffer.append("GREATER ");
                break;
            }
            case 44: {
                stringBuffer.append("SMALLER ");
                break;
            }
            case 45: {
                stringBuffer.append("SMALLER_EQUAL ");
                break;
            }
            case 46: {
                stringBuffer.append("NOT_EQUAL ");
                break;
            }
            case 49: {
                stringBuffer.append("AND ");
                break;
            }
            case 50: {
                stringBuffer.append("OR ");
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                stringBuffer.append("MATCH ");
                break;
            }
            case 47: {
                stringBuffer.append("IS_NULL ");
                break;
            }
            case 57: {
                stringBuffer.append("UNIQUE ");
                break;
            }
            case 55: {
                stringBuffer.append("EXISTS ");
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        if (this.nodes[0] != null) {
            stringBuffer.append(" arg_left=[");
            stringBuffer.append(this.nodes[0].describe(session, n + 1));
            stringBuffer.append(']');
        }
        if (this.nodes[1] != null) {
            stringBuffer.append(" arg_right=[");
            stringBuffer.append(this.nodes[1].describe(session, n + 1));
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        switch (this.opType) {
            case 1: {
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 58: {
                this.resolveTypesForComparison(session, expression);
                break;
            }
            case 49: {
                Object object;
                this.resolveTypesForLogicalOp();
                if (this.nodes[0].opType == 1) {
                    if (this.nodes[1].opType == 1) {
                        this.setAsConstantValue(session);
                        break;
                    }
                    Object object2 = this.nodes[0].getValue(session);
                    if (object2 != null && !Boolean.FALSE.equals(object2)) break;
                    this.setAsConstantValue(Boolean.FALSE);
                    break;
                }
                if (this.nodes[1].opType != 1 || (object = this.nodes[1].getValue(session)) != null && !Boolean.FALSE.equals(object)) break;
                this.setAsConstantValue(Boolean.FALSE);
                break;
            }
            case 50: {
                Object object;
                this.resolveTypesForLogicalOp();
                if (this.nodes[0].opType == 1) {
                    if (this.nodes[1].opType == 1) {
                        this.setAsConstantValue(session);
                        break;
                    }
                    Object object3 = this.nodes[0].getValue(session);
                    if (!Boolean.TRUE.equals(object3)) break;
                    this.setAsConstantValue(Boolean.TRUE);
                    break;
                }
                if (this.nodes[1].opType != 1 || !Boolean.TRUE.equals(object = this.nodes[1].getValue(session))) break;
                this.setAsConstantValue(Boolean.TRUE);
                break;
            }
            case 47: {
                if (this.nodes[0].isParam) {
                    throw Error.error(5563);
                }
                if (this.nodes[0].opType != 1) break;
                this.setAsConstantValue(session);
                break;
            }
            case 48: {
                if (this.nodes[0].isParam) {
                    this.nodes[0].dataType = Type.SQL_BOOLEAN;
                    break;
                }
                if (this.nodes[0].opType == 1) {
                    if (this.nodes[0].dataType.isBooleanType()) {
                        this.setAsConstantValue(session);
                        break;
                    }
                    throw Error.error(5563);
                }
                if (this.nodes[0].dataType == null || !this.nodes[0].dataType.isBooleanType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            case 56: {
                this.resolveTypesForOverlaps();
                break;
            }
            case 54: {
                this.resolveTypesForIn(session);
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                this.resolveTypesForAllAny(session);
                break;
            }
            case 55: 
            case 57: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
    }

    private void resolveTypesForLogicalOp() {
        if (this.nodes[0].isParam) {
            this.nodes[0].dataType = Type.SQL_BOOLEAN;
        }
        if (this.nodes[1].isParam) {
            this.nodes[1].dataType = Type.SQL_BOOLEAN;
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5571);
        }
        if (this.nodes[0].opType == 25 || this.nodes[1].opType == 25 || Type.SQL_BOOLEAN != this.nodes[0].dataType || Type.SQL_BOOLEAN != this.nodes[1].dataType) {
            throw Error.error(5564);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resolveTypesForComparison(Session session, Expression expression) {
        if (this.opType == 58 || this.exprSubType == 51 || this.exprSubType == 52) {
            this.resolveTypesForAllAny(session);
            this.checkRowComparison();
            return;
        }
        if (this.nodes[0].opType == 25 || this.nodes[1].opType == 25) {
            if (this.nodes[0].opType != 25 || this.nodes[1].opType != 25 || this.nodes[0].nodes.length != this.nodes[1].nodes.length) {
                throw Error.error(5564);
            }
            this.resolveRowTypes();
            this.checkRowComparison();
            return;
        }
        if (this.nodes[0].isParam) {
            this.nodes[0].dataType = this.nodes[1].dataType;
        } else if (this.nodes[1].isParam) {
            this.nodes[1].dataType = this.nodes[0].dataType;
        }
        if (this.nodes[0].dataType == null) {
            this.nodes[0].dataType = this.nodes[1].dataType;
        } else if (this.nodes[1].dataType == null) {
            this.nodes[1].dataType = this.nodes[0].dataType;
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5567);
        }
        if (this.nodes[0].dataType.typeComparisonGroup != this.nodes[1].dataType.typeComparisonGroup) {
            if (!this.convertDateTimeLiteral(session, this.nodes[0], this.nodes[1])) {
                if (this.nodes[0].dataType.isBitType()) {
                    if (this.nodes[1].dataType.canConvertFrom(this.nodes[0].dataType)) {
                        this.nodes[0] = ExpressionOp.getCastExpression(session, this.nodes[0], this.nodes[1].dataType);
                    }
                } else {
                    if (!this.nodes[1].dataType.isBitType()) throw Error.error(5562);
                    if (this.nodes[0].dataType.canConvertFrom(this.nodes[1].dataType)) {
                        this.nodes[1] = ExpressionOp.getCastExpression(session, this.nodes[1], this.nodes[0].dataType);
                    }
                }
            }
        } else if (this.nodes[0].dataType.isDateTimeType() && this.nodes[0].dataType.isDateTimeTypeWithZone() ^ this.nodes[1].dataType.isDateTimeTypeWithZone()) {
            this.nodes[0] = new ExpressionOp(this.nodes[0]);
        }
        if (this.opType != 41 && this.opType != 46 && (this.nodes[0].dataType.isLobType() || this.nodes[1].dataType.isLobType())) {
            throw Error.error(5534);
        }
        if (this.nodes[0].opType != 1 || this.nodes[1].opType != 1) return;
        this.setAsConstantValue(session);
    }

    private void resolveRowTypes() {
        for (int i = 0; i < this.nodes[0].nodeDataTypes.length; ++i) {
            Type type = this.nodes[0].nodeDataTypes[i];
            Type type2 = this.nodes[1].nodeDataTypes[i];
            if (type == null) {
                type = this.nodes[0].nodeDataTypes[i] = type2;
            } else if (this.nodes[1].dataType == null) {
                type2 = this.nodes[1].nodeDataTypes[i] = type;
            }
            if (type == null || type2 == null) {
                throw Error.error(5567);
            }
            if (type.typeComparisonGroup != type2.typeComparisonGroup) {
                throw Error.error(5562);
            }
            if (!type.isDateTimeType() || !(type.isDateTimeTypeWithZone() ^ type2.isDateTimeTypeWithZone())) continue;
            this.nodes[0].nodes[i] = new ExpressionOp(this.nodes[0].nodes[i]);
            this.nodes[0].nodeDataTypes[i] = this.nodes[0].nodes[i].dataType;
        }
    }

    void checkRowComparison() {
        if (this.opType == 41 || this.opType == 46) {
            return;
        }
        for (int i = 0; i < this.nodes[0].nodeDataTypes.length; ++i) {
            Type type = this.nodes[0].nodeDataTypes[i];
            Type type2 = this.nodes[1].nodeDataTypes[i];
            if (!type.isLobType() && !type2.isLobType()) continue;
            throw Error.error(5534);
        }
    }

    private boolean convertDateTimeLiteral(Session session, Expression expression, Expression expression2) {
        if (!expression.dataType.isDateTimeType()) {
            if (expression2.dataType.isDateTimeType()) {
                Expression expression3 = expression;
                expression = expression2;
                expression2 = expression3;
            } else {
                return false;
            }
        }
        if (expression.dataType.isDateTimeTypeWithZone()) {
            return false;
        }
        if (expression2.opType == 1 && expression2.dataType.isCharacterType()) {
            expression2.valueData = expression.dataType.castToType(session, expression2.valueData, expression2.dataType);
            expression2.dataType = expression.dataType;
            return true;
        }
        return false;
    }

    void resolveTypesForOverlaps() {
        if (this.nodes[0].nodes[0].isParam) {
            this.nodes[0].nodes[0].dataType = this.nodes[1].nodes[0].dataType;
        }
        if (this.nodes[1].nodes[0].isParam) {
            this.nodes[1].nodes[0].dataType = this.nodes[0].nodes[0].dataType;
        }
        if (this.nodes[0].nodes[0].dataType == null) {
            this.nodes[0].nodes[0].dataType = this.nodes[1].nodes[0].dataType = Type.SQL_TIMESTAMP;
        }
        if (this.nodes[0].nodes[1].isParam) {
            this.nodes[0].nodes[1].dataType = this.nodes[1].nodes[0].dataType;
        }
        if (this.nodes[1].nodes[1].isParam) {
            this.nodes[1].nodes[1].dataType = this.nodes[0].nodes[0].dataType;
        }
        if (!DTIType.isValidDatetimeRange(this.nodes[0].nodes[0].dataType, this.nodes[0].nodes[1].dataType) || !DTIType.isValidDatetimeRange(this.nodes[1].nodes[0].dataType, this.nodes[1].nodes[1].dataType)) {
            throw Error.error(5563);
        }
        if (!DTIType.isValidDatetimeRange(this.nodes[0].nodes[0].dataType, this.nodes[0].nodes[1].dataType)) {
            throw Error.error(5563);
        }
        this.nodes[0].nodeDataTypes[0] = this.nodes[0].nodes[0].dataType;
        this.nodes[0].nodeDataTypes[1] = this.nodes[0].nodes[1].dataType;
        this.nodes[1].nodeDataTypes[0] = this.nodes[1].nodes[0].dataType;
        this.nodes[1].nodeDataTypes[1] = this.nodes[1].nodes[1].dataType;
    }

    void resolveTypesForAllAny(Session session) {
        int n = this.nodes[0].getDegree();
        if (n == 1 && this.nodes[0].opType != 25) {
            this.nodes[0] = new Expression(25, new Expression[]{this.nodes[0]});
        }
        if (this.nodes[1].opType == 26) {
            this.nodes[1].prepareTable(session, this.nodes[0], n);
            this.nodes[1].subQuery.prepareTable(session);
            if (this.nodes[1].isCorrelated) {
                this.nodes[1].subQuery.setCorrelated();
            }
        }
        if (n != this.nodes[1].nodeDataTypes.length) {
            throw Error.error(5564);
        }
        if (this.nodes[1].opType == 26) {
            // empty if block
        }
        this.nodes[0].nodeDataTypes = new Type[this.nodes[0].nodes.length];
        for (int i = 0; i < this.nodes[0].nodeDataTypes.length; ++i) {
            Type type = this.nodes[0].nodes[i].dataType;
            if (type == null) {
                type = this.nodes[1].nodeDataTypes[i];
            }
            if (type == null) {
                throw Error.error(5567);
            }
            this.nodes[0].nodeDataTypes[i] = type;
            this.nodes[0].nodes[i].dataType = type;
        }
    }

    void resolveTypesForIn(Session session) {
        this.resolveTypesForAllAny(session);
    }

    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 5: {
                Object[] objectArray = session.sessionContext.rangeIterators[this.rangePosition].getCurrent();
                return objectArray[this.columnIndex];
            }
            case 31: {
                return ((NumberType)this.dataType).negate(this.nodes[0].getValue(session, this.nodes[0].dataType));
            }
            case 47: {
                return this.nodes[0].getValue(session) == null ? Boolean.TRUE : Boolean.FALSE;
            }
            case 56: {
                Object[] objectArray = this.nodes[0].getRowValue(session);
                Object[] objectArray2 = this.nodes[1].getRowValue(session);
                return DateTimeType.overlaps(session, objectArray, this.nodes[0].nodeDataTypes, objectArray2, this.nodes[1].nodeDataTypes);
            }
            case 54: {
                return this.testInCondition(session, this.nodes[0].getRowValue(session));
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                return this.testMatchCondition(session, this.nodes[0].getRowValue(session));
            }
            case 57: {
                this.nodes[0].subQuery.materialiseCorrelated(session);
                return this.nodes[0].subQuery.hasUniqueNotNullRows(session) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 55: {
                return this.testExistsCondition(session);
            }
            case 48: {
                Boolean bl = (Boolean)this.nodes[0].getValue(session);
                return bl == null ? null : (bl != false ? Boolean.FALSE : Boolean.TRUE);
            }
            case 49: {
                Boolean bl = (Boolean)this.nodes[0].getValue(session);
                if (Boolean.FALSE.equals(bl)) {
                    return Boolean.FALSE;
                }
                Boolean bl2 = (Boolean)this.nodes[1].getValue(session);
                if (Boolean.FALSE.equals(bl2)) {
                    return Boolean.FALSE;
                }
                if (bl == null || bl2 == null) {
                    return null;
                }
                return Boolean.TRUE;
            }
            case 50: {
                Boolean bl = (Boolean)this.nodes[0].getValue(session);
                if (Boolean.TRUE.equals(bl)) {
                    return Boolean.TRUE;
                }
                Boolean bl3 = (Boolean)this.nodes[1].getValue(session);
                if (Boolean.TRUE.equals(bl3)) {
                    return Boolean.TRUE;
                }
                if (bl == null || bl3 == null) {
                    return null;
                }
                return Boolean.FALSE;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 58: {
                if (this.exprSubType == 52 || this.exprSubType == 51) {
                    return this.testAllAnyCondition(session, this.nodes[0].getRowValue(session));
                }
                Object object = this.nodes[0].getValue(session);
                Object object2 = this.nodes[1].getValue(session);
                if (object instanceof Object[]) {
                    if (!(object2 instanceof Object[])) {
                        throw Error.runtimeError(201, "ExpressionLogical");
                    }
                    return this.compareValues(session, (Object[])object, (Object[])object2);
                }
                if (object2 instanceof Object[]) {
                    object2 = ((Object[])object2)[0];
                }
                return this.compareValues(session, object, object2);
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean compareValues(Session session, Object object, Object object2) {
        int n = 0;
        if (object == null || object2 == null) {
            return null;
        }
        n = this.nodes[0].dataType.compare(session, object, object2);
        switch (this.opType) {
            case 41: {
                return n == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 46: {
                return n != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 43: {
                return n > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 42: {
                return n >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 45: {
                return n <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 44: {
                return n < 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean compareValues(Session session, Object[] objectArray, Object[] objectArray2) {
        int n = 0;
        boolean bl = false;
        if (objectArray == null || objectArray2 == null) {
            return null;
        }
        Object[] objectArray3 = objectArray;
        Object[] objectArray4 = objectArray2;
        for (int i = 0; i < this.nodes[0].nodes.length; ++i) {
            Object object;
            Object object2;
            Type[] typeArray;
            if (objectArray3[i] == null) {
                if (this.opType == 60 || this.opType == 63) continue;
                bl = true;
            }
            if (objectArray4[i] == null) {
                bl = true;
            }
            if ((n = (typeArray = this.nodes[0].nodeDataTypes)[i].compare(session, object2 = objectArray3[i], object = objectArray4[i])) != 0) break;
        }
        switch (this.opType) {
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                return n == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 41: 
            case 54: {
                if (bl) {
                    return null;
                }
                return n == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 46: {
                if (bl) {
                    return null;
                }
                return n != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 43: {
                if (bl) {
                    return null;
                }
                return n > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 42: {
                if (bl) {
                    return null;
                }
                return n >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 45: {
                if (bl) {
                    return null;
                }
                return n <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 44: {
                if (bl) {
                    return null;
                }
                return n < 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean testInCondition(Session session, Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        if (Expression.countNulls(objectArray) != 0) {
            return null;
        }
        if (this.nodes[1].opType == 26) {
            int n = this.nodes[1].nodes.length;
            for (int i = 0; i < n; ++i) {
                Object[] objectArray2 = this.nodes[1].nodes[i].getRowValue(session);
                if (!Boolean.TRUE.equals(this.compareValues(session, objectArray, objectArray2))) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean testMatchCondition(Session session, Object[] objectArray) {
        if (objectArray == null) {
            return Boolean.TRUE;
        }
        int n = ExpressionLogical.countNulls(objectArray);
        if (n != 0) {
            switch (this.opType) {
                case 59: 
                case 62: {
                    return Boolean.TRUE;
                }
                case 60: 
                case 63: {
                    if (n != objectArray.length) break;
                    return Boolean.TRUE;
                }
                case 61: 
                case 64: {
                    return n == objectArray.length ? Boolean.TRUE : Boolean.FALSE;
                }
            }
        }
        if (this.nodes[1].opType == 26) {
            int n2 = this.nodes[1].nodes.length;
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                Object[] objectArray2 = this.nodes[1].nodes[i].getRowValue(session);
                Boolean bl2 = this.compareValues(session, objectArray, objectArray2);
                if (bl2 == null || !bl2.booleanValue()) continue;
                switch (this.opType) {
                    case 59: 
                    case 60: 
                    case 61: {
                        return Boolean.TRUE;
                    }
                    case 62: 
                    case 63: 
                    case 64: {
                        if (bl) {
                            return Boolean.FALSE;
                        }
                        bl = true;
                    }
                }
            }
            return bl ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.nodes[1].opType == 23) {
            PersistentStore persistentStore = session.sessionData.getRowStore(this.nodes[1].subQuery.getTable());
            this.nodes[1].subQuery.materialiseCorrelated(session);
            ExpressionLogical.convertToType(session, objectArray, this.nodes[0].nodeDataTypes, this.nodes[1].nodeDataTypes);
            if (n != 0 && (this.opType == 60 || this.opType == 63)) {
                boolean bl = false;
                RowIterator rowIterator = this.nodes[1].subQuery.getTable().rowIterator(session);
                while (rowIterator.hasNext()) {
                    Object[] objectArray3 = rowIterator.getNextRow().getData();
                    Boolean bl3 = this.compareValues(session, objectArray, objectArray3);
                    if (bl3 == null || !bl3.booleanValue()) continue;
                    if (this.opType == 60) {
                        return Boolean.TRUE;
                    }
                    if (bl) {
                        return Boolean.FALSE;
                    }
                    bl = true;
                }
                return bl ? Boolean.TRUE : Boolean.FALSE;
            }
            RowIterator rowIterator = this.nodes[1].subQuery.getTable().getPrimaryIndex().findFirstRow(session, persistentStore, objectArray);
            boolean bl = rowIterator.hasNext();
            if (!bl) {
                return Boolean.FALSE;
            }
            switch (this.opType) {
                case 59: 
                case 60: 
                case 61: {
                    return Boolean.TRUE;
                }
            }
            rowIterator.getNextRow();
            bl = rowIterator.hasNext();
            if (!bl) {
                return Boolean.TRUE;
            }
            Object[] objectArray4 = rowIterator.getNextRow().getData();
            Boolean bl4 = Boolean.TRUE.equals(this.compareValues(session, objectArray, objectArray4)) ? Boolean.FALSE : Boolean.TRUE;
            return bl4;
        }
        throw Error.error(5564);
    }

    private Boolean testExistsCondition(Session session) {
        SubQuery subQuery = this.nodes[0].subQuery;
        if (subQuery.isCorrelated()) {
            subQuery.materialiseCorrelated(session);
        }
        return subQuery.getTable().isEmpty(session) ? Boolean.FALSE : Boolean.TRUE;
    }

    private Boolean testAllAnyCondition(Session session, Object[] objectArray) {
        SubQuery subQuery = this.nodes[1].subQuery;
        subQuery.materialiseCorrelated(session);
        Boolean bl = this.getAllAnyValue(session, objectArray, subQuery);
        return bl;
    }

    private Boolean getAllAnyValue(Session session, Object[] objectArray, SubQuery subQuery) {
        TableDerived tableDerived = subQuery.getTable();
        boolean bl = tableDerived.isEmpty(session);
        Index index = tableDerived.getFullIndex();
        PersistentStore persistentStore = session.sessionData.getRowStore(tableDerived);
        Row row = index.lastRow(session, persistentStore);
        switch (this.exprSubType) {
            case 52: {
                if (bl) {
                    return Boolean.FALSE;
                }
                if (ExpressionLogical.countNulls(objectArray) == objectArray.length) {
                    return null;
                }
                Object[] objectArray2 = row.getData();
                if (ExpressionLogical.countNulls(objectArray2) == objectArray.length) {
                    return null;
                }
                ExpressionLogical.convertToType(session, objectArray, this.nodes[0].nodeDataTypes, this.nodes[1].nodeDataTypes);
                if (this.opType == 41) {
                    RowIterator rowIterator = index.findFirstRow(session, persistentStore, objectArray);
                    return rowIterator.hasNext() ? Boolean.TRUE : Boolean.FALSE;
                }
                RowIterator rowIterator = index.findFirstRowNotNull(session, persistentStore);
                Row row2 = rowIterator.getNextRow();
                Object[] objectArray3 = row2.getData();
                Boolean bl2 = this.compareValues(session, objectArray, objectArray3);
                Boolean bl3 = this.compareValues(session, objectArray, objectArray2);
                switch (this.opType) {
                    case 46: {
                        return Boolean.TRUE.equals(bl2) || Boolean.TRUE.equals(bl3) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 43: {
                        return bl2;
                    }
                    case 42: {
                        return bl2;
                    }
                    case 44: {
                        return bl3;
                    }
                    case 45: {
                        return bl3;
                    }
                }
                break;
            }
            case 51: {
                if (bl) {
                    return Boolean.TRUE;
                }
                if (ExpressionLogical.countNulls(objectArray) == objectArray.length) {
                    return null;
                }
                RowIterator rowIterator = index.firstRow(session, persistentStore);
                Row row3 = rowIterator.getNextRow();
                Object[] objectArray4 = row3.getData();
                if (ExpressionLogical.countNulls(objectArray4) == objectArray.length) {
                    return null;
                }
                ExpressionLogical.convertToType(session, objectArray, this.nodes[0].nodeDataTypes, this.nodes[1].nodeDataTypes);
                rowIterator = index.findFirstRow(session, persistentStore, objectArray);
                if (this.opType == 41) {
                    if (rowIterator.hasNext()) {
                        return subQuery.getTable().getRowCount(persistentStore) == 1 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    return Boolean.FALSE;
                }
                if (this.opType == 46) {
                    return rowIterator.hasNext() ? Boolean.FALSE : Boolean.TRUE;
                }
                Object[] objectArray5 = row.getData();
                Boolean bl4 = this.compareValues(session, objectArray, objectArray4);
                Boolean bl5 = this.compareValues(session, objectArray, objectArray5);
                switch (this.opType) {
                    case 43: {
                        return bl5;
                    }
                    case 42: {
                        return bl5;
                    }
                    case 44: {
                        return bl4;
                    }
                    case 45: {
                        return bl4;
                    }
                }
                break;
            }
        }
        return null;
    }

    void distributeOr() {
        if (this.opType != 50) {
            return;
        }
        if (this.nodes[0].opType == 49) {
            this.opType = 49;
            ExpressionLogical expressionLogical = new ExpressionLogical(50, this.nodes[0].nodes[1], this.nodes[1]);
            this.nodes[0].opType = 50;
            this.nodes[0].nodes[1] = this.nodes[1];
            this.nodes[1] = expressionLogical;
        } else if (this.nodes[1].opType == 49) {
            Expression expression = this.nodes[0];
            this.nodes[0] = this.nodes[1];
            this.nodes[1] = expression;
            this.distributeOr();
            return;
        }
        ((ExpressionLogical)this.nodes[0]).distributeOr();
        ((ExpressionLogical)this.nodes[1]).distributeOr();
    }

    @Override
    public boolean isIndexable(RangeVariable rangeVariable) {
        switch (this.opType) {
            case 49: {
                boolean bl = this.nodes[0].isIndexable(rangeVariable) || this.nodes[1].isIndexable(rangeVariable);
                return bl;
            }
            case 50: {
                boolean bl = this.nodes[0].isIndexable(rangeVariable) && this.nodes[1].isIndexable(rangeVariable);
                return bl;
            }
        }
        Expression expression = this.getIndexableExpression(rangeVariable);
        return expression != null;
    }

    @Override
    Expression getIndexableExpression(RangeVariable rangeVariable) {
        switch (this.opType) {
            case 47: {
                return this.nodes[0].opType == 2 && this.nodes[0].isIndexable(rangeVariable) ? this : null;
            }
            case 48: {
                return this.nodes[0].opType == 47 && this.nodes[0].nodes[0].opType == 2 && this.nodes[0].nodes[0].isIndexable(rangeVariable) ? this : null;
            }
            case 41: {
                if (this.exprSubType == 52) {
                    if (this.nodes[1].isCorrelated) {
                        return null;
                    }
                    for (int i = 0; i < this.nodes[0].nodes.length; ++i) {
                        if (this.nodes[0].nodes[i].opType != 2 || !this.nodes[0].nodes[i].isIndexable(rangeVariable)) continue;
                        return this;
                    }
                    return null;
                }
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                if (this.exprSubType != 0) {
                    return null;
                }
                if (this.nodes[0].opType == 2 && this.nodes[0].isIndexable(rangeVariable)) {
                    if (this.nodes[1].hasReference(rangeVariable)) {
                        return null;
                    }
                    return this;
                }
                if (this.nodes[0].hasReference(rangeVariable)) {
                    return null;
                }
                if (this.nodes[1].opType == 2 && this.nodes[1].isIndexable(rangeVariable)) {
                    this.swapCondition();
                    return this;
                }
                return null;
            }
            case 50: {
                if (this.isIndexable(rangeVariable)) {
                    return this;
                }
                return null;
            }
        }
        return null;
    }

    boolean isSimpleBound() {
        if (this.opType == 47) {
            return true;
        }
        if (this.nodes[1] != null) {
            if (this.nodes[1].opType == 1) {
                return true;
            }
            if (this.nodes[1].opType == 28 && ((FunctionSQL)this.nodes[1]).isValueFunction()) {
                return true;
            }
        }
        return false;
    }

    boolean convertToSmaller() {
        switch (this.opType) {
            case 42: 
            case 43: {
                this.swapCondition();
                return true;
            }
            case 44: 
            case 45: {
                return true;
            }
        }
        return false;
    }

    void swapCondition() {
        int n = 41;
        switch (this.opType) {
            case 42: {
                n = 45;
                break;
            }
            case 45: {
                n = 42;
                break;
            }
            case 44: {
                n = 43;
                break;
            }
            case 43: {
                n = 44;
                break;
            }
            case 58: {
                n = 58;
                break;
            }
            case 41: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        this.opType = n;
        Expression expression = this.nodes[0];
        this.nodes[0] = this.nodes[1];
        this.nodes[1] = expression;
    }

    boolean reorderComparison(Session session) {
        Expression expression = null;
        Expression expression2 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (this.nodes[0].opType == 32) {
            n = 33;
            bl = true;
        } else if (this.nodes[0].opType == 33) {
            n = 32;
            bl = true;
        } else if (this.nodes[1].opType == 32) {
            n = 33;
        } else if (this.nodes[1].opType == 33) {
            n = 32;
        }
        if (n == 0) {
            return false;
        }
        if (bl) {
            if (this.nodes[0].nodes[0].opType == 2) {
                expression = this.nodes[0].nodes[0];
                expression2 = this.nodes[0].nodes[1];
            } else if (this.nodes[0].nodes[1].opType == 2) {
                bl2 = n == 32;
                expression = this.nodes[0].nodes[1];
                expression2 = this.nodes[0].nodes[0];
            }
        } else if (this.nodes[1].nodes[0].opType == 2) {
            expression = this.nodes[1].nodes[0];
            expression2 = this.nodes[1].nodes[1];
        } else if (this.nodes[1].nodes[1].opType == 2) {
            bl2 = n == 32;
            expression = this.nodes[1].nodes[1];
            expression2 = this.nodes[1].nodes[0];
        }
        if (expression == null) {
            return false;
        }
        Expression expression3 = bl ? this.nodes[1] : this.nodes[0];
        ExpressionArithmetic expressionArithmetic = null;
        if (!bl2) {
            expressionArithmetic = new ExpressionArithmetic(n, expression3, expression2);
            expressionArithmetic.resolveTypesForArithmetic(session);
        }
        if (bl) {
            if (bl2) {
                this.nodes[1] = expression;
                this.nodes[0].nodes[1] = expression3;
                ((ExpressionArithmetic)this.nodes[0]).resolveTypesForArithmetic(session);
            } else {
                this.nodes[0] = expression;
                this.nodes[1] = expressionArithmetic;
            }
        } else if (bl2) {
            this.nodes[0] = expression;
            this.nodes[1].nodes[1] = expression3;
            ((ExpressionArithmetic)this.nodes[1]).resolveTypesForArithmetic(session);
        } else {
            this.nodes[1] = expression;
            this.nodes[0] = expressionArithmetic;
        }
        return true;
    }
}

