/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.Session;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.Crypto;
import org.hsqldb.store.BitMap;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class FunctionCustom
extends FunctionSQL {
    public static final String[] openGroupNumericFunctions = new String[]{"ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "BITAND", "BITOR", "BITXOR", "CEILING", "COS", "COT", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "MOD", "PI", "POWER", "RADIANS", "RAND", "ROUND", "ROUNDMAGIC", "SIGN", "SIN", "SQRT", "TAN", "TRUNCATE"};
    public static final String[] openGroupStringFunctions = new String[]{"ASCII", "CHAR", "CONCAT", "DIFFERENCE", "HEXTORAW", "INSERT", "LCASE", "LEFT", "LENGTH", "LOCATE", "LTRIM", "RAWTOHEX", "REPEAT", "REPLACE", "RIGHT", "RTRIM", "SOUNDEX", "SPACE", "SUBSTR", "UCASE"};
    public static final String[] openGroupDateTimeFunctions = new String[]{"CURDATE", "CURTIME", "DATEDIFF", "DAYNAME", "DAYOFMONTH", "DAYOFWEEK", "DAYOFYEAR", "HOUR", "MINUTE", "MONTH", "MONTHNAME", "NOW", "QUARTER", "SECOND", "SECONDS_SINCE_MIDNIGHT", "TIMESTAMPADD", "TIMESTAMPDIFF", "TO_CHAR", "WEEK", "YEAR"};
    public static final String[] openGroupSystemFunctions = new String[]{"DATABASE", "IFNULL", "USER"};
    private static final int FUNC_ISAUTOCOMMIT = 71;
    private static final int FUNC_ISREADONLYSESSION = 72;
    private static final int FUNC_ISREADONLYDATABASE = 73;
    private static final int FUNC_ISREADONLYDATABASEFILES = 74;
    private static final int FUNC_DATABASE = 75;
    private static final int FUNC_IDENTITY = 76;
    private static final int FUNC_SYSDATE = 77;
    private static final int FUNC_TIMESTAMPADD = 78;
    private static final int FUNC_TIMESTAMPDIFF = 79;
    private static final int FUNC_TRUNCATE = 80;
    private static final int FUNC_TO_CHAR = 81;
    private static final int FUNC_TIMESTAMP = 82;
    private static final int FUNC_CRYPT_KEY = 83;
    private static final int FUNC_ISOLATION_LEVEL = 85;
    private static final int FUNC_SESSION_ISOLATION_LEVEL = 86;
    private static final int FUNC_DATABASE_ISOLATION_LEVEL = 87;
    private static final int FUNC_TRANSACTION_CONTROL = 88;
    private static final int FUNC_TIMEZONE = 89;
    private static final int FUNC_SESSION_TIMEZONE = 90;
    private static final int FUNC_DATABASE_TIMEZONE = 91;
    private static final int FUNC_DATABASE_VERSION = 92;
    private static final int FUNC_ACOS = 101;
    private static final int FUNC_ASIN = 102;
    private static final int FUNC_ATAN = 103;
    private static final int FUNC_ATAN2 = 104;
    private static final int FUNC_COS = 105;
    private static final int FUNC_COT = 106;
    private static final int FUNC_DEGREES = 107;
    private static final int FUNC_LOG10 = 110;
    private static final int FUNC_PI = 111;
    private static final int FUNC_RADIANS = 112;
    private static final int FUNC_RAND = 113;
    private static final int FUNC_ROUND = 114;
    private static final int FUNC_SIGN = 115;
    private static final int FUNC_SIN = 116;
    private static final int FUNC_TAN = 117;
    private static final int FUNC_BITAND = 118;
    private static final int FUNC_BITOR = 119;
    private static final int FUNC_BITXOR = 120;
    private static final int FUNC_ROUNDMAGIC = 121;
    private static final int FUNC_ASCII = 122;
    private static final int FUNC_CHAR = 123;
    private static final int FUNC_CONCAT = 124;
    private static final int FUNC_DIFFERENCE = 125;
    private static final int FUNC_HEXTORAW = 126;
    private static final int FUNC_LEFT = 128;
    private static final int FUNC_LOCATE = 130;
    private static final int FUNC_LTRIM = 131;
    private static final int FUNC_RAWTOHEX = 132;
    private static final int FUNC_REPEAT = 133;
    private static final int FUNC_REPLACE = 134;
    private static final int FUNC_REVERSE = 135;
    private static final int FUNC_RIGHT = 136;
    private static final int FUNC_RTRIM = 137;
    private static final int FUNC_SOUNDEX = 138;
    private static final int FUNC_SPACE = 139;
    private static final int FUNC_SUBSTR = 140;
    private static final int FUNC_DATEADD = 141;
    private static final int FUNC_DATEDIFF = 142;
    private static final int FUNC_SECONDS_MIDNIGHT = 143;
    private static final int FUNC_REGEXP_MATCHES = 144;
    static final IntKeyIntValueHashMap customRegularFuncMap = new IntKeyIntValueHashMap();
    static final IntKeyIntValueHashMap customValueFuncMap;
    private int extractSpec;
    private String matchPattern;
    private Pattern pattern;

    public static FunctionSQL newCustomFunction(String string, int n) {
        int n2 = customRegularFuncMap.get(n, -1);
        if (n2 == -1) {
            n2 = customValueFuncMap.get(n, -1);
        }
        if (n2 == -1) {
            return null;
        }
        switch (n) {
            case 431: 
            case 608: 
            case 637: 
            case 641: 
            case 651: 
            case 669: 
            case 674: 
            case 676: {
                return new FunctionSQL(n2);
            }
            case 650: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = optionalNoParamList;
                return functionSQL;
            }
            case 615: 
            case 616: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = emptyParamList;
                return functionSQL;
            }
            case 668: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = tripleParamList;
                return functionSQL;
            }
            case 639: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = new short[]{795, 797, 784, 797, 842, 2, 784, 797, 782};
                return functionSQL;
            }
        }
        FunctionCustom functionCustom = new FunctionCustom(n2);
        if (n2 == 29) {
            switch (n) {
                case 643: {
                    functionCustom.extractSpec = 149;
                    break;
                }
                case 662: {
                    functionCustom.extractSpec = 284;
                }
            }
        }
        if (n2 == 5) {
            switch (n) {
                case 623: {
                    functionCustom.extractSpec = 619;
                    break;
                }
                case 646: {
                    functionCustom.extractSpec = 645;
                    break;
                }
                case 624: {
                    functionCustom.extractSpec = 620;
                    break;
                }
                case 625: {
                    functionCustom.extractSpec = 621;
                    break;
                }
                case 626: {
                    functionCustom.extractSpec = 622;
                    break;
                }
                default: {
                    functionCustom.extractSpec = n;
                }
            }
        }
        if (functionCustom.name == null) {
            functionCustom.name = string;
        }
        return functionCustom;
    }

    public static boolean isRegularFunction(int n) {
        return customRegularFuncMap.get(n, -1) != -1;
    }

    public static boolean isValueFunction(int n) {
        return customValueFuncMap.get(n, -1) != -1;
    }

    private FunctionCustom(int n) {
        this.funcType = n;
        this.isDeterministic = !nonDeterministicFuncSet.contains(n);
        switch (n) {
            case 124: 
            case 128: {
                this.parseList = doubleParamList;
                break;
            }
            case 75: {
                this.parseList = emptyParamList;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                this.parseList = emptyParamList;
                break;
            }
            case 5: {
                this.name = "EXTRACT";
                this.parseList = singleParamList;
                break;
            }
            case 29: {
                this.name = "TRIM";
                this.parseList = singleParamList;
                break;
            }
            case 30: {
                this.name = "OVERLAY";
                this.parseList = quadParamList;
                break;
            }
            case 76: {
                this.name = "IDENTITY";
                this.parseList = emptyParamList;
                break;
            }
            case 78: {
                this.name = "TIMESTAMPADD";
                this.parseList = new short[]{795, 841, 9, 831, 832, 833, 834, 835, 836, 837, 838, 839, 784, 797, 784, 797, 782};
                break;
            }
            case 79: {
                this.name = "TIMESTAMPDIFF";
                this.parseList = new short[]{795, 841, 9, 831, 832, 833, 834, 835, 836, 837, 838, 839, 784, 797, 784, 797, 782};
                break;
            }
            case 80: {
                this.parseList = doubleParamList;
                break;
            }
            case 81: {
                this.parseList = doubleParamList;
                break;
            }
            case 82: {
                this.name = "TIMESTAMP";
                this.parseList = new short[]{795, 797, 842, 2, 784, 797, 782};
                break;
            }
            case 111: {
                this.parseList = emptyParamList;
                break;
            }
            case 113: {
                this.parseList = optionalSingleParamList;
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 121: 
            case 122: 
            case 123: 
            case 126: 
            case 132: 
            case 135: 
            case 138: 
            case 139: {
                this.parseList = singleParamList;
                break;
            }
            case 104: 
            case 114: 
            case 118: 
            case 119: 
            case 120: 
            case 125: 
            case 133: 
            case 136: 
            case 144: {
                this.parseList = doubleParamList;
                break;
            }
            case 83: {
                this.parseList = doubleParamList;
                break;
            }
            case 134: 
            case 141: 
            case 142: {
                this.parseList = tripleParamList;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public void setArguments(Expression[] expressionArray) {
        switch (this.funcType) {
            case 30: {
                Expression expression = expressionArray[1];
                Expression expression2 = expressionArray[2];
                expressionArray[1] = expressionArray[3];
                expressionArray[2] = expression;
                expressionArray[3] = expression2;
                break;
            }
            case 5: {
                Expression[] expressionArray2 = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), expressionArray[0]};
                expressionArray = expressionArray2;
                break;
            }
            case 29: {
                Expression[] expressionArray3 = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), new ExpressionValue(" ", Type.SQL_CHAR), expressionArray[0]};
                expressionArray = expressionArray3;
            }
        }
        super.setArguments(expressionArray);
    }

    @Override
    public Expression getFunctionExpression() {
        switch (this.funcType) {
            case 124: {
                return new ExpressionArithmetic(36, this.nodes[0], this.nodes[1]);
            }
        }
        return super.getFunctionExpression();
    }

    @Override
    Object getValue(Session session, Object[] objectArray) {
        switch (this.funcType) {
            case 5: 
            case 29: 
            case 30: {
                return super.getValue(session, objectArray);
            }
            case 75: {
                return session.getDatabase().getPath();
            }
            case 71: {
                return session.isAutoCommit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 72: {
                return session.isReadOnlyDefault() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 73: {
                return session.getDatabase().databaseReadOnly ? Boolean.TRUE : Boolean.FALSE;
            }
            case 74: {
                return session.getDatabase().isFilesReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 85: {
                return Session.getIsolationString(session.isolationLevel);
            }
            case 86: {
                return Session.getIsolationString(session.isolationLevelDefault);
            }
            case 87: {
                return Session.getIsolationString(session.database.getDefaultIsolationLevel());
            }
            case 88: {
                switch (session.database.txManager.getTransactionControl()) {
                    case 2: {
                        return "MVCC";
                    }
                    case 1: {
                        return "MVLOCKS";
                    }
                }
                return "LOCKS";
            }
            case 89: {
                return new IntervalSecondData(session.getZoneSeconds(), 0);
            }
            case 90: {
                return new IntervalSecondData(session.sessionTimeZoneSeconds, 0);
            }
            case 91: {
                int n = HsqlDateTime.getZoneSeconds(HsqlDateTime.tempCalDefault);
                return new IntervalSecondData(n, 0);
            }
            case 92: {
                return "2.0.0";
            }
            case 76: {
                Number number = session.getLastIdentity();
                if (number instanceof Long) {
                    return number;
                }
                return ValuePool.getLong(number.longValue());
            }
            case 78: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                objectArray[1] = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                int n = ((Number)this.nodes[0].valueData).intValue();
                long l = ((Number)objectArray[1]).longValue();
                TimestampData timestampData = (TimestampData)objectArray[2];
                switch (n) {
                    case 831: {
                        long l2 = l / 1000000000L;
                        int n2 = (int)(l % 1000000000L);
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l2, n2, intervalType);
                        return this.dataType.add(timestampData, intervalSecondData, intervalType);
                    }
                    case 832: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalSeconds(l, intervalType);
                        return this.dataType.add(timestampData, intervalSecondData, intervalType);
                    }
                    case 833: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalMinute(l, intervalType);
                        return this.dataType.add(timestampData, intervalSecondData, intervalType);
                    }
                    case 834: {
                        IntervalType intervalType = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalHour(l, intervalType);
                        return this.dataType.add(timestampData, intervalSecondData, intervalType);
                    }
                    case 835: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalDay(l, intervalType);
                        return this.dataType.add(timestampData, intervalSecondData, intervalType);
                    }
                    case 836: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalDay(l * 7L, intervalType);
                        return this.dataType.add(timestampData, intervalSecondData, intervalType);
                    }
                    case 837: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l, intervalType);
                        return this.dataType.add(timestampData, intervalMonthData, intervalType);
                    }
                    case 838: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l * 3L, intervalType);
                        return this.dataType.add(timestampData, intervalMonthData, intervalType);
                    }
                    case 839: {
                        IntervalType intervalType = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l * 12L, intervalType);
                        return this.dataType.add(timestampData, intervalMonthData, intervalType);
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 79: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                int n = ((Number)this.nodes[0].valueData).intValue();
                TimestampData timestampData = (TimestampData)objectArray[2];
                TimestampData timestampData2 = (TimestampData)objectArray[1];
                if (this.nodes[2].dataType.isDateTimeTypeWithZone()) {
                    timestampData = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, timestampData, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                if (this.nodes[1].dataType.isDateTimeTypeWithZone()) {
                    timestampData2 = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, timestampData2, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                switch (n) {
                    case 831: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(timestampData, timestampData2, null);
                        return new Long(1000000000L * intervalSecondData.getSeconds() + (long)intervalSecondData.getNanos());
                    }
                    case 832: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        return new Long(intervalType.convertToLong(intervalType.subtract(timestampData, timestampData2, null)));
                    }
                    case 833: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        return new Long(intervalType.convertToLong(intervalType.subtract(timestampData, timestampData2, null)));
                    }
                    case 834: {
                        IntervalType intervalType = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        return new Long(intervalType.convertToLong(intervalType.subtract(timestampData, timestampData2, null)));
                    }
                    case 835: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(intervalType.convertToLong(intervalType.subtract(timestampData, timestampData2, null)));
                    }
                    case 836: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(intervalType.convertToLong(intervalType.subtract(timestampData, timestampData2, null)) / 7L);
                    }
                    case 837: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(intervalType.convertToLong(intervalType.subtract(timestampData, timestampData2, null)));
                    }
                    case 838: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(intervalType.convertToLong(intervalType.subtract(timestampData, timestampData2, null)) / 3L);
                    }
                    case 839: {
                        IntervalType intervalType = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        return new Long(intervalType.convertToLong(intervalType.subtract(timestampData, timestampData2, null)));
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 143: {
                if (objectArray[0] == null) {
                    return null;
                }
            }
            case 80: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                objectArray[1] = Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                return ((NumberType)this.dataType).truncate(objectArray[0], ((Number)objectArray[1]).intValue());
            }
            case 81: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                SimpleDateFormat simpleDateFormat = session.getSimpleDateFormatGMT();
                String string = HsqlDateTime.toJavaDatePattern((String)objectArray[1]);
                try {
                    simpleDateFormat.applyPattern(string);
                }
                catch (Exception exception) {
                    throw Error.error(3472);
                }
                Date date = (Date)((DateTimeType)this.nodes[0].dataType).convertSQLToJavaGMT(session, objectArray[0]);
                return simpleDateFormat.format(date);
            }
            case 82: {
                boolean bl;
                boolean bl2 = bl = this.nodes[1] == null;
                if (objectArray[0] == null) {
                    return null;
                }
                if (bl) {
                    return Type.SQL_TIMESTAMP.convertToType(session, objectArray[0], this.nodes[0].dataType);
                }
                if (objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)Type.SQL_DATE.convertToType(session, objectArray[0], this.nodes[0].dataType);
                TimeData timeData = (TimeData)Type.SQL_TIME.convertToType(session, objectArray[1], this.nodes[1].dataType);
                return new TimestampData(timestampData.getSeconds() + (long)timeData.getSeconds(), timeData.getNanos());
            }
            case 111: {
                return new Double(Math.PI);
            }
            case 113: {
                if (this.nodes[0] == null) {
                    return new Double(session.random());
                }
                objectArray[0] = Type.SQL_BIGINT.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                long l = ((Number)objectArray[0]).longValue();
                return new Double(session.random(l));
            }
            case 101: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.acos(d));
            }
            case 102: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.asin(d));
            }
            case 103: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.atan(d));
            }
            case 105: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.cos(d));
            }
            case 106: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                double d2 = 1.0 / Math.tan(d);
                return new Double(d2);
            }
            case 107: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.toDegrees(d));
            }
            case 116: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.sin(d));
            }
            case 117: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.tan(d));
            }
            case 110: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.log10(d));
            }
            case 112: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.toRadians(d));
            }
            case 115: {
                if (objectArray[0] == null) {
                    return null;
                }
                int n = ((NumberType)this.nodes[0].dataType).compareToZero(objectArray[0]);
                return ValuePool.getInt(n);
            }
            case 104: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                double d3 = NumberType.toDouble(objectArray[1]);
                return new Double(Math.atan2(d, d3));
            }
            case 122: {
                if (objectArray[0] == null) {
                    return null;
                }
                String string = this.nodes[0].dataType.isLobType() ? ((ClobData)objectArray[0]).getSubString(session, 0L, 1) : (String)objectArray[0];
                if (string.length() == 0) {
                    return null;
                }
                return ValuePool.getInt(string.charAt(0));
            }
            case 123: {
                if (objectArray[0] == null) {
                    return null;
                }
                objectArray[0] = Type.SQL_INTEGER.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                int n = ((Number)objectArray[0]).intValue();
                if (Character.isValidCodePoint(n) && Character.isValidCodePoint((char)n)) {
                    return String.valueOf((char)n);
                }
                throw Error.error(3472);
            }
            case 114: 
            case 121: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                int n = ((Number)objectArray[1]).intValue();
                double d4 = Math.pow(10.0, n);
                return new Double((double)Math.round(d * d4) / d4);
            }
            case 138: {
                if (objectArray[0] == null) {
                    return null;
                }
                String string = (String)objectArray[0];
                return new String(FunctionCustom.soundex(string), 0, 4);
            }
            case 118: 
            case 119: 
            case 120: {
                byte[] byArray;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                if (this.nodes[0].dataType.isIntegralType()) {
                    objectArray[0] = Type.SQL_BIGINT.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                    objectArray[1] = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                    long l = 0L;
                    long l3 = ((Number)objectArray[0]).longValue();
                    long l4 = ((Number)objectArray[1]).longValue();
                    switch (this.funcType) {
                        case 118: {
                            l = l3 & l4;
                            break;
                        }
                        case 119: {
                            l = l3 | l4;
                            break;
                        }
                        case 120: {
                            l = l3 ^ l4;
                        }
                    }
                    switch (this.dataType.typeCode) {
                        case 2: 
                        case 3: {
                            return BigDecimal.valueOf(l);
                        }
                        case 25: {
                            return ValuePool.getLong(l);
                        }
                        case 4: {
                            return ValuePool.getInt((int)l);
                        }
                        case 5: {
                            return ValuePool.getInt((int)l & 0xFFFF);
                        }
                        case -6: {
                            return ValuePool.getInt((int)l & 0xFF);
                        }
                    }
                    throw Error.error(5561);
                }
                byte[] byArray2 = ((BinaryData)objectArray[0]).getBytes();
                byte[] byArray3 = ((BinaryData)objectArray[1]).getBytes();
                switch (this.funcType) {
                    case 118: {
                        byArray = BitMap.and(byArray2, byArray3);
                        break;
                    }
                    case 119: {
                        byArray = BitMap.or(byArray2, byArray3);
                        break;
                    }
                    case 120: {
                        byArray = BitMap.xor(byArray2, byArray3);
                        break;
                    }
                    default: {
                        throw Error.error(5561);
                    }
                }
                return new BinaryData(byArray, this.dataType.precision);
            }
            case 125: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                char[] cArray = FunctionCustom.soundex((String)objectArray[0]);
                char[] cArray2 = FunctionCustom.soundex((String)objectArray[1]);
                int n = 0;
                if (cArray[0] == cArray2[0]) {
                    ++n;
                }
                if (n == 4) {
                    return ValuePool.getInt(n);
                }
                int n3 = 1;
                for (int i = 1; i < 4; ++i) {
                    for (int j = n3; j < 4; ++j) {
                        if (cArray[j] != cArray2[i]) continue;
                        ++n;
                        ++i;
                        ++n3;
                    }
                }
                n = 0;
                return ValuePool.getInt(n);
            }
            case 126: {
                if (objectArray[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
            }
            case 132: {
                if (objectArray[0] == null) {
                    return null;
                }
                return this.nodes[0].dataType.convertToString(objectArray[0]);
            }
            case 133: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                objectArray[1] = Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                String string = (String)objectArray[0];
                int n = ((Number)objectArray[1]).intValue();
                StringBuffer stringBuffer = new StringBuffer(string.length() * n);
                while (n-- > 0) {
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }
            case 134: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                String string = (String)objectArray[0];
                String string2 = (String)objectArray[1];
                String string3 = (String)objectArray[2];
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (true) {
                    int n4;
                    if ((n4 = string.indexOf(string2, n)) == -1) break;
                    stringBuffer.append(string.substring(n, n4));
                    stringBuffer.append(string3);
                    n = n4 + string2.length();
                }
                stringBuffer.append(string.substring(n));
                return stringBuffer.toString();
            }
            case 128: 
            case 136: {
                int n;
                for (n = 0; n < objectArray.length; ++n) {
                    if (objectArray[n] != null) continue;
                    return null;
                }
                n = ((Number)objectArray[1]).intValue();
                return ((CharacterType)this.dataType).substring(session, objectArray[0], 0L, n, true, this.funcType == 136);
            }
            case 139: {
                if (objectArray[0] == null) {
                    return null;
                }
                objectArray[0] = Type.SQL_INTEGER.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                int n = ((Number)objectArray[0]).intValue();
                char[] cArray = new char[n];
                ArrayUtil.fillArray(cArray, 0, ' ');
                return String.valueOf(cArray);
            }
            case 135: {
                if (objectArray[0] == null) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer((String)objectArray[0]);
                stringBuffer = stringBuffer.reverse();
                return stringBuffer.toString();
            }
            case 144: {
                Matcher matcher;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                if (!objectArray[1].equals(this.matchPattern)) {
                    this.matchPattern = (String)objectArray[1];
                    this.pattern = Pattern.compile(this.matchPattern);
                }
                return (matcher = this.pattern.matcher((String)objectArray[0])).matches() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 83: {
                byte[] byArray = Crypto.getNewKey((String)objectArray[0], (String)objectArray[1]);
                return StringConverter.byteArrayToHexString(byArray);
            }
        }
        throw Error.runtimeError(201, "FunctionCustom");
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            this.nodes[n].resolveTypes(session, this);
        }
        block0 : switch (this.funcType) {
            case 5: 
            case 29: 
            case 30: {
                super.resolveTypes(session, expression);
                return;
            }
            case 75: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 92: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 89: 
            case 90: 
            case 91: {
                this.dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                return;
            }
            case 76: {
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 141: {
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if ("yy".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    n = 839;
                } else if ("mm".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    n = 837;
                } else if ("dd".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    n = 835;
                } else if ("hh".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    n = 834;
                } else if ("mi".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    n = 833;
                } else if ("ss".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    n = 832;
                } else if ("ms".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    n = 831;
                } else {
                    throw Error.error(5561);
                }
                this.nodes[0].valueData = ValuePool.getInt(n);
                this.nodes[0].dataType = Type.SQL_INTEGER;
                this.funcType = 78;
            }
            case 78: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2].dataType.typeCode != 91 && this.nodes[2].dataType.typeCode != 93 && this.nodes[2].dataType.typeCode != 95) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[2].dataType;
                return;
            }
            case 142: {
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                if ("yy".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    n = 839;
                } else if ("mm".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    n = 837;
                } else if ("dd".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    n = 835;
                } else if ("hh".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    n = 834;
                } else if ("mi".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    n = 833;
                } else if ("ss".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    n = 832;
                } else if ("ms".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    n = 831;
                } else {
                    throw Error.error(3472, (String)this.nodes[0].valueData);
                }
                this.nodes[0].valueData = ValuePool.getInt(n);
                this.nodes[0].dataType = Type.SQL_INTEGER;
                this.funcType = 79;
            }
            case 79: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[2].dataType;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP;
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                block35 : switch (this.nodes[1].dataType.typeCode) {
                    case 91: {
                        if (this.nodes[2].dataType.typeCode != 91) {
                            throw Error.error(5563);
                        }
                        switch ((Integer)this.nodes[0].valueData) {
                            case 835: 
                            case 836: 
                            case 837: 
                            case 838: 
                            case 839: {
                                break block35;
                            }
                        }
                        throw Error.error(5563);
                    }
                    case 93: 
                    case 95: {
                        if (this.nodes[2].dataType.typeCode == 93 || this.nodes[2].dataType.typeCode == 95) break;
                        throw Error.error(5563);
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 80: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                } else if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.dataType = this.nodes[0].dataType;
                return;
            }
            case 81: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[1].dataType == null || !this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isExactNumberType() && !this.nodes[0].dataType.isDateTimeType()) {
                    throw Error.error(5563);
                }
                this.dataType = CharacterType.getCharacterType(12, 40L);
                if (this.nodes[1].opType == 1) {
                    this.nodes[1].setAsConstantValue(session);
                }
                return;
            }
            case 82: {
                Type type = this.nodes[0].dataType;
                if (this.nodes[1] == null) {
                    if (type == null) {
                        type = this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!type.isCharacterType() && type.typeCode != 93 && type.typeCode != 95) {
                        throw Error.error(5561);
                    }
                } else {
                    if (type == null) {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[0].dataType = this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                            type = this.nodes[1].dataType;
                        } else {
                            type = this.nodes[1].dataType.isCharacterType() ? (this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT) : (this.nodes[0].dataType = Type.SQL_DATE);
                        }
                    }
                    if (this.nodes[1].dataType == null) {
                        if (type.isCharacterType()) {
                            this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                        } else if (type.typeCode == 91) {
                            this.nodes[1].dataType = Type.SQL_TIME;
                        }
                    }
                    if (!(type.typeCode == 91 && this.nodes[1].dataType.typeCode == 92 || type.isCharacterType() && this.nodes[1].dataType.isCharacterType())) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = Type.SQL_TIMESTAMP;
                return;
            }
            case 111: {
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 113: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_BIGINT;
                    } else if (!this.nodes[0].dataType.isExactNumberType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 114: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
            }
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 112: 
            case 116: 
            case 117: 
            case 121: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 115: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 104: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 138: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.getType(12, 0, 4L, 0);
                break;
            }
            case 118: 
            case 119: 
            case 120: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType != null) continue;
                    this.nodes[n].dataType = Type.SQL_INTEGER;
                }
                this.dataType = this.nodes[0].dataType.getAggregateType(this.nodes[1].dataType);
                switch (this.dataType.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: 
                    case 25: {
                        break block0;
                    }
                    case 14: 
                    case 15: {
                        break block0;
                    }
                }
                throw Error.error(5561);
            }
            case 122: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 123: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.getType(12, 0, 1L, 0);
                break;
            }
            case 125: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 126: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : Type.getType(61, 0, this.nodes[0].dataType.precision / 2L, 0);
                break;
            }
            case 132: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : Type.getType(12, 0, this.nodes[0].dataType.precision * 2L, 0);
                break;
            }
            case 133: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if ((n = (int)(this.nodes[0].dataType.isCharacterType() ? 1 : 0)) == 0 && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = n != 0 ? Type.SQL_VARCHAR_DEFAULT : Type.SQL_VARBINARY_DEFAULT;
                break;
            }
            case 134: {
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[n].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 128: 
            case 136: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : Type.getType(12, 0, this.nodes[0].dataType.precision, 0);
                break;
            }
            case 139: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 135: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType() && !this.dataType.isLobType()) break;
                throw Error.error(5561);
            }
            case 144: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType() || this.nodes[1].dataType.isLobType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            case 83: {
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[n].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public String getSQL() {
        switch (this.funcType) {
            case 5: 
            case 29: 
            case 30: {
                return super.getSQL();
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 111: {
                return new StringBuffer(this.name).append("(").append(")").toString();
            }
            case 78: {
                String string = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return new StringBuffer("TIMESTAMPADD").append("(").append(string).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 79: {
                String string = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return new StringBuffer("TIMESTAMPDIFF").append("(").append(string).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 113: {
                StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
                if (this.nodes[0] != null) {
                    stringBuffer.append(this.nodes[0].getSQL());
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 121: 
            case 122: 
            case 123: 
            case 126: 
            case 132: 
            case 135: 
            case 138: 
            case 139: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(')').toString();
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 104: 
            case 114: 
            case 118: 
            case 119: 
            case 120: 
            case 125: 
            case 128: 
            case 133: 
            case 136: 
            case 144: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(')').toString();
            }
            case 134: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(')').toString();
            }
        }
        return super.getSQL();
    }

    public static char[] soundex(String string) {
        if (string == null) {
            return null;
        }
        string = string.toUpperCase(Locale.ENGLISH);
        int n = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        int n2 = 48;
        int n3 = 0;
        for (int i = 0; i < n && n3 < 4; ++i) {
            int n4;
            char c = string.charAt(i);
            if ("AEIOUY".indexOf(c) != -1) {
                n4 = 55;
            } else if (c == 'H' || c == 'W') {
                n4 = 56;
            } else if ("BFPV".indexOf(c) != -1) {
                n4 = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                n4 = 50;
            } else if (c == 'D' || c == 'T') {
                n4 = 51;
            } else if (c == 'L') {
                n4 = 52;
            } else if (c == 'M' || c == 'N') {
                n4 = 53;
            } else {
                if (c != 'R') continue;
                n4 = 54;
            }
            if (n3 == 0) {
                cArray[n3++] = c;
                n2 = n4;
                continue;
            }
            if (n4 <= 54) {
                if (n4 == n2) continue;
                cArray[n3++] = n4;
                n2 = n4;
                continue;
            }
            if (n4 != 55) continue;
            n2 = n4;
        }
        return cArray;
    }

    static {
        customRegularFuncMap.put(431, 7);
        customRegularFuncMap.put(608, 6);
        customRegularFuncMap.put(651, 8);
        customRegularFuncMap.put(637, 24);
        customRegularFuncMap.put(676, 25);
        customRegularFuncMap.put(641, 12);
        customRegularFuncMap.put(615, 41);
        customRegularFuncMap.put(616, 44);
        customRegularFuncMap.put(668, 21);
        customRegularFuncMap.put(614, 83);
        customRegularFuncMap.put(321, 5);
        customRegularFuncMap.put(171, 5);
        customRegularFuncMap.put(72, 5);
        customRegularFuncMap.put(126, 5);
        customRegularFuncMap.put(167, 5);
        customRegularFuncMap.put(248, 5);
        customRegularFuncMap.put(623, 5);
        customRegularFuncMap.put(646, 5);
        customRegularFuncMap.put(624, 5);
        customRegularFuncMap.put(625, 5);
        customRegularFuncMap.put(626, 5);
        customRegularFuncMap.put(653, 5);
        customRegularFuncMap.put(677, 5);
        customRegularFuncMap.put(663, 5);
        customRegularFuncMap.put(643, 29);
        customRegularFuncMap.put(662, 29);
        customRegularFuncMap.put(151, 128);
        customRegularFuncMap.put(127, 76);
        customRegularFuncMap.put(671, 78);
        customRegularFuncMap.put(672, 79);
        customRegularFuncMap.put(293, 80);
        customRegularFuncMap.put(673, 81);
        customRegularFuncMap.put(280, 82);
        nonDeterministicFuncSet.add(76);
        nonDeterministicFuncSet.add(78);
        nonDeterministicFuncSet.add(82);
        customRegularFuncMap.put(639, 1);
        customRegularFuncMap.put(133, 30);
        customRegularFuncMap.put(659, 135);
        customRegularFuncMap.put(564, 75);
        customRegularFuncMap.put(633, 71);
        customRegularFuncMap.put(636, 72);
        customRegularFuncMap.put(634, 73);
        customRegularFuncMap.put(635, 74);
        customRegularFuncMap.put(681, 85);
        customRegularFuncMap.put(682, 86);
        customRegularFuncMap.put(683, 87);
        customRegularFuncMap.put(684, 88);
        customRegularFuncMap.put(685, 89);
        customRegularFuncMap.put(686, 90);
        customRegularFuncMap.put(687, 91);
        customRegularFuncMap.put(688, 92);
        nonDeterministicFuncSet.add(75);
        nonDeterministicFuncSet.add(71);
        nonDeterministicFuncSet.add(72);
        nonDeterministicFuncSet.add(73);
        nonDeterministicFuncSet.add(74);
        nonDeterministicFuncSet.add(85);
        nonDeterministicFuncSet.add(86);
        nonDeterministicFuncSet.add(87);
        nonDeterministicFuncSet.add(88);
        nonDeterministicFuncSet.add(89);
        nonDeterministicFuncSet.add(90);
        nonDeterministicFuncSet.add(91);
        customRegularFuncMap.put(601, 101);
        customRegularFuncMap.put(603, 102);
        customRegularFuncMap.put(604, 103);
        customRegularFuncMap.put(605, 104);
        customRegularFuncMap.put(612, 105);
        customRegularFuncMap.put(613, 106);
        customRegularFuncMap.put(628, 107);
        customRegularFuncMap.put(642, 110);
        customRegularFuncMap.put(652, 111);
        customRegularFuncMap.put(654, 112);
        customRegularFuncMap.put(655, 113);
        customRegularFuncMap.put(660, 114);
        customRegularFuncMap.put(657, 144);
        customRegularFuncMap.put(664, 115);
        customRegularFuncMap.put(665, 116);
        customRegularFuncMap.put(670, 117);
        customRegularFuncMap.put(607, 118);
        customRegularFuncMap.put(609, 119);
        customRegularFuncMap.put(610, 120);
        customRegularFuncMap.put(661, 121);
        customRegularFuncMap.put(602, 122);
        customRegularFuncMap.put(32, 123);
        customRegularFuncMap.put(611, 124);
        customRegularFuncMap.put(629, 125);
        customRegularFuncMap.put(631, 126);
        customRegularFuncMap.put(656, 132);
        customRegularFuncMap.put(232, 133);
        customRegularFuncMap.put(658, 134);
        customRegularFuncMap.put(238, 136);
        customRegularFuncMap.put(666, 138);
        customRegularFuncMap.put(512, 139);
        customRegularFuncMap.put(617, 141);
        customRegularFuncMap.put(618, 142);
        customValueFuncMap = new IntKeyIntValueHashMap();
        customValueFuncMap.put(669, 50);
        customValueFuncMap.put(674, 41);
        customValueFuncMap.put(650, 50);
    }
}

