/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TableUtil;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public final class RangeVariable {
    static final RangeVariable[] emptyArray = new RangeVariable[0];
    final Table rangeTable;
    final HsqlNameManager.SimpleName tableAlias;
    private OrderedHashSet columnAliases;
    private HsqlNameManager.SimpleName[] columnAliasNames;
    private OrderedHashSet columnNames;
    OrderedHashSet namedJoinColumns;
    HashMap namedJoinColumnExpressions;
    private final Object[] emptyData;
    final boolean[] columnsInGroupBy;
    boolean hasKeyedColumnInGroupBy;
    final boolean[] usedColumns;
    boolean[] updatedColumns;
    RangeVariableConditions[] joinConditions;
    RangeVariableConditions[] whereConditions;
    int subRangeCount;
    Expression joinCondition;
    boolean isLeftJoin;
    boolean isRightJoin;
    int level;
    int rangePosition;
    int parsePosition;
    HashMappedList variables;
    boolean isVariable;

    RangeVariable(HashMappedList hashMappedList, boolean bl) {
        this.variables = hashMappedList;
        this.isVariable = bl;
        this.rangeTable = null;
        this.tableAlias = null;
        this.emptyData = null;
        this.columnsInGroupBy = null;
        this.usedColumns = null;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
    }

    RangeVariable(Table table, HsqlNameManager.SimpleName simpleName, OrderedHashSet orderedHashSet, HsqlNameManager.SimpleName[] simpleNameArray, ParserDQL.CompileContext compileContext) {
        this.rangeTable = table;
        this.tableAlias = simpleName;
        this.columnAliases = orderedHashSet;
        this.columnAliasNames = simpleNameArray;
        this.emptyData = this.rangeTable.getEmptyRowData();
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.joinConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
        compileContext.registerRangeVariable(this);
    }

    RangeVariable(Table table, int n) {
        this.rangeTable = table;
        this.tableAlias = null;
        this.emptyData = this.rangeTable.getEmptyRowData();
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.rangePosition = n;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
    }

    RangeVariable(RangeVariable rangeVariable) {
        this.rangeTable = rangeVariable.rangeTable;
        this.tableAlias = null;
        this.emptyData = this.rangeTable.getEmptyRowData();
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.rangePosition = rangeVariable.rangePosition;
        this.level = rangeVariable.level;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.joinConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
    }

    void setJoinType(boolean bl, boolean bl2) {
        this.isLeftJoin = bl;
        this.isRightJoin = bl2;
        if (this.isRightJoin) {
            this.whereConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
        }
    }

    public void addNamedJoinColumns(OrderedHashSet orderedHashSet) {
        this.namedJoinColumns = orderedHashSet;
    }

    public void addColumn(int n) {
        this.usedColumns[n] = true;
    }

    public void addAllColumns() {
    }

    void addNamedJoinColumnExpression(String string, Expression expression) {
        if (this.namedJoinColumnExpressions == null) {
            this.namedJoinColumnExpressions = new HashMap();
        }
        this.namedJoinColumnExpressions.put(string, expression);
    }

    ExpressionColumn getColumnExpression(String string) {
        return this.namedJoinColumnExpressions == null ? null : (ExpressionColumn)this.namedJoinColumnExpressions.get(string);
    }

    Table getTable() {
        return this.rangeTable;
    }

    Index getIndex() {
        if (this.joinConditions.length == 1) {
            return this.joinConditions[0].rangeIndex;
        }
        if (this.whereConditions.length == 1) {
            return this.whereConditions[0].rangeIndex;
        }
        return null;
    }

    boolean setIndex(Index index) {
        if (this.joinConditions.length == 1) {
            if (this.joinConditions[0].rangeIndex.getColumnCount() == 0) {
                this.joinConditions[0].rangeIndex = index;
                return true;
            }
        } else if (this.whereConditions.length == 1 && this.whereConditions[0].rangeIndex.getColumnCount() == 0) {
            this.whereConditions[0].rangeIndex = index;
            return true;
        }
        return false;
    }

    public OrderedHashSet getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new OrderedHashSet();
            this.rangeTable.getColumnNames(this.usedColumns, this.columnNames);
        }
        return this.columnNames;
    }

    public OrderedHashSet getUniqueColumnNameSet() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        if (this.columnAliases != null) {
            orderedHashSet.addAll(this.columnAliases);
            return orderedHashSet;
        }
        for (int i = 0; i < this.rangeTable.columnList.size(); ++i) {
            String string = this.rangeTable.getColumn((int)i).getName().name;
            boolean bl = orderedHashSet.add(string);
            if (bl) continue;
            throw Error.error(5578, string);
        }
        return orderedHashSet;
    }

    public int findColumn(String string) {
        if (this.namedJoinColumnExpressions != null && this.namedJoinColumnExpressions.containsKey(string)) {
            return -1;
        }
        if (this.variables != null) {
            return this.variables.getIndex(string);
        }
        if (this.columnAliases != null) {
            return this.columnAliases.getIndex(string);
        }
        return this.rangeTable.findColumn(string);
    }

    ColumnSchema getColumn(String string) {
        int n = this.findColumn(string);
        return n < 0 ? null : this.rangeTable.getColumn(n);
    }

    ColumnSchema getColumn(int n) {
        if (this.variables != null) {
            return (ColumnSchema)this.variables.get(n);
        }
        return this.rangeTable.getColumn(n);
    }

    String getColumnAlias(int n) {
        HsqlNameManager.SimpleName simpleName = this.getColumnAliasName(n);
        return simpleName.name;
    }

    public HsqlNameManager.SimpleName getColumnAliasName(int n) {
        if (this.columnAliases != null) {
            return this.columnAliasNames[n];
        }
        return this.rangeTable.getColumn(n).getName();
    }

    boolean hasColumnAlias() {
        return this.columnAliases != null;
    }

    boolean resolvesTableName(ExpressionColumn expressionColumn) {
        if (expressionColumn.tableName == null) {
            return true;
        }
        return expressionColumn.schema == null ? (this.tableAlias == null ? expressionColumn.tableName.equals(this.rangeTable.tableName.name) : expressionColumn.tableName.equals(this.tableAlias.name)) : expressionColumn.tableName.equals(this.rangeTable.tableName.name) && expressionColumn.schema.equals(this.rangeTable.tableName.schema.name);
    }

    public boolean resolvesTableName(String string) {
        if (string == null) {
            return true;
        }
        return this.tableAlias == null ? string.equals(this.rangeTable.tableName.name) : string.equals(this.tableAlias.name);
    }

    boolean resolvesSchemaName(String string) {
        if (string == null) {
            return true;
        }
        if (this.tableAlias != null) {
            return false;
        }
        return string.equals(this.rangeTable.tableName.schema.name);
    }

    void addTableColumns(HsqlArrayList hsqlArrayList) {
        if (this.namedJoinColumns != null) {
            int n = hsqlArrayList.size();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Expression expression = (Expression)hsqlArrayList.get(i);
                String string = expression.getColumnName();
                if (!this.namedJoinColumns.contains(string)) continue;
                if (n2 != i) {
                    hsqlArrayList.remove(i);
                    hsqlArrayList.add(n2, expression);
                }
                expression = this.getColumnExpression(string);
                hsqlArrayList.set(n2, expression);
                ++n2;
            }
        }
        this.addTableColumns(hsqlArrayList, hsqlArrayList.size(), this.namedJoinColumns);
    }

    int addTableColumns(HsqlArrayList hsqlArrayList, int n, HashSet hashSet) {
        Table table = this.getTable();
        int n2 = table.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            String string;
            ColumnSchema columnSchema = table.getColumn(i);
            String string2 = string = this.columnAliases == null ? columnSchema.getName().name : (String)this.columnAliases.get(i);
            if (hashSet != null && hashSet.contains(string)) continue;
            ExpressionColumn expressionColumn = new ExpressionColumn(this, i);
            hsqlArrayList.add(n++, expressionColumn);
        }
        return n;
    }

    void addTableColumns(Expression expression, HashSet hashSet) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Table table = this.getTable();
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String string;
            ColumnSchema columnSchema = table.getColumn(i);
            String string2 = string = this.columnAliases == null ? columnSchema.getName().name : (String)this.columnAliases.get(i);
            if (hashSet != null && hashSet.contains(string)) continue;
            ExpressionColumn expressionColumn = new ExpressionColumn(this, i);
            hsqlArrayList.add(expressionColumn);
        }
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        expression.nodes = expressionArray;
    }

    void setForCheckConstraint() {
        this.joinConditions[0].rangeIndex = null;
    }

    Expression getJoinCondition() {
        return this.joinCondition;
    }

    void addJoinCondition(Expression expression) {
        this.joinCondition = ExpressionLogical.andExpressions(this.joinCondition, expression);
    }

    public String describe(Session session) {
        RangeVariableConditions[] rangeVariableConditionsArray = this.joinConditions;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < rangeVariableConditionsArray.length; ++i) {
            RangeVariableConditions rangeVariableConditions = this.joinConditions[i];
            if (i > 0) {
                stringBuffer.append("\nOR condition = [");
                stringBuffer.append(rangeVariableConditions.describe(session)).append("]\n");
                continue;
            }
            boolean bl = !rangeVariableConditions.hasIndexCondition();
            stringBuffer.append("table=[").append(this.rangeTable.getName().name).append("]\n");
            if (this.tableAlias != null) {
                stringBuffer.append("alias=[").append(this.tableAlias.name).append("]\n");
            }
            stringBuffer.append("access=[").append(bl ? "FULL SCAN" : "INDEX PRED").append("]\n");
            String string = "INNER";
            if (this.isLeftJoin) {
                string = "LEFT OUTER";
                if (this.isRightJoin) {
                    string = "FULL";
                }
            } else if (this.isRightJoin) {
                string = "RIGHT OUTER";
            }
            stringBuffer.append("join type=[").append(string).append("]\n");
            stringBuffer.append(rangeVariableConditions.describe(session));
        }
        return stringBuffer.toString();
    }

    public RangeIteratorMain getIterator(Session session) {
        RangeIteratorMain rangeIteratorMain = this.isRightJoin ? new RangeIteratorRight(session, this, null) : new RangeIteratorMain(session, this);
        session.sessionContext.setRangeIterator(rangeIteratorMain);
        return rangeIteratorMain;
    }

    public static RangeIterator getIterator(Session session, RangeVariable[] rangeVariableArray) {
        if (rangeVariableArray.length == 1) {
            return rangeVariableArray[0].getIterator(session);
        }
        RangeIteratorMain[] rangeIteratorMainArray = new RangeIteratorMain[rangeVariableArray.length];
        for (int i = 0; i < rangeVariableArray.length; ++i) {
            rangeIteratorMainArray[i] = rangeVariableArray[i].getIterator(session);
        }
        return new RangeIteratorJoined(rangeIteratorMainArray);
    }

    public static class RangeVariableConditions {
        final RangeVariable rangeVar;
        Expression[] indexCond;
        Expression indexEndCondition;
        boolean isFindFirstRowArg;
        int indexedColumnCount;
        Index rangeIndex;
        final boolean isJoin;
        Expression excludeConditions;
        Expression nonIndexCondition;
        int opType;

        RangeVariableConditions(RangeVariable rangeVariable, boolean bl) {
            this.rangeVar = rangeVariable;
            this.isJoin = bl;
        }

        RangeVariableConditions(RangeVariableConditions rangeVariableConditions) {
            this.rangeVar = rangeVariableConditions.rangeVar;
            this.isJoin = rangeVariableConditions.isJoin;
            this.nonIndexCondition = rangeVariableConditions.nonIndexCondition;
        }

        boolean hasIndexCondition() {
            return this.indexedColumnCount > 0;
        }

        void addCondition(Expression expression) {
            if (expression == null) {
                return;
            }
            this.nonIndexCondition = ExpressionLogical.andExpressions(this.nonIndexCondition, expression);
            if (this.rangeIndex == null || this.rangeIndex.getColumnCount() == 0) {
                return;
            }
            switch (expression.getType()) {
                case 42: 
                case 43: {
                    if (expression.getIndexableExpression(this.rangeVar) == null) break;
                    if (this.indexCond == null) {
                        if (this.opType != 44 && this.opType != 45 || this.rangeIndex.getColumns()[0] != expression.getLeftNode().getColumnIndex()) break;
                        this.indexCond = new Expression[]{expression};
                        this.opType = expression.opType;
                        break;
                    }
                    this.addToIndexConditions(expression);
                    break;
                }
                case 44: 
                case 45: {
                    if (expression.getIndexableExpression(this.rangeVar) == null) break;
                    if (this.indexedColumnCount < this.rangeIndex.getColumnCount()) {
                        if (this.rangeIndex.getColumns()[this.indexedColumnCount] != expression.getLeftNode().getColumnIndex()) break;
                        this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, expression);
                        break;
                    }
                    if (this.rangeIndex.getColumns()[this.indexedColumnCount - 1] != expression.getLeftNode().getColumnIndex()) break;
                    this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, expression);
                    break;
                }
            }
        }

        boolean addToIndexConditions(Expression expression) {
            if (this.opType == 41 && this.indexedColumnCount < this.rangeIndex.getColumnCount() && this.rangeIndex.getColumns()[this.indexedColumnCount] == expression.getLeftNode().getColumnIndex()) {
                this.indexCond[this.indexedColumnCount] = expression;
                ++this.indexedColumnCount;
                this.opType = expression.opType;
                return true;
            }
            return false;
        }

        void addIndexCondition(Expression[] expressionArray, Index index, int n) {
            this.rangeIndex = index;
            this.opType = expressionArray[0].getType();
            switch (this.opType) {
                case 48: {
                    this.indexCond = expressionArray;
                    break;
                }
                case 42: 
                case 43: {
                    this.indexCond = expressionArray;
                    break;
                }
                case 44: 
                case 45: {
                    this.indexEndCondition = expressionArray[0];
                    break;
                }
                case 41: 
                case 47: {
                    for (int i = 0; i < n; ++i) {
                        Expression expression = expressionArray[i];
                        this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, expression);
                    }
                    this.indexCond = expressionArray;
                    this.isFindFirstRowArg = true;
                    break;
                }
                default: {
                    Error.runtimeError(201, "RangeVariable");
                }
            }
            this.indexedColumnCount = n;
        }

        String describe(Session session) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("index=[").append(this.rangeIndex.getName().name).append("]\n");
            if (this.hasIndexCondition()) {
                if (this.indexedColumnCount > 0) {
                    stringBuffer.append("start conditions=[");
                    for (int i = 0; i < this.indexedColumnCount; ++i) {
                        if (this.indexCond[i] == null) continue;
                        stringBuffer.append(this.indexCond[i].describe(session));
                    }
                    stringBuffer.append("]\n");
                }
                if (this.indexEndCondition != null) {
                    String string = this.indexEndCondition.describe(session);
                    stringBuffer.append("end condition=[").append(string).append("]\n");
                }
            }
            if (this.nonIndexCondition != null) {
                String string = this.nonIndexCondition.describe(session);
                stringBuffer.append("other condition=[").append(string).append("]\n");
            }
            return stringBuffer.toString();
        }
    }

    public static class RangeIteratorJoined
    extends RangeIteratorBase {
        RangeIteratorMain[] rangeIterators;
        int currentIndex = 0;

        public RangeIteratorJoined(RangeIteratorMain[] rangeIteratorMainArray) {
            this.rangeIterators = rangeIteratorMainArray;
            this.isBeforeFirst = true;
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            while (this.currentIndex >= 0) {
                RangeIteratorMain rangeIteratorMain = this.rangeIterators[this.currentIndex];
                if (rangeIteratorMain.next()) {
                    if (this.currentIndex < this.rangeIterators.length - 1) {
                        ++this.currentIndex;
                        continue;
                    }
                    this.currentRow = this.rangeIterators[this.currentIndex].currentRow;
                    this.currentData = this.currentRow.getData();
                    return true;
                }
                rangeIteratorMain.reset();
                --this.currentIndex;
            }
            this.currentData = this.rangeIterators[this.rangeIterators.length - 1].rangeVar.emptyData;
            this.currentRow = null;
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
            return false;
        }

        @Override
        public void remove() {
        }

        @Override
        public void reset() {
            super.reset();
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
        }

        @Override
        public int getRangePosition() {
            return 0;
        }

        @Override
        public RangeVariable getRange() {
            return null;
        }
    }

    public static class RangeIteratorRight
    extends RangeIteratorMain {
        boolean isOnRightOuterRows;

        private RangeIteratorRight(Session session, RangeVariable rangeVariable, RangeIteratorMain rangeIteratorMain) {
            super(session, rangeVariable);
            this.isFullIterator = true;
        }

        public void setOnOuterRows() {
            this.conditions = this.rangeVar.whereConditions;
            this.isOnRightOuterRows = true;
            this.hasLeftOuterRow = false;
            this.condIndex = 0;
            this.initialiseIterator();
        }

        @Override
        public boolean next() {
            if (this.isOnRightOuterRows) {
                if (this.it == null) {
                    return false;
                }
                return this.findNextRight();
            }
            return super.next();
        }

        protected boolean findNextRight() {
            boolean bl;
            block2: {
                bl = false;
                do {
                    this.currentRow = this.it.getNextRow();
                    if (this.currentRow == null) break block2;
                    this.currentData = this.currentRow.getData();
                    if (this.conditions[this.condIndex].indexEndCondition != null && !this.conditions[this.condIndex].indexEndCondition.testCondition(this.session)) break block2;
                } while (this.conditions[this.condIndex].nonIndexCondition != null && !this.conditions[this.condIndex].nonIndexCondition.testCondition(this.session) || !this.lookupAndTest());
                bl = true;
            }
            if (bl) {
                return true;
            }
            this.it.release();
            this.currentRow = null;
            this.currentData = this.rangeVar.emptyData;
            return bl;
        }

        private boolean lookupAndTest() {
            RowIterator rowIterator = this.lookupTable.indexList[0].findFirstRow(this.session, this.lookupStore, ValuePool.getInt(this.currentRow.getPos()), 41, null);
            boolean bl = !rowIterator.hasNext();
            rowIterator.release();
            if (bl) {
                this.currentData = this.currentRow.getData();
                if (this.conditions[this.condIndex].nonIndexCondition != null && !this.conditions[this.condIndex].nonIndexCondition.testCondition(this.session)) {
                    bl = false;
                }
            }
            return bl;
        }
    }

    public static class RangeIteratorMain
    extends RangeIteratorBase {
        boolean hasLeftOuterRow;
        boolean isFullIterator;
        RangeVariableConditions[] conditions;
        RangeVariableConditions[] whereConditions;
        RangeVariableConditions[] joinConditions;
        int condIndex = 0;
        Table lookupTable;
        PersistentStore lookupStore;

        RangeIteratorMain() {
        }

        private RangeIteratorMain(Session session, RangeVariable rangeVariable) {
            this.rangePosition = rangeVariable.rangePosition;
            this.store = session.sessionData.getRowStore(rangeVariable.rangeTable);
            this.session = session;
            this.rangeVar = rangeVariable;
            this.currentData = rangeVariable.emptyData;
            this.isBeforeFirst = true;
            if (rangeVariable.isRightJoin) {
                this.lookupTable = TableUtil.newLookupTable(session.database);
                this.lookupStore = session.sessionData.getRowStore(this.lookupTable);
            }
            this.conditions = rangeVariable.joinConditions;
            if (rangeVariable.whereConditions[0].hasIndexCondition()) {
                this.conditions = rangeVariable.whereConditions;
            }
            this.whereConditions = rangeVariable.whereConditions;
            this.joinConditions = rangeVariable.joinConditions;
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            while (this.condIndex < this.conditions.length) {
                boolean bl;
                if (this.isBeforeFirst) {
                    this.isBeforeFirst = false;
                    this.initialiseIterator();
                }
                if (bl = this.findNext()) {
                    return true;
                }
                this.reset();
                ++this.condIndex;
            }
            this.condIndex = 0;
            return false;
        }

        @Override
        public void remove() {
        }

        @Override
        public void reset() {
            if (this.it != null) {
                this.it.release();
            }
            this.it = null;
            this.currentData = this.rangeVar.emptyData;
            this.currentRow = null;
            this.hasLeftOuterRow = false;
            this.isBeforeFirst = true;
        }

        @Override
        public int getRangePosition() {
            return this.rangeVar.rangePosition;
        }

        protected void initialiseIterator() {
            this.hasLeftOuterRow = false;
            if (this.condIndex == this.conditions.length - 1) {
                this.hasLeftOuterRow = this.rangeVar.isLeftJoin;
            }
            if (this.conditions[this.condIndex].indexCond == null) {
                this.it = this.conditions[this.condIndex].indexEndCondition == null ? this.conditions[this.condIndex].rangeIndex.firstRow(this.session, this.store) : this.conditions[this.condIndex].rangeIndex.findFirstRowNotNull(this.session, this.store);
            } else if (this.conditions[this.condIndex].isFindFirstRowArg) {
                this.getFirstRow();
                if (!this.conditions[this.condIndex].isJoin) {
                    this.hasLeftOuterRow = false;
                }
            } else {
                if (this.conditions[this.condIndex].indexCond[0].getType() == 48) {
                    this.it = this.conditions[this.condIndex].rangeIndex.findFirstRowNotNull(this.session, this.store);
                } else {
                    this.getFirstRow();
                }
                if (!this.conditions[this.condIndex].isJoin) {
                    this.hasLeftOuterRow = false;
                }
            }
        }

        private void getFirstRow() {
            Object[] objectArray = null;
            if (this.conditions[this.condIndex].isFindFirstRowArg) {
                objectArray = new Object[this.conditions[this.condIndex].rangeIndex.getVisibleColumns()];
            }
            for (int i = 0; i < this.conditions[this.condIndex].indexedColumnCount; ++i) {
                int n = 0;
                if (this.conditions[this.condIndex].indexCond[i].getType() == 47) continue;
                Type type = this.conditions[this.condIndex].indexCond[i].getRightNode().getDataType();
                Object object = this.conditions[this.condIndex].indexCond[i].getRightNode().getValue(this.session);
                Type type2 = this.conditions[this.condIndex].indexCond[i].getLeftNode().getDataType();
                if (type2 != type && (n = type2.compareToTypeRange(object)) == 0) {
                    object = type2.convertToType(this.session, object, type);
                }
                if (this.conditions[this.condIndex].indexedColumnCount == 1) {
                    int n2 = this.conditions[this.condIndex].indexCond[0].getType();
                    if (n == 0) {
                        this.it = this.conditions[this.condIndex].rangeIndex.findFirstRow(this.session, this.store, object, n2, null);
                    } else if (n < 0) {
                        switch (n2) {
                            case 42: 
                            case 43: {
                                this.it = this.conditions[this.condIndex].rangeIndex.findFirstRowNotNull(this.session, this.store);
                                break;
                            }
                            default: {
                                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                                break;
                            }
                        }
                    } else {
                        switch (n2) {
                            case 44: 
                            case 45: {
                                this.it = this.conditions[this.condIndex].rangeIndex.findFirstRowNotNull(this.session, this.store);
                                break;
                            }
                            default: {
                                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                            }
                        }
                    }
                    return;
                }
                objectArray[i] = object;
            }
            if (this.conditions[this.condIndex].isFindFirstRowArg) {
                this.it = this.conditions[this.condIndex].rangeIndex.findFirstRow(this.session, this.store, objectArray, this.conditions[this.condIndex].indexedColumnCount, this.conditions[this.condIndex].opType, null);
            }
        }

        protected boolean findNext() {
            boolean bl;
            block5: {
                bl = false;
                while (true) {
                    this.currentRow = this.it.getNextRow();
                    if (this.currentRow == null) break block5;
                    this.currentData = this.currentRow.getData();
                    if (this.conditions[this.condIndex].indexEndCondition != null && !this.conditions[this.condIndex].indexEndCondition.testCondition(this.session)) {
                        if (!this.conditions[this.condIndex].isJoin) {
                            this.hasLeftOuterRow = false;
                        }
                        break block5;
                    }
                    if (this.joinConditions[this.condIndex].nonIndexCondition != null && !this.joinConditions[this.condIndex].nonIndexCondition.testCondition(this.session)) continue;
                    if (this.whereConditions[this.condIndex].nonIndexCondition != null && !this.whereConditions[this.condIndex].nonIndexCondition.testCondition(this.session)) {
                        this.hasLeftOuterRow = false;
                        continue;
                    }
                    Expression expression = this.conditions[this.condIndex].excludeConditions;
                    if (expression == null || !expression.testCondition(this.session)) break;
                }
                this.addFoundRow();
                this.hasLeftOuterRow = false;
                return true;
            }
            this.it.release();
            this.currentRow = null;
            this.currentData = this.rangeVar.emptyData;
            if (this.hasLeftOuterRow) {
                bl = this.whereConditions[this.condIndex].nonIndexCondition == null || this.whereConditions[this.condIndex].nonIndexCondition.testCondition(this.session);
            }
            this.hasLeftOuterRow = false;
            return bl;
        }

        protected void addFoundRow() {
            if (this.rangeVar.isRightJoin) {
                try {
                    this.lookupTable.insertData(this.lookupStore, new Object[]{ValuePool.getInt(this.currentRow.getPos())});
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
    }

    public static class RangeIteratorBase
    implements RangeIterator {
        Session session;
        int rangePosition;
        RowIterator it;
        PersistentStore store;
        Object[] currentData;
        Row currentRow;
        boolean isBeforeFirst;
        RangeVariable rangeVar;

        RangeIteratorBase() {
        }

        public RangeIteratorBase(Session session, PersistentStore persistentStore, TableBase tableBase, int n) {
            this.session = session;
            this.rangePosition = n;
            this.store = persistentStore;
            this.it = tableBase.rowIterator(persistentStore);
            this.isBeforeFirst = true;
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            if (this.isBeforeFirst) {
                this.isBeforeFirst = false;
            } else if (this.it == null) {
                return false;
            }
            this.currentRow = this.it.getNextRow();
            if (this.currentRow == null) {
                return false;
            }
            this.currentData = this.currentRow.getData();
            return true;
        }

        @Override
        public Row getCurrentRow() {
            return this.currentRow;
        }

        @Override
        public Object[] getCurrent() {
            return this.currentData;
        }

        @Override
        public void setCurrent(Object[] objectArray) {
            this.currentData = objectArray;
        }

        @Override
        public long getRowId() {
            return this.currentRow == null ? 0L : ((long)this.rangeVar.rangeTable.getId() << 32) + (long)this.currentRow.getPos();
        }

        @Override
        public Object getRowidObject() {
            return this.currentRow == null ? null : ValuePool.getLong(this.getRowId());
        }

        @Override
        public void remove() {
        }

        @Override
        public void reset() {
            if (this.it != null) {
                this.it.release();
            }
            this.it = null;
            this.currentRow = null;
            this.isBeforeFirst = true;
        }

        @Override
        public int getRangePosition() {
            return this.rangePosition;
        }

        @Override
        public RangeVariable getRange() {
            return this.rangeVar;
        }

        @Override
        public Row getNextRow() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public boolean hasNext() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public Object[] getNext() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public boolean setRowColumns(boolean[] blArray) {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public void release() {
        }
    }
}

