/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.ResultSet;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserRoutine;
import org.hsqldb.RangeVariable;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.Token;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.store.BitMap;
import org.hsqldb.types.Type;
import org.hsqldb.types.Types;

public class Routine
implements SchemaObject {
    public static final int NO_SQL = 1;
    public static final int CONTAINS_SQL = 2;
    public static final int READS_SQL = 3;
    public static final int MODIFIES_SQL = 4;
    public static final int LANGUAGE_JAVA = 1;
    public static final int LANGUAGE_SQL = 2;
    public static final int PARAM_STYLE_JAVA = 1;
    public static final int PARAM_STYLE_SQL = 2;
    static final Routine[] emptyArray = new Routine[0];
    RoutineSchema routineSchema;
    private HsqlNameManager.HsqlName name;
    private HsqlNameManager.HsqlName specificName;
    Type[] parameterTypes;
    int typeGroups;
    Type returnType;
    Type[] tableType;
    TableDerived returnTable;
    final int routineType;
    int language = 2;
    int dataImpact = 2;
    int parameterStyle;
    boolean isDeterministic;
    boolean isNullInputOutput;
    boolean isNewSavepointLevel = true;
    boolean isPSM;
    boolean returnsTable;
    Statement statement;
    private String methodName;
    Method javaMethod;
    boolean javaMethodWithConnection;
    private boolean isLibraryRoutine;
    HashMappedList parameterList = new HashMappedList();
    int scopeVariableCount;
    RangeVariable[] ranges;
    int variableCount;
    OrderedHashSet references;
    Table triggerTable;
    int triggerType;
    int triggerOperation;

    public Routine(int n) {
        this.routineType = n;
        this.returnType = Type.SQL_ALL_TYPES;
        this.ranges = new RangeVariable[]{new RangeVariable(this.parameterList, false)};
    }

    public Routine(Table table, RangeVariable[] rangeVariableArray, int n, int n2, int n3) {
        this.routineType = 8;
        this.returnType = Type.SQL_ALL_TYPES;
        this.dataImpact = n;
        this.ranges = rangeVariableArray;
        this.triggerTable = table;
        this.triggerType = n2;
        this.triggerOperation = n3;
    }

    @Override
    public int getType() {
        return this.routineType;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return this.references;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
        ParserRoutine parserRoutine = new ParserRoutine(session, new Scanner(this.statement.getSQL()));
        parserRoutine.read();
        parserRoutine.startRecording();
        Statement statement = parserRoutine.compileSQLProcedureStatementOrNull(this, null);
        Token[] tokenArray = parserRoutine.getRecordedStatement();
        String string = Token.getSQL(tokenArray);
        statement.setSQL(string);
        this.setProcedure(statement);
        statement.resolve(session);
        this.setReferences();
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE").append(' ');
        if (this.routineType == 17) {
            stringBuffer.append("PROCEDURE");
        } else {
            stringBuffer.append("FUNCTION");
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.name.getSchemaQualifiedStatementName());
        stringBuffer.append('(');
        for (int i = 0; i < this.parameterList.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            ColumnSchema columnSchema = (ColumnSchema)this.parameterList.get(i);
            stringBuffer.append(columnSchema.getSQL());
        }
        stringBuffer.append(')');
        stringBuffer.append(' ');
        if (this.routineType == 16) {
            stringBuffer.append("RETURNS");
            stringBuffer.append(' ');
            if (this.returnsTable) {
                stringBuffer.append("TABLE");
                stringBuffer.append(this.returnTable.getColumnListWithTypeSQL());
            } else {
                stringBuffer.append(this.returnType.getTypeDefinition());
            }
            stringBuffer.append(' ');
        }
        if (this.specificName != null) {
            stringBuffer.append("SPECIFIC");
            stringBuffer.append(' ');
            stringBuffer.append(this.specificName.getStatementName());
            stringBuffer.append(' ');
        }
        stringBuffer.append("LANGUAGE");
        stringBuffer.append(' ');
        if (this.language == 1) {
            stringBuffer.append("JAVA");
        } else {
            stringBuffer.append("SQL");
        }
        stringBuffer.append(' ');
        if (!this.isDeterministic) {
            stringBuffer.append("NOT");
            stringBuffer.append(' ');
        }
        stringBuffer.append("DETERMINISTIC");
        stringBuffer.append(' ');
        stringBuffer.append(this.getDataImpactString());
        stringBuffer.append(' ');
        if (this.routineType == 16) {
            if (this.isNullInputOutput) {
                stringBuffer.append("RETURNS").append(' ').append("NULL");
            } else {
                stringBuffer.append("CALLED");
            }
            stringBuffer.append(' ').append("ON").append(' ');
            stringBuffer.append("NULL").append(' ').append("INPUT");
            stringBuffer.append(' ');
        } else {
            if (this.isNewSavepointLevel) {
                stringBuffer.append("NEW");
            } else {
                stringBuffer.append("OLD");
            }
            stringBuffer.append(' ').append("SAVEPOINT").append(' ');
            stringBuffer.append("LEVEL").append(' ');
        }
        if (this.language == 1) {
            stringBuffer.append("EXTERNAL").append(' ').append("NAME");
            stringBuffer.append(' ').append('\'').append(this.methodName).append('\'');
        } else {
            stringBuffer.append(this.statement.getSQL());
        }
        return stringBuffer.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public void addParameter(ColumnSchema columnSchema) {
        HsqlNameManager.HsqlName hsqlName = columnSchema.getName();
        String string = hsqlName == null ? HsqlNameManager.getAutoNoNameColumnString(this.parameterList.size()) : hsqlName.name;
        this.parameterList.add(string, columnSchema);
    }

    public void setLanguage(int n) {
        this.language = n;
        this.isPSM = this.language == 2;
    }

    public int getLanguage() {
        return this.language;
    }

    boolean isPSM() {
        return this.isPSM;
    }

    public void setDataImpact(int n) {
        this.dataImpact = n;
    }

    public int getDataImpact() {
        return this.dataImpact;
    }

    public String getDataImpactString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.dataImpact) {
            case 1: {
                stringBuffer.append("NO").append(' ').append("SQL");
                break;
            }
            case 2: {
                stringBuffer.append("CONTAINS").append(' ').append("SQL");
                break;
            }
            case 3: {
                stringBuffer.append("READS").append(' ').append("SQL").append(' ').append("DATA");
                break;
            }
            case 4: {
                stringBuffer.append("MODIFIES").append(' ').append("SQL").append(' ').append("DATA");
            }
        }
        return stringBuffer.toString();
    }

    public void setReturnType(Type type) {
        this.returnType = type;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public void setTableType(Type[] typeArray) {
        this.tableType = typeArray;
    }

    public Type[] getTableType() {
        return this.tableType;
    }

    public void setProcedure(Statement statement) {
        this.statement = statement;
    }

    public Statement getProcedure() {
        return this.statement;
    }

    public void setSpecificName(HsqlNameManager.HsqlName hsqlName) {
        this.specificName = hsqlName;
    }

    public void setName(HsqlNameManager.HsqlName hsqlName) {
        this.name = hsqlName;
    }

    public HsqlNameManager.HsqlName getSpecificName() {
        return this.specificName;
    }

    public void setDeterministic(boolean bl) {
        this.isDeterministic = bl;
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public void setNullInputOutput(boolean bl) {
        this.isNullInputOutput = bl;
    }

    public boolean isNullInputOutput() {
        return this.isNullInputOutput;
    }

    public void setNewSavepointLevel(boolean bl) {
        this.isNewSavepointLevel = bl;
    }

    public void setParameterStyle(int n) {
        this.parameterStyle = n;
    }

    public void setMethodURL(String string) {
        this.methodName = string;
    }

    public Method getMethod() {
        return this.javaMethod;
    }

    public void setMethod(Method method) {
        this.javaMethod = method;
    }

    public void setReturnTable(TableDerived tableDerived) {
        this.returnTable = tableDerived;
        this.returnsTable = true;
    }

    public boolean returnsTable() {
        return this.returnsTable;
    }

    public void resolve(Session session) {
        Object object;
        if (this.routineType == 17 && this.isNewSavepointLevel && this.dataImpact != 4) {
            throw Error.error(5604);
        }
        this.setLanguage(this.language);
        if (this.language == 2) {
            if (this.dataImpact == 1) {
                throw Error.error(5604);
            }
            if (this.parameterStyle == 1) {
                throw Error.error(5604);
            }
        }
        if (this.language == 2 && this.parameterStyle != 0 && this.parameterStyle != 2) {
            throw Error.error(5604);
        }
        this.parameterTypes = new Type[this.parameterList.size()];
        this.typeGroups = 0;
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            object = (ColumnSchema)this.parameterList.get(i);
            this.parameterTypes[i] = ((ColumnSchema)object).dataType;
            if (i >= 4) continue;
            BitMap.setByte(this.typeGroups, (byte)((ColumnSchema)object).dataType.typeComparisonGroup, i * 8);
        }
        if (this.statement != null) {
            this.statement.resolve(session);
            if (this.dataImpact == 2) {
                Routine.checkNoSQLData(session.database, this.statement.getReferences());
            }
        }
        if (this.methodName != null && this.javaMethod == null) {
            boolean[] blArray = new boolean[1];
            this.javaMethod = Routine.getMethod(this.methodName, this, blArray, this.returnsTable);
            if (this.javaMethod == null) {
                throw Error.error(6013);
            }
            this.javaMethodWithConnection = blArray[0];
            object = this.javaMethod.getDeclaringClass().getName();
            if (((String)object).equals("java.lang.Math")) {
                this.isLibraryRoutine = true;
            }
        }
        this.setReferences();
    }

    private void setReferences() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            ColumnSchema columnSchema = (ColumnSchema)this.parameterList.get(i);
            orderedHashSet.addAll(columnSchema.getReferences());
        }
        if (this.statement != null) {
            orderedHashSet.addAll(this.statement.getReferences());
        }
        this.references = orderedHashSet;
    }

    public boolean isTrigger() {
        return this.routineType == 8;
    }

    public boolean isProcedure() {
        return this.routineType == 17;
    }

    public boolean isFunction() {
        return this.routineType == 16;
    }

    public ColumnSchema getParameter(int n) {
        return (ColumnSchema)this.parameterList.get(n);
    }

    Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    int getParameterSignature() {
        return this.typeGroups;
    }

    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    public int getParameterCount(int n) {
        int n2 = 0;
        for (int i = 0; i < this.parameterList.size(); ++i) {
            ColumnSchema columnSchema = (ColumnSchema)this.parameterList.get(i);
            if (columnSchema.getParameterMode() != n) continue;
            ++n2;
        }
        return n2;
    }

    public int getParameterIndex(String string) {
        return this.parameterList.getIndex(string);
    }

    public RangeVariable[] getParameterRangeVariables() {
        return this.ranges;
    }

    public int getVariableCount() {
        return this.variableCount;
    }

    public boolean isLibraryRoutine() {
        return this.isLibraryRoutine;
    }

    public HsqlNameManager.HsqlName[] getTableNamesForRead() {
        if (this.statement == null) {
            return HsqlNameManager.HsqlName.emptyArray;
        }
        return this.statement.getTableNamesForRead();
    }

    public HsqlNameManager.HsqlName[] getTableNamesForWrite() {
        if (this.statement == null) {
            return HsqlNameManager.HsqlName.emptyArray;
        }
        return this.statement.getTableNamesForWrite();
    }

    static Method getMethod(String string, Routine routine, boolean[] blArray, boolean bl) {
        int n = string.indexOf(58);
        if (n != -1) {
            if (!string.substring(0, n).equals("CLASSPATH")) {
                throw Error.error(6012, string);
            }
            string = string.substring(n + 1);
        }
        Method method = null;
        Method[] methodArray = Routine.getMethods(string);
        int n2 = -1;
        for (n = 0; n < methodArray.length; ++n) {
            Class<?> clazz;
            Type type;
            Type type2;
            int n3 = 0;
            method = methodArray[n];
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length > 0 && classArray[0].equals(Connection.class)) {
                n3 = 1;
                blArray[0] = true;
            }
            if (classArray.length - n3 != routine.parameterTypes.length || (bl ? !ResultSet.class.isAssignableFrom(method.getReturnType()) : (type2 = Type.getDefaultTypeWithSize(Types.getParameterSQLTypeNumber(method.getReturnType()))) == null || type2.typeCode != routine.returnType.typeCode)) continue;
            for (int i = 0; i < routine.parameterTypes.length && (type = Type.getDefaultType(Types.getParameterSQLTypeNumber(clazz = classArray[i + n3]))) != null; ++i) {
                routine.getParameter(i).setNullable(!classArray[n].isPrimitive());
                if (routine.parameterTypes[i].typeCode == type.typeCode) continue;
                method = null;
                if (i + n3 <= n2) break;
                n2 = i + n3;
                break;
            }
            if (method != null) break;
        }
        if (n2 >= 0) {
            ColumnSchema columnSchema = routine.getParameter(n2);
            throw Error.error(6021, columnSchema.getNameString());
        }
        return method;
    }

    static Method[] getMethods(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw Error.error(5501, string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 5501, 26, new Object[]{throwable.getMessage(), string2});
        }
        Method[] methodArray = clazz.getMethods();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        for (n = 0; n < methodArray.length; ++n) {
            int n2 = 0;
            Method method = methodArray[n];
            int n3 = method.getModifiers();
            if (!method.getName().equals(string3) || !Modifier.isStatic(n3) || !Modifier.isPublic(n3)) continue;
            Class<?>[] classArray = methodArray[n].getParameterTypes();
            if (classArray.length > 0 && classArray[0].equals(Connection.class)) {
                n2 = 1;
            }
            for (int i = n2; i < classArray.length; ++i) {
                Class<?> clazz2 = classArray[i];
                Type type = Type.getDefaultTypeWithSize(Types.getParameterSQLTypeNumber(clazz2));
                if (type != null) continue;
                method = null;
                break;
            }
            if (method == null) continue;
            if (ResultSet.class.isAssignableFrom(method.getReturnType())) {
                hsqlArrayList.add(methodArray[n]);
                continue;
            }
            Type type = Type.getDefaultTypeWithSize(Types.getParameterSQLTypeNumber(method.getReturnType()));
            if (type == null) continue;
            hsqlArrayList.add(methodArray[n]);
        }
        methodArray = new Method[hsqlArrayList.size()];
        hsqlArrayList.toArray(methodArray);
        return methodArray;
    }

    public static Routine[] newRoutines(Session session, Method[] methodArray) {
        Routine[] routineArray = new Routine[methodArray.length];
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            routineArray[i] = Routine.newRoutine(session, method);
        }
        return routineArray;
    }

    public static Routine newRoutine(Session session, Method method) {
        Routine routine = new Routine(16);
        int n = 0;
        Class<?>[] classArray = method.getParameterTypes();
        String string = method.getDeclaringClass().getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CLASSPATH:");
        stringBuffer.append(method.getDeclaringClass().getName()).append('.');
        stringBuffer.append(method.getName());
        if (classArray.length > 0 && classArray[0].equals(Connection.class)) {
            n = 1;
        }
        String string2 = stringBuffer.toString();
        if (string.equals("java.lang.Math")) {
            routine.isLibraryRoutine = true;
        }
        for (int i = n; i < classArray.length; ++i) {
            Type type = Type.getDefaultTypeWithSize(Types.getParameterSQLTypeNumber(classArray[i]));
            ColumnSchema columnSchema = new ColumnSchema(null, type, !classArray[i].isPrimitive(), false, null);
            routine.addParameter(columnSchema);
        }
        routine.setLanguage(1);
        routine.setMethod(method);
        routine.setMethodURL(string2);
        routine.setDataImpact(1);
        Type type = Type.getDefaultTypeWithSize(Types.getParameterSQLTypeNumber(method.getReturnType()));
        routine.javaMethodWithConnection = n == 1;
        routine.setReturnType(type);
        routine.resolve(session);
        return routine;
    }

    public static void createRoutines(Session session, HsqlNameManager.HsqlName hsqlName, String string) {
        Method[] methodArray = Routine.getMethods(string);
        Routine[] routineArray = Routine.newRoutines(session, methodArray);
        HsqlNameManager.HsqlName hsqlName2 = session.database.nameManager.newHsqlName(hsqlName, string, true, 16);
        for (int i = 0; i < routineArray.length; ++i) {
            routineArray[i].setName(hsqlName2);
            session.database.schemaManager.addSchemaObject(routineArray[i]);
        }
    }

    static void checkNoSQLData(Database database, OrderedHashSet orderedHashSet) {
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
            if (hsqlName.type != 24) continue;
            Routine routine = (Routine)database.schemaManager.getSchemaObject(hsqlName);
            if (routine.dataImpact == 3) {
                throw Error.error(5608, "READS SQL");
            }
            if (routine.dataImpact == 4) {
                throw Error.error(5608, "MODIFIES SQL");
            }
            if (hsqlName.type != 3) continue;
            throw Error.error(5608, "READS SQL");
        }
    }
}

