/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TableDerived;
import org.hsqldb.TriggerDef;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.store.BaseHashMap;
import org.hsqldb.types.Type;

public class StatementDML
extends StatementDMQL {
    Expression updatableTableCheck;
    RangeVariable checkRangeVariable;
    boolean isTruncate;

    public StatementDML(int n, int n2, HsqlNameManager.HsqlName hsqlName) {
        super(n, n2, hsqlName);
    }

    StatementDML(Session session, Table table, RangeVariable[] rangeVariableArray, ParserDQL.CompileContext compileContext, boolean bl, int n) {
        super(19, 2004, session.getCurrentSchemaHsqlName());
        this.targetTable = table;
        this.baseTable = table.getBaseTable() == null ? table : table.getBaseTable();
        this.targetRangeVariables = rangeVariableArray;
        this.restartIdentity = bl;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
        if (n == 1105) {
            this.isTruncate = true;
        }
        this.targetRangeVariables[0].addAllColumns();
    }

    StatementDML(Session session, Table table, RangeVariable[] rangeVariableArray, int[] nArray, Expression[] expressionArray, boolean[] blArray, ParserDQL.CompileContext compileContext) {
        super(82, 2004, session.getCurrentSchemaHsqlName());
        this.targetTable = table;
        this.baseTable = table.getBaseTable() == null ? table : table.getBaseTable();
        this.updateColumnMap = nArray;
        this.updateExpressions = expressionArray;
        this.updateCheckColumns = blArray;
        this.targetRangeVariables = rangeVariableArray;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
        this.setupChecks();
        this.targetRangeVariables[0].addAllColumns();
    }

    StatementDML(Session session, RangeVariable[] rangeVariableArray, int[] nArray, int[] nArray2, boolean[] blArray, Expression expression, Expression expression2, Expression[] expressionArray, ParserDQL.CompileContext compileContext) {
        super(128, 2004, session.getCurrentSchemaHsqlName());
        this.sourceTable = rangeVariableArray[0].rangeTable;
        this.targetTable = rangeVariableArray[1].rangeTable;
        this.baseTable = this.targetTable.getBaseTable() == null ? this.targetTable : this.targetTable.getBaseTable();
        this.insertCheckColumns = blArray;
        this.insertColumnMap = nArray;
        this.updateColumnMap = nArray2;
        this.insertExpression = expression2;
        this.updateExpressions = expressionArray;
        this.targetRangeVariables = rangeVariableArray;
        this.condition = expression;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
        this.setupChecks();
    }

    StatementDML() {
        super(81, 2004, null);
    }

    void setupChecks() {
        if (this.targetTable != this.baseTable) {
            QuerySpecification querySpecification = ((TableDerived)this.targetTable).getQueryExpression().getMainSelect();
            this.updatableTableCheck = querySpecification.checkQueryCondition;
            this.checkRangeVariable = querySpecification.rangeVariables[0];
        }
    }

    @Override
    Result getResult(Session session) {
        Result result = null;
        switch (this.type) {
            case 82: {
                result = this.executeUpdateStatement(session);
                break;
            }
            case 128: {
                result = this.executeMergeStatement(session);
                break;
            }
            case 19: {
                if (this.isTruncate) {
                    result = this.executeDeleteTruncateStatement(session);
                    break;
                }
                result = this.executeDeleteStatement(session);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementDML");
            }
        }
        return result;
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet orderedHashSet) {
        SchemaObject schemaObject;
        int n;
        if (this.baseTable.isView()) {
            this.getTriggerTableNames(orderedHashSet, false);
        } else if (!this.baseTable.isTemp()) {
            for (n = 0; n < this.baseTable.fkConstraints.length; ++n) {
                schemaObject = this.baseTable.fkConstraints[n];
                if (this.type == 82 || this.type == 128) {
                    if (!ArrayUtil.haveCommonElement(((Constraint)schemaObject).getRefColumns(), this.updateColumnMap)) continue;
                    orderedHashSet.add(this.baseTable.fkConstraints[n].getMain().getName());
                    continue;
                }
                if (this.type != 50) continue;
                orderedHashSet.add(this.baseTable.fkConstraints[n].getMain().getName());
            }
            if (this.type == 82 || this.type == 128) {
                this.baseTable.collectFKReadLocks(this.updateColumnMap, orderedHashSet);
            } else if (this.type == 19) {
                this.baseTable.collectFKReadLocks(null, orderedHashSet);
            }
            this.getTriggerTableNames(orderedHashSet, false);
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            schemaObject = this.rangeVariables[n].rangeTable;
            HsqlNameManager.HsqlName hsqlName = ((Table)schemaObject).getName();
            if (((Table)schemaObject).isReadOnly() || ((Table)schemaObject).isTemp() || hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            orderedHashSet.add(hsqlName);
        }
        for (n = 0; n < this.subqueries.length; ++n) {
            if (this.subqueries[n].queryExpression == null) continue;
            this.subqueries[n].queryExpression.getBaseTableNames(orderedHashSet);
        }
        for (n = 0; n < this.routines.length; ++n) {
            orderedHashSet.addAll(this.routines[n].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet orderedHashSet) {
        if (this.baseTable.isView()) {
            this.getTriggerTableNames(orderedHashSet, true);
        } else if (!this.baseTable.isTemp()) {
            orderedHashSet.add(this.baseTable.getName());
            if (this.type == 82 || this.type == 128) {
                this.baseTable.collectFKWriteLocks(this.updateColumnMap, orderedHashSet);
            } else if (this.type == 19) {
                this.baseTable.collectFKWriteLocks(null, orderedHashSet);
            }
            this.getTriggerTableNames(orderedHashSet, true);
        }
    }

    void getTriggerTableNames(OrderedHashSet orderedHashSet, boolean bl) {
        block6: for (int i = 0; i < this.baseTable.triggerList.length; ++i) {
            TriggerDef triggerDef = this.baseTable.triggerList[i];
            switch (this.type) {
                case 50: {
                    if (triggerDef.getStatementType() != 50) continue block6;
                    break;
                }
                case 82: {
                    if (triggerDef.getStatementType() != 82) continue block6;
                    break;
                }
                case 19: {
                    if (triggerDef.getStatementType() != 19) continue block6;
                    break;
                }
                case 128: {
                    if (triggerDef.getStatementType() != 50 && triggerDef.getStatementType() != 82) continue block6;
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "StatementDML");
                }
            }
            if (triggerDef.routine == null) continue;
            if (bl) {
                orderedHashSet.addAll(triggerDef.routine.getTableNamesForWrite());
                continue;
            }
            orderedHashSet.addAll(triggerDef.routine.getTableNamesForRead());
        }
    }

    Result executeUpdateStatement(Session session) {
        int n = 0;
        Expression[] expressionArray = this.updateExpressions;
        RowSetNavigatorDataChange rowSetNavigatorDataChange = new RowSetNavigatorDataChange();
        Type[] typeArray = this.baseTable.getColumnTypes();
        RangeIterator rangeIterator = RangeVariable.getIterator(session, this.targetRangeVariables);
        while (rangeIterator.next()) {
            session.sessionData.startRowProcessing();
            Row row = rangeIterator.getCurrentRow();
            Object[] objectArray = row.getData();
            Object[] objectArray2 = StatementDML.getUpdatedData(session, this.baseTable, this.updateColumnMap, expressionArray, typeArray, objectArray);
            if (this.updatableTableCheck != null) {
                rangeIterator.setCurrent(objectArray2);
                boolean bl = this.updatableTableCheck.testCondition(session);
                if (!bl) {
                    throw Error.error(5700);
                }
            }
            rowSetNavigatorDataChange.addRow(session, row, objectArray2, typeArray, this.updateColumnMap);
        }
        rowSetNavigatorDataChange.beforeFirst();
        if (rowSetNavigatorDataChange.getSize() <= 0) {
            return Result.updateZeroResult;
        }
        n = this.update(session, this.baseTable, rowSetNavigatorDataChange);
        if (n == 1) {
            return Result.updateOneResult;
        }
        return new Result(1, n);
    }

    static Object[] getUpdatedData(Session session, Table table, int[] nArray, Expression[] expressionArray, Type[] typeArray, Object[] objectArray) {
        Object[] objectArray2 = table.getEmptyRowData();
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
        int n = 0;
        int n2 = 0;
        while (n < nArray.length) {
            Object object;
            int n3;
            int n4;
            Expression expression;
            if ((expression = expressionArray[n2++]).getType() == 25) {
                Object[] objectArray3 = expression.getRowValue(session);
                n4 = 0;
                while (n4 < objectArray3.length) {
                    n3 = nArray[n];
                    object = expression.nodes[n4];
                    if (table.identityColumn != n3 || ((Expression)object).getType() != 1 || ((Expression)object).valueData != null) {
                        if (((Expression)object).getType() == 4) {
                            if (table.identityColumn != n3) {
                                objectArray2[n3] = table.colDefaults[n3].getValue(session);
                            }
                        } else {
                            objectArray2[n3] = typeArray[n3].convertToType(session, objectArray3[n4], ((Expression)object).dataType);
                        }
                    }
                    ++n4;
                    ++n;
                }
                continue;
            }
            if (expression.getType() == 22) {
                Object[] objectArray4 = expression.getRowValue(session);
                n4 = 0;
                while (n4 < objectArray4.length) {
                    n3 = nArray[n];
                    object = expression.subQuery.queryExpression.getMetaData().columnTypes[n4];
                    objectArray2[n3] = typeArray[n3].convertToType(session, objectArray4[n4], (Type)object);
                    ++n4;
                    ++n;
                }
                continue;
            }
            int n5 = nArray[n];
            if (expression.getType() == 4) {
                if (table.identityColumn == n5) {
                    ++n;
                    continue;
                }
                objectArray2[n5] = table.colDefaults[n5].getValue(session);
                ++n;
                continue;
            }
            objectArray2[n5] = expression.getValue(session, typeArray[n5]);
            ++n;
        }
        return objectArray2;
    }

    Result executeMergeStatement(Session session) {
        int n;
        Type[] typeArray = this.baseTable.getColumnTypes();
        Result result = null;
        RowSetNavigator rowSetNavigator = null;
        if (this.generatedIndexes != null) {
            result = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            rowSetNavigator = result.getChainedResult().getNavigator();
        }
        int n2 = 0;
        RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient(8);
        RowSetNavigatorDataChange rowSetNavigatorDataChange = new RowSetNavigatorDataChange();
        RangeVariable[] rangeVariableArray = this.targetRangeVariables;
        RangeIterator[] rangeIteratorArray = new RangeIterator[rangeVariableArray.length];
        for (n = 0; n < rangeVariableArray.length; ++n) {
            rangeIteratorArray[n] = rangeVariableArray[n].getIterator(session);
        }
        n = 0;
        while (n >= 0) {
            Object[] objectArray;
            RangeIterator rangeIterator = rangeIteratorArray[n];
            boolean bl = rangeIterator.isBeforeFirst();
            if (rangeIterator.next()) {
                if (n < rangeVariableArray.length - 1) {
                    ++n;
                    continue;
                }
            } else {
                if (n == 1 && bl && this.insertExpression != null && (objectArray = this.getInsertData(session, typeArray, this.insertExpression.nodes[0].nodes)) != null) {
                    rowSetNavigatorClient.add(objectArray);
                }
                rangeIterator.reset();
                --n;
                continue;
            }
            if (this.updateExpressions == null) continue;
            objectArray = rangeIterator.getCurrentRow();
            Object[] objectArray2 = StatementDML.getUpdatedData(session, this.baseTable, this.updateColumnMap, this.updateExpressions, typeArray, objectArray.getData());
            try {
                rowSetNavigatorDataChange.addRow(session, (Row)objectArray, objectArray2, typeArray, this.updateColumnMap);
            }
            catch (HsqlException hsqlException) {
                throw Error.error(3201);
            }
        }
        if (rowSetNavigatorDataChange.getSize() > 0) {
            n2 = this.update(session, this.baseTable, rowSetNavigatorDataChange);
        }
        if (rowSetNavigatorClient.getSize() > 0) {
            this.insertRowSet(session, rowSetNavigator, rowSetNavigatorClient);
            n2 += rowSetNavigatorClient.getSize();
        }
        if (result == null) {
            if (n2 == 1) {
                return Result.updateOneResult;
            }
            return new Result(1, n2);
        }
        result.setUpdateCount(n2);
        return result;
    }

    void insertRowSet(Session session, RowSetNavigator rowSetNavigator, RowSetNavigator rowSetNavigator2) {
        Object[] objectArray;
        PersistentStore persistentStore = session.sessionData.getRowStore(this.baseTable);
        RangeVariable.RangeIteratorMain rangeIteratorMain = null;
        if (this.updatableTableCheck != null) {
            rangeIteratorMain = this.checkRangeVariable.getIterator(session);
        }
        rowSetNavigator2.beforeFirst();
        if (this.baseTable.triggerLists[6].length > 0) {
            while (rowSetNavigator2.hasNext()) {
                objectArray = rowSetNavigator2.getNext();
                this.baseTable.fireTriggers(session, 6, null, objectArray, null);
            }
            rowSetNavigator2.beforeFirst();
        }
        while (rowSetNavigator2.hasNext()) {
            objectArray = rowSetNavigator2.getNext();
            this.baseTable.insertSingleRow(session, persistentStore, objectArray, null);
            if (rangeIteratorMain != null) {
                rangeIteratorMain.setCurrent(objectArray);
                boolean bl = this.updatableTableCheck.testCondition(session);
                if (!bl) {
                    throw Error.error(5700);
                }
            }
            if (rowSetNavigator == null) continue;
            Object[] objectArray2 = this.getGeneratedColumns(objectArray);
            rowSetNavigator.add(objectArray2);
        }
        rowSetNavigator2.beforeFirst();
        while (rowSetNavigator2.hasNext()) {
            objectArray = rowSetNavigator2.getNext();
            StatementDML.performIntegrityChecks(session, this.baseTable, null, objectArray);
        }
        rowSetNavigator2.beforeFirst();
        if (this.baseTable.triggerLists[3].length > 0) {
            while (rowSetNavigator2.hasNext()) {
                objectArray = rowSetNavigator2.getNext();
                this.baseTable.fireTriggers(session, 3, null, objectArray, null);
            }
            rowSetNavigator2.beforeFirst();
        }
        if (this.baseTable.triggerLists[0].length > 0) {
            this.baseTable.fireTriggers(session, 0, rowSetNavigator2);
        }
    }

    Result insertSingleRow(Session session, PersistentStore persistentStore, Object[] objectArray) {
        if (this.baseTable.triggerLists[6].length > 0) {
            this.baseTable.fireTriggers(session, 6, null, objectArray, null);
        }
        this.baseTable.insertSingleRow(session, persistentStore, objectArray, null);
        StatementDML.performIntegrityChecks(session, this.baseTable, null, objectArray);
        if (session.database.isReferentialIntegrity()) {
            int n = this.baseTable.fkConstraints.length;
            for (int i = 0; i < n; ++i) {
                this.baseTable.fkConstraints[i].checkInsert(session, this.baseTable, objectArray, true);
            }
        }
        if (this.baseTable.triggerLists[3].length > 0) {
            this.baseTable.fireTriggers(session, 3, null, objectArray, null);
        }
        if (this.baseTable.triggerLists[0].length > 0) {
            this.baseTable.fireTriggers(session, 0, null, null, null);
        }
        return Result.updateOneResult;
    }

    Object[] getInsertData(Session session, Type[] typeArray, Expression[] expressionArray) {
        Object[] objectArray = this.baseTable.getNewRowData(session);
        session.sessionData.startRowProcessing();
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression expression = expressionArray[i];
            int n = this.insertColumnMap[i];
            if (expression.opType == 4) {
                if (this.baseTable.identityColumn == n || this.baseTable.colDefaults[n] == null) continue;
                objectArray[n] = this.baseTable.colDefaults[n].getValue(session);
                continue;
            }
            Object object = expression.getValue(session);
            Type type = typeArray[n];
            if (typeArray[n] != expression.dataType) {
                object = type.convertToType(session, object, expression.dataType);
            }
            objectArray[n] = object;
        }
        return objectArray;
    }

    int update(Session session, Table table, RowSetNavigatorDataChange rowSetNavigatorDataChange) {
        int n;
        Object object;
        Object object2;
        Object[] objectArray;
        Object object3;
        Object[] objectArray2;
        int n2;
        int n3 = rowSetNavigatorDataChange.getSize();
        for (n2 = 0; n2 < n3; ++n2) {
            rowSetNavigatorDataChange.next();
            Object[] objectArray3 = rowSetNavigatorDataChange.getCurrentChangedData();
            table.setIdentityColumn(session, objectArray3);
            table.setGeneratedColumns(session, objectArray3);
        }
        rowSetNavigatorDataChange.beforeFirst();
        if (table.fkMainConstraints.length > 0) {
            HashSet hashSet = session.sessionContext.getConstraintPath();
            for (int i = 0; i < n3; ++i) {
                objectArray2 = rowSetNavigatorDataChange.getNextRow();
                object3 = rowSetNavigatorDataChange.getCurrentChangedData();
                StatementDML.performReferentialActions(session, table, rowSetNavigatorDataChange, (Row)objectArray2, (Object[])object3, this.updateColumnMap, hashSet);
                hashSet.clear();
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        for (n2 = 0; n2 < rowSetNavigatorDataChange.getSize(); ++n2) {
            Row row = rowSetNavigatorDataChange.getNextRow();
            objectArray2 = rowSetNavigatorDataChange.getCurrentChangedData();
            object3 = rowSetNavigatorDataChange.getCurrentChangedColumns();
            objectArray = (Table)row.getTable();
            if (objectArray.triggerLists[8].length <= 0) continue;
            objectArray.fireTriggers(session, 8, row.getData(), objectArray2, (int[])object3);
            objectArray.enforceRowConstraints(session, objectArray2);
        }
        if (table.isView) {
            return n3;
        }
        rowSetNavigatorDataChange.beforeFirst();
        for (n2 = 0; n2 < rowSetNavigatorDataChange.getSize(); ++n2) {
            Row row = rowSetNavigatorDataChange.getNextRow();
            objectArray2 = (Table)row.getTable();
            object3 = rowSetNavigatorDataChange.getCurrentChangedColumns();
            session.addDeleteAction((Table)objectArray2, row, (int[])object3);
        }
        rowSetNavigatorDataChange.beforeFirst();
        for (n2 = 0; n2 < rowSetNavigatorDataChange.getSize(); ++n2) {
            Row row = rowSetNavigatorDataChange.getNextRow();
            objectArray2 = rowSetNavigatorDataChange.getCurrentChangedData();
            object3 = (Table)row.getTable();
            objectArray = rowSetNavigatorDataChange.getCurrentChangedColumns();
            object2 = session.sessionData.getRowStore((TableBase)object3);
            if (objectArray2 == null) continue;
            object = ((Table)object3).insertSingleRow(session, (PersistentStore)object2, objectArray2, (int[])objectArray);
        }
        rowSetNavigatorDataChange.beforeFirst();
        BaseHashMap baseHashMap = null;
        boolean bl = table.triggerLists[5].length > 0;
        for (n = 0; n < rowSetNavigatorDataChange.getSize(); ++n) {
            object3 = rowSetNavigatorDataChange.getNextRow();
            objectArray = rowSetNavigatorDataChange.getCurrentChangedData();
            object2 = (Table)((Row)object3).getTable();
            StatementDML.performIntegrityChecks(session, (Table)object2, ((Row)object3).getData(), objectArray);
            if (object2 == table) continue;
            if (baseHashMap == null) {
                baseHashMap = new OrderedHashSet();
            }
            ((HashSet)baseHashMap).add(object2);
            if (((Table)object2).triggerLists[5].length <= 0) continue;
            bl = true;
        }
        rowSetNavigatorDataChange.beforeFirst();
        if (bl) {
            for (n = 0; n < rowSetNavigatorDataChange.getSize(); ++n) {
                object3 = rowSetNavigatorDataChange.getNextRow();
                objectArray = rowSetNavigatorDataChange.getCurrentChangedData();
                object2 = rowSetNavigatorDataChange.getCurrentChangedColumns();
                object = (Table)((Row)object3).getTable();
                ((Table)object).fireTriggers(session, 5, ((Row)object3).getData(), objectArray, (int[])object2);
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        this.baseTable.fireTriggers(session, 2, rowSetNavigatorDataChange);
        if (baseHashMap != null) {
            for (n = 0; n < baseHashMap.size(); ++n) {
                object3 = (Table)((OrderedHashSet)baseHashMap).get(n);
                ((Table)object3).fireTriggers(session, 2, rowSetNavigatorDataChange);
            }
        }
        return n3;
    }

    Result executeDeleteStatement(Session session) {
        int n = 0;
        RangeIterator rangeIterator = RangeVariable.getIterator(session, this.targetRangeVariables);
        RowSetNavigatorDataChange rowSetNavigatorDataChange = new RowSetNavigatorDataChange();
        while (rangeIterator.next()) {
            Row row = rangeIterator.getCurrentRow();
            rowSetNavigatorDataChange.addRow(row);
        }
        if (rowSetNavigatorDataChange.getSize() <= 0) {
            return Result.updateZeroResult;
        }
        n = this.delete(session, this.baseTable, rowSetNavigatorDataChange);
        if (n == 1) {
            return Result.updateOneResult;
        }
        return new Result(1, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result executeDeleteTruncateStatement(Session session) {
        PersistentStore persistentStore = session.sessionData.getRowStore(this.targetTable);
        RowIterator rowIterator = this.targetTable.getPrimaryIndex().firstRow(persistentStore, true);
        try {
            while (rowIterator.hasNext()) {
                Row row = rowIterator.getNextRow();
                session.addDeleteAction((Table)row.getTable(), row, null);
            }
            if (this.restartIdentity && this.targetTable.identitySequence != null) {
                this.targetTable.identitySequence.reset();
            }
        }
        finally {
            rowIterator.release();
        }
        return Result.updateOneResult;
    }

    int delete(Session session, Table table, RowSetNavigatorDataChange rowSetNavigatorDataChange) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Object[] objectArray;
        Object object4;
        int n;
        Object object5;
        int n2 = rowSetNavigatorDataChange.getSize();
        rowSetNavigatorDataChange.beforeFirst();
        if (table.fkMainConstraints.length > 0) {
            object5 = session.sessionContext.getConstraintPath();
            for (n = 0; n < n2; ++n) {
                rowSetNavigatorDataChange.next();
                object4 = rowSetNavigatorDataChange.getCurrentRow();
                StatementDML.performReferentialActions(session, table, rowSetNavigatorDataChange, (Row)object4, null, null, (HashSet)object5);
                ((BaseHashMap)object5).clear();
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        while (rowSetNavigatorDataChange.hasNext()) {
            rowSetNavigatorDataChange.next();
            object5 = rowSetNavigatorDataChange.getCurrentRow();
            Object[] objectArray2 = rowSetNavigatorDataChange.getCurrentChangedData();
            object4 = rowSetNavigatorDataChange.getCurrentChangedColumns();
            objectArray = (Object[])((Row)object5).getTable();
            if (objectArray2 == null) {
                objectArray.fireTriggers(session, 7, ((Row)object5).getData(), null, null);
                continue;
            }
            objectArray.fireTriggers(session, 8, ((Row)object5).getData(), objectArray2, (int[])object4);
        }
        if (table.isView) {
            return n2;
        }
        rowSetNavigatorDataChange.beforeFirst();
        boolean bl2 = false;
        for (n = 0; n < rowSetNavigatorDataChange.getSize(); ++n) {
            object4 = rowSetNavigatorDataChange.getNextRow();
            objectArray = rowSetNavigatorDataChange.getCurrentChangedData();
            object3 = (Table)((Row)object4).getTable();
            session.addDeleteAction((Table)object3, (Row)object4, null);
            if (objectArray == null) continue;
            bl2 = true;
        }
        rowSetNavigatorDataChange.beforeFirst();
        if (bl2) {
            for (n = 0; n < rowSetNavigatorDataChange.getSize(); ++n) {
                object4 = rowSetNavigatorDataChange.getNextRow();
                objectArray = rowSetNavigatorDataChange.getCurrentChangedData();
                object3 = (Table)((Row)object4).getTable();
                object2 = rowSetNavigatorDataChange.getCurrentChangedColumns();
                object = session.sessionData.getRowStore((TableBase)object3);
                if (objectArray == null) continue;
                Row row = ((Table)object3).insertSingleRow(session, (PersistentStore)object, objectArray, (int[])object2);
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        BaseHashMap baseHashMap = null;
        object4 = null;
        boolean bl3 = bl = table.triggerLists[4].length > 0;
        if (n2 != rowSetNavigatorDataChange.getSize()) {
            while (rowSetNavigatorDataChange.hasNext()) {
                rowSetNavigatorDataChange.next();
                object3 = rowSetNavigatorDataChange.getCurrentRow();
                object2 = rowSetNavigatorDataChange.getCurrentChangedData();
                object = (Table)((Row)object3).getTable();
                if (object2 != null) {
                    StatementDML.performIntegrityChecks(session, (Table)object, ((Row)object3).getData(), (Object[])object2);
                }
                if (object == table) continue;
                if (object2 == null) {
                    if (((Table)object).triggerLists[4].length > 0) {
                        bl = true;
                    }
                    if (object4 == null) {
                        object4 = new OrderedHashSet();
                    }
                    ((HashSet)object4).add(object);
                    continue;
                }
                if (((Table)object).triggerLists[5].length > 0) {
                    bl = true;
                }
                if (baseHashMap == null) {
                    baseHashMap = new OrderedHashSet();
                }
                ((HashSet)baseHashMap).add(object);
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        if (bl) {
            while (rowSetNavigatorDataChange.hasNext()) {
                rowSetNavigatorDataChange.next();
                object3 = rowSetNavigatorDataChange.getCurrentRow();
                object2 = rowSetNavigatorDataChange.getCurrentChangedData();
                object = (Table)((Row)object3).getTable();
                if (object2 == null) {
                    ((Table)object).fireTriggers(session, 4, ((Row)object3).getData(), null, null);
                    continue;
                }
                ((Table)object).fireTriggers(session, 5, ((Row)object3).getData(), (Object[])object2, null);
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        table.fireTriggers(session, 1, rowSetNavigatorDataChange);
        if (baseHashMap != null) {
            for (int i = 0; i < baseHashMap.size(); ++i) {
                object2 = (Table)((OrderedHashSet)baseHashMap).get(i);
                ((Table)object2).fireTriggers(session, 2, rowSetNavigatorDataChange);
            }
        }
        if (object4 != null) {
            for (int i = 0; i < ((BaseHashMap)object4).size(); ++i) {
                object2 = (Table)((OrderedHashSet)object4).get(i);
                ((Table)object2).fireTriggers(session, 1, rowSetNavigatorDataChange);
            }
        }
        return n2;
    }

    static void performIntegrityChecks(Session session, Table table, Object[] objectArray, Object[] objectArray2) {
        int n = table.checkConstraints.length;
        for (int i = 0; i < n; ++i) {
            table.checkConstraints[i].checkInsert(session, table, objectArray2, objectArray == null);
        }
        if (!session.database.isReferentialIntegrity()) {
            return;
        }
        for (Constraint constraint : table.fkConstraints) {
            boolean bl;
            Type[] typeArray = table.getColumnTypes();
            if (objectArray == null) {
                bl = true;
            } else if (objectArray2 == null) {
                bl = false;
            } else {
                bl = false;
                for (int i = 0; i < typeArray.length; ++i) {
                    if (typeArray[i].compare(session, objectArray2[i], objectArray[i]) == 0) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) continue;
            constraint.checkInsert(session, table, objectArray2, objectArray == null);
        }
    }

    static void performReferentialActions(Session session, Table table, RowSetNavigatorDataChange rowSetNavigatorDataChange, Row row, Object[] objectArray, int[] nArray, HashSet hashSet) {
        if (!session.database.isReferentialIntegrity()) {
            return;
        }
        boolean bl = objectArray == null;
        block6: for (Constraint constraint : table.fkMainConstraints) {
            RowIterator rowIterator;
            int n;
            int n2 = n = bl ? constraint.core.deleteAction : constraint.core.updateAction;
            if (!bl && (!ArrayUtil.haveCommonElement(nArray, constraint.core.mainCols) || constraint.core.mainIndex.compareRowNonUnique(session, row.getData(), constraint.core.mainCols, objectArray) == 0) || !(rowIterator = constraint.findFkRef(session, row.getData())).hasNext()) continue;
            block7: while (rowIterator.hasNext()) {
                Row row2 = rowIterator.getNextRow();
                Object[] objectArray2 = null;
                if (constraint.core.refIndex.compareRowNonUnique(session, row.getData(), constraint.core.mainCols, row2.getData()) != 0) continue block6;
                if (bl && row2.getId() == row.getId()) continue;
                switch (n) {
                    case 0: {
                        int n3;
                        if (bl) {
                            if (!rowSetNavigatorDataChange.addRow(row2)) continue block7;
                            StatementDML.performReferentialActions(session, constraint.core.refTable, rowSetNavigatorDataChange, row2, null, null, hashSet);
                            continue block7;
                        }
                        objectArray2 = constraint.core.refTable.getEmptyRowData();
                        System.arraycopy(row2.getData(), 0, objectArray2, 0, objectArray2.length);
                        for (n3 = 0; n3 < constraint.core.refCols.length; ++n3) {
                            objectArray2[constraint.core.refCols[n3]] = objectArray[constraint.core.mainCols[n3]];
                        }
                        break;
                    }
                    case 2: {
                        int n3;
                        objectArray2 = constraint.core.refTable.getEmptyRowData();
                        System.arraycopy(row2.getData(), 0, objectArray2, 0, objectArray2.length);
                        for (n3 = 0; n3 < constraint.core.refCols.length; ++n3) {
                            objectArray2[constraint.core.refCols[n3]] = null;
                        }
                        break;
                    }
                    case 4: {
                        Object[] objectArray3;
                        int n3;
                        objectArray2 = constraint.core.refTable.getEmptyRowData();
                        System.arraycopy(row2.getData(), 0, objectArray2, 0, objectArray2.length);
                        for (n3 = 0; n3 < constraint.core.refCols.length; ++n3) {
                            objectArray3 = constraint.core.refTable.getColumn(constraint.core.refCols[n3]);
                            objectArray2[constraint.core.refCols[n3]] = objectArray3.getDefaultValue(session);
                        }
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (rowSetNavigatorDataChange.containsDeletedRow(row2)) continue block7;
                        int n3 = constraint.core.deleteAction == 3 ? 8 : 3501;
                        Object[] objectArray3 = new String[]{constraint.core.refName.name, constraint.core.refTable.getName().name};
                        throw Error.error(null, n3, 2, objectArray3);
                    }
                    default: {
                        continue block7;
                    }
                }
                objectArray2 = rowSetNavigatorDataChange.addRow(session, row2, objectArray2, table.getColumnTypes(), constraint.core.refCols);
                if (!hashSet.add(constraint)) continue;
                StatementDML.performReferentialActions(session, constraint.core.refTable, rowSetNavigatorDataChange, row2, objectArray2, constraint.core.refCols, hashSet);
                hashSet.remove(constraint);
            }
        }
    }
}

