/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.StatementDML;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class StatementResultUpdate
extends StatementDML {
    int actionType;
    Type[] types;
    Result result;

    StatementResultUpdate() {
        this.isTransactionStatement = true;
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public Result execute(Session session) {
        try {
            return this.getResult(session);
        }
        catch (Throwable throwable) {
            return Result.newErrorResult(throwable, null);
        }
    }

    @Override
    Result getResult(Session session) {
        this.checkAccessRights(session);
        Object[] objectArray = session.sessionContext.dynamicArguments;
        PersistentStore persistentStore = session.sessionData.getRowStore(this.baseTable);
        switch (this.actionType) {
            case 81: {
                Row row = this.getRow(session, objectArray);
                if (row == null || row.isDeleted(session, persistentStore)) {
                    throw Error.error(3621);
                }
                RowSetNavigatorDataChange rowSetNavigatorDataChange = new RowSetNavigatorDataChange();
                Object[] objectArray2 = (Object[])ArrayUtil.duplicateArray(row.getData());
                boolean[] blArray = this.baseTable.getNewColumnCheckList();
                for (int i = 0; i < this.baseColumnMap.length; ++i) {
                    if (this.types[i] == Type.SQL_ALL_TYPES) continue;
                    objectArray2[this.baseColumnMap[i]] = objectArray[i];
                    blArray[this.baseColumnMap[i]] = true;
                }
                int[] nArray = ArrayUtil.booleanArrayToIntIndexes(blArray);
                rowSetNavigatorDataChange.addRow(session, row, objectArray2, this.baseTable.getColumnTypes(), nArray);
                this.update(session, this.baseTable, rowSetNavigatorDataChange);
                break;
            }
            case 18: {
                Row row = this.getRow(session, objectArray);
                if (row == null || row.isDeleted(session, persistentStore)) {
                    throw Error.error(3621);
                }
                RowSetNavigatorDataChange rowSetNavigatorDataChange = new RowSetNavigatorDataChange();
                rowSetNavigatorDataChange.addRow(row);
                this.delete(session, this.baseTable, rowSetNavigatorDataChange);
                break;
            }
            case 50: {
                Object[] objectArray3 = this.baseTable.getNewRowData(session);
                for (int i = 0; i < objectArray3.length; ++i) {
                    objectArray3[this.baseColumnMap[i]] = objectArray[i];
                }
                return this.insertSingleRow(session, persistentStore, objectArray3);
            }
        }
        return Result.updateOneResult;
    }

    Row getRow(Session session, Object[] objectArray) {
        int n = this.result.metaData.getColumnCount();
        Long l = (Long)objectArray[n];
        PersistentStore persistentStore = session.sessionData.getRowStore(this.baseTable);
        Row row = null;
        if (n + 2 == this.result.metaData.getExtendedColumnCount()) {
            Object[] objectArray2 = ((RowSetNavigatorData)this.result.getNavigator()).getData(l);
            if (objectArray2 != null) {
                row = (Row)objectArray2[n + 1];
            }
        } else {
            int n2 = (int)l.longValue();
            row = (Row)persistentStore.get(n2, false);
        }
        this.result = null;
        return row;
    }

    void setRowActionProperties(Result result, int n, Table table, Type[] typeArray, int[] nArray) {
        this.result = result;
        this.actionType = n;
        this.baseTable = table;
        this.types = typeArray;
        this.baseColumnMap = nArray;
    }

    @Override
    void checkAccessRights(Session session) {
        switch (this.type) {
            case 7: {
                break;
            }
            case 50: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                break;
            }
            case 85: {
                break;
            }
            case 19: {
                session.getGrantee().checkDelete(this.targetTable);
                break;
            }
            case 82: {
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
                break;
            }
            case 128: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
            }
        }
    }
}

