/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.StatementDML;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class StatementSet
extends StatementDMQL {
    Expression expression;
    ColumnSchema[] variables;
    int[] variableIndexes;
    Type[] sourceTypes;
    final int operationType;
    public static final int TRIGGER_SET = 1;
    public static final int SELECT_INTO = 2;
    public static final int VARIABLE_SET = 3;

    StatementSet(Session session, Table table, RangeVariable[] rangeVariableArray, int[] nArray, Expression[] expressionArray, ParserDQL.CompileContext compileContext) {
        super(5, 2004, session.getCurrentSchemaHsqlName());
        this.operationType = 1;
        this.targetTable = table;
        this.baseTable = this.targetTable.getBaseTable();
        this.updateColumnMap = nArray;
        this.updateExpressions = expressionArray;
        this.updateCheckColumns = this.targetTable.getColumnCheckList(nArray);
        this.targetRangeVariables = rangeVariableArray;
        this.isTransactionStatement = false;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
    }

    StatementSet(Session session, ParserDQL.CompileContext compileContext, ColumnSchema[] columnSchemaArray, Expression expression, int[] nArray) {
        super(5, 2007, null);
        this.operationType = 3;
        this.isTransactionStatement = false;
        this.expression = expression;
        this.variables = columnSchemaArray;
        this.variableIndexes = nArray;
        this.sourceTypes = this.expression.getNodeDataTypes();
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
    }

    StatementSet(Session session, ParserDQL.CompileContext compileContext, ColumnSchema[] columnSchemaArray, QueryExpression queryExpression, int[] nArray) {
        super(5, 2007, null);
        this.operationType = 2;
        this.isTransactionStatement = false;
        this.queryExpression = queryExpression;
        this.variables = columnSchemaArray;
        this.variableIndexes = nArray;
        this.sourceTypes = queryExpression.getColumnTypes();
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
    }

    @Override
    Result getResult(Session session) {
        Result result = null;
        switch (this.operationType) {
            case 1: {
                result = this.executeSetStatement(session);
                break;
            }
            case 2: {
                Object[] objectArray = this.queryExpression.getSingleRowValues(session);
                if (objectArray == null) {
                    result = Result.updateZeroResult;
                    break;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = this.variables[i].getDataType().convertToType(session, objectArray[i], this.sourceTypes[i]);
                }
                result = this.executeAssignment(session, objectArray);
                break;
            }
            case 3: {
                Object[] objectArray = this.getExpressionValues(session);
                if (objectArray == null) {
                    result = Result.updateZeroResult;
                    break;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = this.variables[i].getDataType().convertToType(session, objectArray[i], this.sourceTypes[i]);
                }
                result = this.executeAssignment(session, objectArray);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSet");
            }
        }
        return result;
    }

    @Override
    public void resolve(Session session) {
        this.references = new OrderedHashSet();
        switch (this.operationType) {
            case 1: {
                for (int i = 0; i < this.updateExpressions.length; ++i) {
                    this.updateExpressions[i].collectObjectNames(this.references);
                }
                break;
            }
            case 2: 
            case 3: {
                if (this.expression != null) {
                    this.expression.collectObjectNames(this.references);
                }
                if (this.queryExpression == null) break;
                this.queryExpression.collectObjectNames(this.references);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSet");
            }
        }
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.operationType) {
            case 1: {
                return this.sql;
            }
            case 3: {
                stringBuffer.append("SET").append(' ');
                stringBuffer.append(this.variables[0].getName().statementName).append(' ');
                stringBuffer.append('=').append(' ').append(this.expression.getSQL());
            }
        }
        return stringBuffer.toString();
    }

    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("STATEMENT");
        return stringBuffer.toString();
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            if (this.subqueries.length > 0) {
                this.materializeSubQueries(session);
            }
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    Result executeSetStatement(Session session) {
        Table table = this.targetTable;
        int[] nArray = this.updateColumnMap;
        Expression[] expressionArray = this.updateExpressions;
        Type[] typeArray = table.getColumnTypes();
        int n = this.targetRangeVariables[1].rangePosition;
        Object[] objectArray = session.sessionContext.rangeIterators[n].getCurrent();
        Object[] objectArray2 = StatementDML.getUpdatedData(session, table, nArray, expressionArray, typeArray, objectArray);
        ArrayUtil.copyArray(objectArray2, objectArray, objectArray2.length);
        return Result.updateOneResult;
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet orderedHashSet) {
        int n;
        for (n = 0; n < this.rangeVariables.length; ++n) {
            Table table = this.rangeVariables[n].rangeTable;
            HsqlNameManager.HsqlName hsqlName = table.getName();
            if (table.isReadOnly() || table.isTemp() || hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            orderedHashSet.add(hsqlName);
        }
        for (n = 0; n < this.subqueries.length; ++n) {
            if (this.subqueries[n].queryExpression == null) continue;
            this.subqueries[n].queryExpression.getBaseTableNames(orderedHashSet);
        }
        for (n = 0; n < this.routines.length; ++n) {
            orderedHashSet.addAll(this.routines[n].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet orderedHashSet) {
    }

    Object[] getExpressionValues(Session session) {
        Object[] objectArray;
        if (this.expression.getType() == 25) {
            objectArray = this.expression.getRowValue(session);
        } else if (this.expression.getType() == 22) {
            objectArray = this.expression.subQuery.queryExpression.getSingleRowValues(session);
            if (objectArray == null) {
                return null;
            }
        } else {
            objectArray = new Object[]{this.expression.getValue(session)};
        }
        return objectArray;
    }

    Result executeAssignment(Session session, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = ValuePool.emptyObjectArray;
            switch (this.variables[i].getType()) {
                case 23: {
                    objectArray2 = session.sessionContext.routineArguments;
                    break;
                }
                case 22: {
                    objectArray2 = session.sessionContext.routineVariables;
                }
            }
            int n = this.variableIndexes[i];
            objectArray2[n] = objectArray[i];
        }
        return Result.updateZeroResult;
    }
}

