/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

abstract class RowInputBase
extends HsqlByteArrayInputStream {
    static final int NO_POS = -1;
    protected int filePos = -1;
    protected int size;

    RowInputBase() {
        this(new byte[4]);
    }

    RowInputBase(byte[] byArray) {
        super(byArray);
        this.size = byArray.length;
    }

    public int getPos() {
        if (this.filePos == -1) {
            // empty if block
        }
        return this.filePos;
    }

    public int getSize() {
        return this.size;
    }

    public abstract int readType() throws IOException;

    public abstract String readString() throws IOException;

    protected abstract boolean checkNull() throws IOException;

    protected abstract String readChar(Type var1) throws IOException;

    protected abstract Integer readSmallint() throws IOException;

    protected abstract Integer readInteger() throws IOException;

    protected abstract Long readBigint() throws IOException;

    protected abstract Double readReal() throws IOException;

    protected abstract BigDecimal readDecimal(Type var1) throws IOException;

    protected abstract Boolean readBoole() throws IOException;

    protected abstract TimeData readTime(Type var1) throws IOException;

    protected abstract TimestampData readDate(Type var1) throws IOException;

    protected abstract TimestampData readTimestamp(Type var1) throws IOException;

    protected abstract IntervalMonthData readYearMonthInterval(Type var1) throws IOException;

    protected abstract IntervalSecondData readDaySecondInterval(Type var1) throws IOException;

    protected abstract Object readOther() throws IOException;

    protected abstract BinaryData readBinary() throws IOException, HsqlException;

    protected abstract BinaryData readBit() throws IOException;

    protected abstract ClobData readClob() throws IOException;

    protected abstract BlobData readBlob() throws IOException;

    public Object[] readData(Type[] typeArray) throws IOException, HsqlException {
        int n = typeArray.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            if (this.checkNull()) continue;
            Object object = null;
            Type type = typeArray[i];
            switch (type.typeCode) {
                case 0: {
                    break;
                }
                case 1: 
                case 12: 
                case 100: {
                    object = this.readChar(type);
                    break;
                }
                case -6: 
                case 5: {
                    object = this.readSmallint();
                    break;
                }
                case 4: {
                    object = this.readInteger();
                    break;
                }
                case 25: {
                    object = this.readBigint();
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    object = this.readReal();
                    break;
                }
                case 2: 
                case 3: {
                    object = this.readDecimal(type);
                    break;
                }
                case 91: {
                    object = this.readDate(type);
                    break;
                }
                case 92: 
                case 94: {
                    object = this.readTime(type);
                    break;
                }
                case 93: 
                case 95: {
                    object = this.readTimestamp(type);
                    break;
                }
                case 101: 
                case 102: 
                case 107: {
                    object = this.readYearMonthInterval(type);
                    break;
                }
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: {
                    object = this.readDaySecondInterval(type);
                    break;
                }
                case 16: {
                    object = this.readBoole();
                    break;
                }
                case 1111: {
                    object = this.readOther();
                    break;
                }
                case 40: {
                    object = this.readClob();
                    break;
                }
                case 30: {
                    object = this.readBlob();
                    break;
                }
                case 60: 
                case 61: {
                    object = this.readBinary();
                    break;
                }
                case 14: 
                case 15: {
                    object = this.readBit();
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "RowInputBase - " + type.getNameString());
                }
            }
            objectArray[i] = object;
        }
        return objectArray;
    }

    public void resetRow(int n, int n2) throws IOException {
        this.mark = 0;
        this.reset();
        if (this.buffer.length < n2) {
            this.buffer = new byte[n2];
        }
        this.filePos = n;
        this.size = this.count = n2;
        this.pos = 4;
        this.buffer[0] = (byte)(n2 >>> 24 & 0xFF);
        this.buffer[1] = (byte)(n2 >>> 16 & 0xFF);
        this.buffer[2] = (byte)(n2 >>> 8 & 0xFF);
        this.buffer[3] = (byte)(n2 >>> 0 & 0xFF);
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        throw Error.runtimeError(201, "RowInputBase");
    }

    @Override
    public String readLine() throws IOException {
        throw Error.runtimeError(201, "RowInputBase");
    }
}

