/*
 * Decompiled with CFR 0.152.
 */
package rcon;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.EnumSet;
import org.apache.log4j.Logger;
import rcon.DaemonConfiguration;
import rcon.client.ClientHandler;
import rcon.database.Database;
import rcon.event.AbandonReportHandler;
import rcon.event.AutomaticIdleHandler;
import rcon.event.BanEnforcerHandler;
import rcon.event.DatabaseSynchronizationHandler;
import rcon.event.KDNotificationHandler;
import rcon.event.StatsHandler;
import rcon.event.StreakHandler;
import rcon.event.WelcomeHandler;
import rcon.ingame.InGameHandler;
import rcon.ingame.ServerMessages;
import rcon.log.ChatLogHandler;
import rcon.players.Admin;
import rcon.players.Player;
import rcon.players.Right;
import rcon.players.ServerPlayer;
import rcon.server.GameServer;

public class RCONDaemon {
    static Logger logger = Logger.getLogger(RCONDaemon.class);
    private DaemonConfiguration config;
    private Database db;
    private GameServer server;
    private volatile boolean running;
    private ClientHandler clients;
    private long started;

    public long getStarted() {
        return this.started;
    }

    public RCONDaemon(DaemonConfiguration config) {
        this.config = config;
        this.db = null;
        this.server = null;
        this.running = false;
    }

    public boolean init() {
        try {
            this.db = new Database(this.config.getDaemonId(), this.config.getDatabaseDriver(), this.config.getDatabaseUrl(), this.config.getDatabaseUser(), this.config.getDatabasePassword());
            return true;
        }
        catch (SQLException e) {
            logger.error("Failed to establish database connection. ", e);
            return false;
        }
    }

    public void start() {
        this.running = true;
        this.started = Calendar.getInstance().getTimeInMillis() / 1000L;
        if (this.config.getClientsEnabled()) {
            this.clients = new ClientHandler(this, this.config.getClientsPort());
            this.clients.start();
        }
        do {
            this.server = null;
            try {
                this.server = new GameServer(this.config.getServerHost(), this.config.getServerPort(), this.config.getServerTimeout(), this.config.getServerConfig());
            }
            catch (IOException e) {
                logger.error("Failed to connect to game server.", e);
                this.server = null;
            }
            if (this.server != null) {
                int serverAdminId = this.config.getServerAdminId();
                System.out.println("Server admin id is " + serverAdminId + ".");
                if (serverAdminId != 0) {
                    ServerPlayer serverPlayer = new ServerPlayer("Server");
                    serverPlayer.setAdmin(new Admin(serverAdminId, "", "Server", "", EnumSet.allOf(Right.class)));
                    System.out.println("Set the server admin player!");
                    this.server.getOnline().setServerPlayer(serverPlayer);
                }
                if (this.server.login(this.config.getServerPassword()) && this.server.enableEvents()) {
                    try {
                        this.db.logs.event("Connected to game server at " + this.server.getHost() + ":" + this.server.getPort() + ".");
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    this.server.addHandler(new DatabaseSynchronizationHandler(this.db));
                    this.server.addHandler(new InGameHandler(this.server, this.db));
                    this.server.addHandler(new BanEnforcerHandler(this.server, this.db, this.config.getDateFormat(), this.config.getTimeZone(), this.config.getBannedMessage()));
                    this.server.addHandler(new ChatLogHandler(this.db));
                    this.server.addHandler(new StatsHandler(this.server, this.db));
                    this.server.addHandler(new AbandonReportHandler(this.db));
                    if (this.config.isKillStreaksEnabled()) {
                        int modulus = this.config.getStreakModulus();
                        int bigLimit = this.config.getStreakAwesomeLimit();
                        this.server.addHandler(new StreakHandler(this.server, modulus, bigLimit));
                    }
                    if (this.config.isAutoConfigEnabled()) {
                        this.server.addHandler(new AutomaticIdleHandler(this.server));
                    }
                    if (!this.config.getWelcomeMessage().trim().isEmpty()) {
                        this.server.addHandler(new WelcomeHandler(this.server, this.config.getWelcomeMessage()));
                    }
                    if (this.config.isKDNotificationsEnabled()) {
                        double kd = this.config.getKDRatio();
                        int minKills = this.config.getKDMinKills();
                        this.server.addHandler(new KDNotificationHandler(this.server, kd, minKills));
                    }
                    this.server.requestPlayerInfo();
                    this.server.updateInfo();
                    this.server.enablePlayerUpdates(this.config.getPlayerUpdateInterval());
                    this.server.requestPbPlayerList();
                    if (this.config.isHeartbeatsEnabled()) {
                        this.server.enableHeartbeats(this.config.getHeartbeatInterval());
                    }
                    if (this.config.isServerMessageEnabled()) {
                        ServerMessages messages = this.server.getServerMessages();
                        messages.setFile(this.config.getServerMessageFile());
                        try {
                            messages.load();
                        }
                        catch (IOException e) {
                            logger.error("Failed to load server messages.", e);
                        }
                        this.server.enableServerMessenger(this.config.getServerMessageInterval());
                    }
                }
                for (Player p : this.server.getOnline().getPlayers()) {
                    p.spawn();
                }
                this.server.awaitDisconnect();
                try {
                    this.db.logs.event("Lost connection to game server with " + this.server.getOnline().size() + " players online.");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.server = null;
            }
            if (!this.running || this.config.getServerReconnectDelay() == -1) continue;
            try {
                Thread.sleep(this.config.getServerReconnectDelay());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.running && this.config.getServerReconnectDelay() != -1);
        if (this.clients != null) {
            this.clients.close();
            this.clients = null;
        }
    }

    public GameServer getServer() {
        return this.server;
    }

    public Database getDatabase() {
        return this.db;
    }
}

