/*
 * Decompiled with CFR 0.152.
 */
package rcon;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import rcon.DaemonThreadFactory;

public class Scheduler {
    private static final int SHUTDOWN_GRACE = 1000;
    private static final int DEFAULT_POOL_SIZE = 16;
    public static final Scheduler instance = new Scheduler();
    private ScheduledExecutorService executor;

    public static Scheduler getInstance() {
        return instance;
    }

    private Scheduler() {
        this(16);
    }

    private Scheduler(int threads) {
        this.executor = Executors.newScheduledThreadPool(threads, new DaemonThreadFactory());
    }

    public void schedule(Runnable task, int delay) {
        this.executor.schedule(task, (long)delay, TimeUnit.MILLISECONDS);
    }

    public void repeat(Runnable task, int period) {
        this.executor.scheduleAtFixedRate(task, period, period, TimeUnit.MILLISECONDS);
    }

    public void execute(Runnable task) {
        this.executor.submit(task);
    }

    public void stop() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
    }
}

