/*
 * Decompiled with CFR 0.152.
 */
package rcon.client;

import java.io.IOException;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.Iterator;
import rcon.Hex;
import rcon.MessageType;
import rcon.RCONDaemon;
import rcon.client.AdminModule;
import rcon.client.BanModule;
import rcon.client.ClientCommand;
import rcon.client.ClientHandler;
import rcon.client.ConfigModule;
import rcon.client.LogModule;
import rcon.client.MessageModule;
import rcon.client.PlayerModule;
import rcon.client.PunkbusterModule;
import rcon.client.ReservedSlotsModule;
import rcon.commands.Command;
import rcon.net.RCONInputStream;
import rcon.net.RCONOutputStream;
import rcon.players.Admin;
import rcon.players.Right;
import rcon.server.GameServer;

public class ClientConnection
extends Thread {
    private static final int SEED_LENGTH = 16;
    private static SecureRandom random;
    private Socket socket;
    private Admin user;
    private byte[] salt;
    private RCONInputStream in;
    private RCONOutputStream out;
    private RCONDaemon daemon;
    private ClientHandler clients;
    private BanModule bans;
    private AdminModule admins;
    private ConfigModule config;
    private PlayerModule players;
    private PunkbusterModule punkbuster;
    private MessageModule messages;
    private LogModule logs;
    private ReservedSlotsModule reservedSlots;

    public ClientConnection(Socket socket, ClientHandler clients, RCONDaemon daemon) throws IOException {
        this.socket = socket;
        this.in = new RCONInputStream(socket.getInputStream());
        this.out = new RCONOutputStream(socket.getOutputStream());
        this.clients = clients;
        this.daemon = daemon;
        this.user = null;
        this.salt = null;
        this.bans = new BanModule(this.out, daemon);
        this.admins = new AdminModule(this.out, daemon);
        this.config = new ConfigModule(this.out, daemon);
        this.players = new PlayerModule(this.out, daemon);
        this.punkbuster = new PunkbusterModule(this.out, daemon);
        this.messages = new MessageModule(this.out, daemon);
        this.logs = new LogModule(this.out, daemon);
        this.reservedSlots = new ReservedSlotsModule(this.out, daemon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            block51: while (this.socket.isConnected()) {
                EnumSet<Right> rights;
                Command request = this.in.readCommand();
                ClientCommand command = ClientCommand.get(request.getName());
                EnumSet<Right> enumSet = rights = this.user == null ? EnumSet.noneOf(Right.class) : this.user.getRights();
                if (this.daemon.getServer() != null && command != null && command.hasRights(rights)) {
                    switch (command) {
                        case VERSION: {
                            this.parseVersion(this.user, request);
                            continue block51;
                        }
                        case QUIT: {
                            this.parseQuit(this.user, request);
                            continue block51;
                        }
                        case LOGIN_HASHED: {
                            this.parseLogin(this.user, request);
                            continue block51;
                        }
                        case LOGOUT: {
                            this.parseLogout(this.user, request);
                            continue block51;
                        }
                        case SHUTDOWN: {
                            this.parseShutdown(this.user, request);
                            continue block51;
                        }
                        case DAEMON_STATUS: {
                            this.daemonStatus(this.user, request);
                            continue block51;
                        }
                        case SERVER_STATUS: {
                            this.serverStatus(this.user, request);
                            continue block51;
                        }
                        case CONFIG_SET: {
                            this.config.set(this.user, request);
                            continue block51;
                        }
                        case CONFIG_GET: {
                            this.config.get(this.user, request);
                            continue block51;
                        }
                        case CONFIG_CLEAR: {
                            this.config.clear(this.user, request);
                            continue block51;
                        }
                        case CONFIG_LIST: {
                            this.config.list(this.user, request);
                            continue block51;
                        }
                        case CONFIG_ALL: {
                            this.config.all(this.user, request);
                            continue block51;
                        }
                        case BANS_LIST: {
                            this.bans.list(this.user, request);
                            continue block51;
                        }
                        case BANS_HISTORY: {
                            this.bans.history(this.user, request);
                            continue block51;
                        }
                        case BANS_REMOVE: {
                            this.bans.remove(this.user, request);
                            continue block51;
                        }
                        case BANS_BAN: {
                            this.bans.ban(this.user, request);
                            continue block51;
                        }
                        case BANS_KICK: {
                            this.bans.kick(this.user, request);
                            continue block51;
                        }
                        case BANS_EDIT: {
                            this.bans.edit(this.user, request);
                            continue block51;
                        }
                        case BANS_GET: {
                            this.bans.get(this.user, request);
                            continue block51;
                        }
                        case BANS_WARN: {
                            this.bans.warn(this.user, request);
                            continue block51;
                        }
                        case ADMINS_SET_RIGHTS: {
                            this.admins.setRights(this.user, request);
                            continue block51;
                        }
                        case ADMINS_GET: {
                            this.admins.get(this.user, request);
                            continue block51;
                        }
                        case ADMINS_SET_PASSWORD: {
                            this.admins.setPassword(this.user, request);
                            continue block51;
                        }
                        case ADMINS_REGISTER: {
                            this.admins.register(this.user, request);
                            continue block51;
                        }
                        case ADMINS_EDIT: {
                            this.admins.edit(this.user, request);
                            continue block51;
                        }
                        case ADMINS_LIST: {
                            this.admins.list(this.user, request);
                            continue block51;
                        }
                        case PLAYERS_LIST: {
                            this.players.list(this.user, request);
                            continue block51;
                        }
                        case PLAYERS_SEARCH: {
                            this.players.search(this.user, request);
                            continue block51;
                        }
                        case PLAYERS_SAY: {
                            this.players.say(this.user, request);
                            continue block51;
                        }
                        case PLAYERS_YELL: {
                            this.players.yell(this.user, request);
                            continue block51;
                        }
                        case PUNKBUSTER_EXECUTE: {
                            this.punkbuster.execute(this.user, request);
                            continue block51;
                        }
                        case MESSAGES_LIST: {
                            this.messages.list(this.user, request);
                            continue block51;
                        }
                        case MESSAGES_ADD: {
                            this.messages.add(this.user, request);
                            continue block51;
                        }
                        case MESSAGES_EDIT: {
                            this.messages.edit(this.user, request);
                            continue block51;
                        }
                        case MESSAGES_REMOVE: {
                            this.messages.remove(this.user, request);
                            continue block51;
                        }
                        case LOGS_ADMIN: {
                            this.logs.admin(this.user, request);
                            continue block51;
                        }
                        case LOGS_CHAT: {
                            this.logs.chat(this.user, request);
                            continue block51;
                        }
                        case LOGS_EVENT: {
                            this.logs.event(this.user, request);
                            continue block51;
                        }
                        case RESERVEDSLOTS_LOAD: {
                            this.reservedSlots.load(this.user, request);
                            continue block51;
                        }
                        case RESERVEDSLOTS_SAVE: {
                            this.reservedSlots.save(this.user, request);
                            continue block51;
                        }
                        case RESERVEDSLOTS_LIST: {
                            this.reservedSlots.list(this.user, request);
                            continue block51;
                        }
                        case RESERVEDSLOTS_CLEAR: {
                            this.reservedSlots.clear(this.user, request);
                            continue block51;
                        }
                        case RESERVEDSLOTS_ADDPLAYER: {
                            this.reservedSlots.addPlayer(this.user, request);
                            continue block51;
                        }
                        case RESERVEDSLOTS_REMOVEPLAYER: {
                            this.reservedSlots.removePlayer(this.user, request);
                            continue block51;
                        }
                    }
                    this.reply(request, "InvalidCommand", new String[0]);
                    continue;
                }
                if (this.daemon.getServer() == null) {
                    this.reply(request, "NotConnected", new String[0]);
                    continue;
                }
                if (command == null) {
                    this.reply(request, "InvalidCommand", new String[0]);
                    continue;
                }
                this.reply(request, "NotAuthorized", new String[0]);
            }
            return;
        }
        catch (IOException e) {
            System.out.println("Client connection closed.");
            return;
        }
        finally {
            this.clients.onClientDisconnect(this);
        }
    }

    private void serverStatus(Admin user2, Command request) throws IOException {
        if (this.daemon.getServer() == null) {
            this.reply(request, "ServerOffline", new String[0]);
        } else {
            GameServer server = this.daemon.getServer();
            String host = server.getHost();
            String port = String.valueOf(server.getPort());
            String mode = server.getGameMode();
            String map = server.getMap();
            String online = String.valueOf(server.getOnline().size());
            String max = String.valueOf(server.getMaxPlayerCount());
            String round = String.valueOf(server.getRoundsPlayed());
            String rounds = String.valueOf(server.getRoundsTotal());
            this.reply(request, "OK", host, port, mode, map, online, max, round, rounds);
        }
    }

    private void daemonStatus(Admin user2, Command request) throws IOException {
        String start = String.valueOf(this.daemon.getStarted());
        String connect = "-1";
        if (this.daemon.getServer() != null) {
            connect = String.valueOf(this.daemon.getServer().getConnectionTime());
        }
        String clients = String.valueOf(this.clients.getClientCount());
        this.reply(request, "OK", start, connect, clients);
    }

    private void parseVersion(Admin user2, Command request) throws IOException {
        this.reply(request, "OK", "TGAC", "0.1");
    }

    private void parseLogin(Admin user2, Command request) throws IOException {
        if (request.size() == 0) {
            this.salt = new byte[16];
            random.nextBytes(this.salt);
            this.reply(request, "OK", Hex.toHex(this.salt));
        } else if (request.size() == 2) {
            if (this.salt == null) {
                this.reply(request, "MissingSalt", new String[0]);
            } else {
                String username = request.get(0);
                String passwordHashHex = request.get(1);
                try {
                    Admin user = this.daemon.getDatabase().admins.get(username);
                    if (user == null) {
                        this.reply(request, "InvalidLogin", new String[0]);
                    } else {
                        String realPasswordHashHex = Hex.hashPassword(user.getPassword(), Hex.toHex(this.salt));
                        if (passwordHashHex.equalsIgnoreCase(realPasswordHashHex)) {
                            if (user.hasRight(Right.console)) {
                                this.user = user;
                                EnumSet<Right> rights = user.getRights();
                                String[] arguments = new String[rights.size() + 1];
                                Iterator it = rights.iterator();
                                arguments[0] = String.valueOf(rights.size());
                                for (int i = 1; i <= rights.size(); ++i) {
                                    arguments[i] = ((Right)((Object)it.next())).name();
                                }
                                this.daemon.getDatabase().logs.admin(user, "Logged in on console.");
                                this.reply(request, "OK", arguments);
                            } else {
                                this.reply(request, "NotAuthorized", new String[0]);
                            }
                        } else {
                            this.reply(request, "InvalidLogin", new String[0]);
                        }
                    }
                }
                catch (SQLException e) {
                    this.reply(request, "ServerError", new String[0]);
                    e.printStackTrace();
                }
                this.salt = null;
            }
        } else {
            this.reply(request, "InvalidArguments", new String[0]);
            this.salt = null;
        }
    }

    private void parseLogout(Admin user2, Command request) throws IOException {
        this.user = null;
        this.reply(request, "OK", new String[0]);
    }

    private void parseQuit(Admin user2, Command request) throws IOException {
        this.reply(request, "OK", new String[0]);
        this.socket.close();
    }

    private void parseShutdown(Admin user2, Command request) throws IOException {
        this.reply(request, "OK", new String[0]);
        this.socket.close();
    }

    private void reply(Command request, String reply, String ... arguments) throws IOException {
        this.out.sendCommand(new Command(reply, MessageType.client_response, request.getSeq(), arguments));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
        }
        finally {
            try {
                this.join(1000L);
            }
            catch (InterruptedException e) {}
            if (this.isAlive()) {
                this.clients.onClientDisconnect(this);
            }
        }
    }

    static {
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

