/*
 * Decompiled with CFR 0.152.
 */
package rcon.client;

import java.io.IOException;
import java.sql.SQLException;
import rcon.MessageType;
import rcon.RCONDaemon;
import rcon.commands.Command;
import rcon.net.RCONOutputStream;
import rcon.players.Admin;

public abstract class CommandModule {
    protected RCONOutputStream out;
    protected RCONDaemon daemon;

    public CommandModule(RCONOutputStream out, RCONDaemon daemon) {
        this.out = out;
        this.daemon = daemon;
    }

    protected void reply(Command request, String reply, String ... arguments) throws IOException {
        this.out.sendCommand(new Command(reply, MessageType.client_response, request.getSeq(), arguments));
    }

    protected void log(Admin admin, String message) {
        try {
            this.daemon.getDatabase().logs.admin(admin, message);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

