/*
 * Decompiled with CFR 0.152.
 */
package rcon.client;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import rcon.RCONDaemon;
import rcon.client.CommandModule;
import rcon.commands.Command;
import rcon.net.RCONOutputStream;
import rcon.players.Admin;
import rcon.players.Player;
import rcon.server.GameServer;

public class PlayerModule
extends CommandModule {
    public PlayerModule(RCONOutputStream out, RCONDaemon daemon) {
        super(out, daemon);
    }

    public void list(Admin user, Command request) throws IOException {
        ArrayList<Player> players = this.daemon.getServer().getOnline().getPlayers();
        String[] args = new String[1 + players.size() * 6];
        args[0] = String.valueOf(players.size());
        int i = 1;
        for (Player p : players) {
            args[i++] = String.valueOf(p.getId());
            args[i++] = p.getName();
            args[i++] = p.getEaGuid();
            args[i++] = p.getPbGuid();
            args[i++] = p.getIp();
            args[i++] = p.isAdmin() ? String.valueOf(p.getAdmin().getId()) : "0";
        }
        this.reply(request, "OK", args);
    }

    public void search(Admin user, Command request) throws IOException {
        block8: {
            if (request.size() == 4) {
                try {
                    String method = request.get(0);
                    String string = request.get(1);
                    int offset = request.getInt(2);
                    int limit = request.getInt(3);
                    if (limit > 100) {
                        this.reply(request, "InvalidArguments", new String[0]);
                        break block8;
                    }
                    if (method.equals("partial")) {
                        ArrayList<Player> players = this.daemon.getDatabase().players.find(string, offset, limit);
                        String[] args = new String[1 + players.size() * 5];
                        args[0] = String.valueOf(players.size());
                        int i = 1;
                        for (Player p : players) {
                            args[i++] = String.valueOf(p.getId());
                            args[i++] = p.getName();
                            args[i++] = p.getEaGuid();
                            args[i++] = p.getPbGuid();
                            args[i++] = p.getIp();
                        }
                        this.reply(request, "OK", args);
                        break block8;
                    }
                    this.reply(request, "InvalidMethod", new String[0]);
                }
                catch (NumberFormatException e) {
                    this.reply(request, "InvalidArguments", new String[0]);
                }
                catch (SQLException e) {
                    this.reply(request, "ServerError", new String[0]);
                }
            } else {
                this.reply(request, "InvalidArguments", new String[0]);
            }
        }
    }

    public void yell(Admin user, Command request) throws IOException {
        if (request.size() >= 2) {
            String message = request.get(0);
            String targetType = request.get(1);
            GameServer server = this.daemon.getServer();
            if (targetType.equals("all") && request.size() == 2) {
                server.say(message);
                this.log(user, "Yelled '" + message + "' to everyone.");
                this.reply(request, "OK", new String[0]);
            } else if (targetType.equals("player") && request.size() == 3) {
                String target = request.get(2);
                Player p = server.getOnline().getByName(target);
                if (p != null) {
                    server.say(message, p);
                    this.log(user, "Yelled '" + message + "' to '" + target + "'.");
                    this.reply(request, "OK", new String[0]);
                } else {
                    this.reply(request, "InvalidTarget", new String[0]);
                }
            } else {
                this.reply(request, "InvalidArguments", new String[0]);
            }
        } else {
            this.reply(request, "InvalidArguments", new String[0]);
        }
    }

    public void say(Admin user, Command request) throws IOException {
        if (request.size() >= 2) {
            String message = request.get(0);
            String targetType = request.get(1);
            GameServer server = this.daemon.getServer();
            if (targetType.equals("all") && request.size() == 2) {
                server.say(message);
                this.log(user, "Said '" + message + "' to everyone.");
                this.reply(request, "OK", new String[0]);
            } else if (targetType.equals("player") && request.size() == 3) {
                String target = request.get(2);
                Player p = server.getOnline().getByName(target);
                if (p != null) {
                    server.say(message, p);
                    this.log(user, "Said '" + message + "' to '" + target + "'.");
                    this.reply(request, "OK", new String[0]);
                } else {
                    this.reply(request, "InvalidTarget", new String[0]);
                }
            } else {
                this.reply(request, "InvalidArguments", new String[0]);
            }
        } else {
            this.reply(request, "InvalidArguments", new String[0]);
        }
    }
}

