/*
 * Decompiled with CFR 0.152.
 */
package rcon.client;

import java.io.IOException;
import java.util.List;
import rcon.RCONDaemon;
import rcon.client.CommandModule;
import rcon.commands.Command;
import rcon.net.RCONOutputStream;
import rcon.players.Admin;

public class ReservedSlotsModule
extends CommandModule {
    public ReservedSlotsModule(RCONOutputStream out, RCONDaemon daemon) {
        super(out, daemon);
    }

    public void load(Admin user, Command request) throws IOException {
        boolean ret = this.daemon.getServer().loadReservedSlots();
        if (ret) {
            this.reply(request, "OK", new String[0]);
            this.log(user, "Loaded reserved slots.");
        } else {
            this.reply(request, "ServerError", new String[0]);
        }
    }

    public void save(Admin user, Command request) throws IOException {
        boolean ret = this.daemon.getServer().saveReservedSlots();
        if (ret) {
            this.reply(request, "OK", new String[0]);
            this.log(user, "Saved reserved slots.");
        } else {
            this.reply(request, "ServerError", new String[0]);
        }
    }

    public void list(Admin user, Command request) throws IOException {
        List<String> slots = this.daemon.getServer().getReservedSlots();
        if (slots == null) {
            this.reply(request, "ServerError", new String[0]);
        } else {
            slots.add(0, String.valueOf(slots.size()));
            this.reply(request, "OK", slots.toArray(new String[0]));
        }
    }

    public void clear(Admin user, Command request) throws IOException {
        boolean ret = this.daemon.getServer().clearReservedSlots();
        if (ret) {
            this.reply(request, "OK", new String[0]);
            this.log(user, "Cleared reserved slots.");
        } else {
            this.reply(request, "ServerError", new String[0]);
        }
    }

    public void addPlayer(Admin user, Command request) throws IOException {
        if (request.size() == 1) {
            String name = request.get(0);
            boolean ret = this.daemon.getServer().addReservedSlot(name);
            if (ret) {
                this.reply(request, "OK", new String[0]);
                this.log(user, "Added reserved slot for " + name + ".");
            } else {
                this.reply(request, "InvalidReservedSlot", new String[0]);
            }
        } else {
            this.reply(request, "InvalidArguments", new String[0]);
        }
    }

    public void removePlayer(Admin user, Command request) throws IOException {
        if (request.size() == 1) {
            String name = request.get(0);
            boolean ret = this.daemon.getServer().removeReservedSlot(name);
            if (ret) {
                this.reply(request, "OK", new String[0]);
                this.log(user, "Removed reserved slot for " + name + ".");
            } else {
                this.reply(request, "InvalidReservedSlot", new String[0]);
            }
        } else {
            this.reply(request, "InvalidArguments", new String[0]);
        }
    }
}

