/*
 * Decompiled with CFR 0.152.
 */
package rcon.client.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import rcon.Hex;
import rcon.commands.ClientRequest;
import rcon.commands.Command;
import rcon.net.RCONInputStream;
import rcon.net.RCONOutputStream;

public class Main {
    private static RCONInputStream in;
    private static RCONOutputStream out;
    private static int seq;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Wrong argument count. Expected syntax: ");
            System.out.println("client hostname port");
            System.exit(1);
        }
        try {
            Socket socket = new Socket(args[0], Integer.parseInt(args[1]));
            in = new RCONInputStream(socket.getInputStream());
            out = new RCONOutputStream(socket.getOutputStream());
            BufferedReader rin = new BufferedReader(new InputStreamReader(System.in));
            String line = rin.readLine();
            while (line != null) {
                Command request = Main.parseCommand(line);
                request.setSeq(seq++);
                if (request.is("login")) {
                    String password;
                    String username = request.getArguments()[0];
                    if (Main.login(username, password = request.getArguments()[1])) {
                        System.out.println("Successfully logged in.");
                    } else {
                        System.out.println("Login failed.");
                    }
                } else {
                    System.out.println(request.toString());
                    out.sendCommand(request);
                    Command reply = in.readCommand();
                    System.out.println(reply.toString());
                    if (request.is("quit")) {
                        socket.close();
                        break;
                    }
                }
                line = rin.readLine();
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid port number.");
            System.exit(1);
        }
        catch (UnknownHostException e) {
            System.out.println("Unknown host." + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static boolean login(String username, String password) throws IOException {
        ClientRequest command = new ClientRequest("login.hashed", new String[0]);
        command.setSeq(seq++);
        out.sendCommand(command);
        Command result = in.readCommand();
        if (result.is("OK")) {
            String salt = result.getArguments()[0];
            String hexHash = Hex.hashPassword(password, salt);
            out.sendCommand(new ClientRequest("login.hashed", username, hexHash));
            result = in.readCommand();
            if (result.is("OK")) {
                return true;
            }
        }
        return false;
    }

    private static Command parseCommand(String text) {
        String whitespaces = " \t\n\r\f";
        String quote = "\"";
        StringTokenizer tokens = new StringTokenizer(text, quote + whitespaces, true);
        if (!tokens.hasMoreTokens()) {
            return null;
        }
        String name = tokens.nextToken();
        ArrayList<String> arguments = new ArrayList<String>();
        String argument = null;
        boolean quoted = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.equals(quote)) {
                if (quoted) {
                    arguments.add(argument);
                } else {
                    argument = "";
                }
                quoted = !quoted;
                continue;
            }
            if (quoted) {
                argument = argument + token;
                continue;
            }
            if (whitespaces.contains(token)) continue;
            arguments.add(token);
        }
        String[] stringArguments = new String[arguments.size()];
        ClientRequest command = new ClientRequest(name, arguments.toArray(stringArguments));
        return command;
    }

    static {
        seq = 1;
    }
}

