/*
 * Decompiled with CFR 0.152.
 */
package rcon.client.swing.admin;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import java.util.EnumSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import rcon.players.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RightsDialog
extends JDialog
implements ActionListener {
    private EnumMap<Right, JCheckBox> data = new EnumMap(Right.class);
    private boolean submitted = false;
    private JButton apply;
    private JButton cancel;

    public RightsDialog(EnumSet<Right> rights) {
        super((Dialog)null, "Manage rights", true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        for (Right r : Right.values()) {
            JCheckBox checkBox = new JCheckBox(r.name(), rights.contains((Object)r));
            this.data.put(r, checkBox);
            panel.add(checkBox);
        }
        this.add(new JScrollPane(panel));
        JPanel buttonPanel = new JPanel();
        this.add(buttonPanel);
        this.apply = new JButton("Apply");
        buttonPanel.add(this.apply);
        this.cancel = new JButton("Cancel");
        buttonPanel.add(this.cancel);
        this.apply.addActionListener(this);
        this.cancel.addActionListener(this);
        this.pack();
    }

    public EnumSet<Right> getRights() {
        EnumSet<Right> rights = EnumSet.noneOf(Right.class);
        for (Right r : Right.values()) {
            if (!this.data.get((Object)r).isSelected()) continue;
            rights.add(r);
        }
        return rights;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.apply) {
            this.submitted = true;
            this.setVisible(false);
        } else if (e.getSource() == this.cancel) {
            this.submitted = false;
            this.setVisible(false);
        }
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.submitted = false;
        }
        super.setVisible(b);
    }
}

