/*
 * Decompiled with CFR 0.152.
 */
package rcon.event;

import rcon.event.RCONEventAdapter;
import rcon.players.Player;
import rcon.players.PlayerInfo;
import rcon.server.Configuration;
import rcon.server.GameServer;

public class AutomaticIdleHandler
extends RCONEventAdapter {
    private static final int LIMIT_FULL = 28;
    private static final int LIMIT_EMPTY = 16;
    private static final int TIMEOUT_FULL = 600;
    private static final int TIMEOUT_EMPTY = 0;
    private GameServer server;

    public AutomaticIdleHandler(GameServer server) {
        this.server = server;
    }

    public void onJoin(Player player, String eaGuid) {
        this.update();
    }

    public void onLeave(Player player, PlayerInfo info) {
        this.update();
    }

    private void update() {
        int n = this.server.getOnline().size();
        String timeoutString = this.server.getConfiguration().get(Configuration.Variable.idleTimeout);
        try {
            int timeout = Integer.parseInt(timeoutString);
            if (n >= 28 && timeout != 600) {
                this.setTimeout(600);
            } else if (n <= 16 && timeout != 0) {
                this.setTimeout(0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void setTimeout(int timeout) {
        this.server.setVariable("vars.idleTimeout", String.valueOf(timeout));
        this.server.getConfiguration().update(Configuration.Variable.idleTimeout, String.valueOf(timeout));
    }
}

