/*
 * Decompiled with CFR 0.152.
 */
package rcon.event;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import rcon.database.Database;
import rcon.event.RCONEventAdapter;
import rcon.players.Player;
import rcon.players.PlayerInfo;

public class DatabaseSynchronizationHandler
extends RCONEventAdapter {
    static Logger logger = Logger.getLogger(DatabaseSynchronizationHandler.class);
    private Database db;

    public DatabaseSynchronizationHandler(Database db) {
        this.db = db;
    }

    public void onPbInfo(Player player, String guid, String ip) {
        this.sync(player);
    }

    public void onAuthenticated(Player player) {
        this.sync(player);
    }

    public void onJoin(Player player, String eaGuid) {
        this.sync(player);
    }

    public void onPlayerInfo(Player player, PlayerInfo oldInfo, PlayerInfo info) {
        if (!oldInfo.getEaGuid().equals(info.getEaGuid())) {
            this.sync(player);
        }
    }

    private void sync(Player player) {
        try {
            this.db.players.update(player);
        }
        catch (SQLException e) {
            logger.error("Failed to synchronized player with database.", e);
        }
    }
}

