/*
 * Decompiled with CFR 0.152.
 */
package rcon.event;

import java.util.HashSet;
import rcon.event.RCONEventAdapter;
import rcon.players.Player;
import rcon.server.GameServer;

public class KDNotificationHandler
extends RCONEventAdapter {
    private GameServer server;
    private double kd;
    private int minKills;
    private HashSet<String> cache;

    public KDNotificationHandler(GameServer server, double kd, int minKills) {
        this.server = server;
        this.kd = kd;
        this.minKills = minKills;
        this.cache = new HashSet();
    }

    public void onKill(Player killer, Player killed, String weapon, boolean headshot) {
        double currentKd;
        int kills = killer.getInfo().getKills() + 1;
        int deaths = killer.getInfo().getDeaths();
        double d = currentKd = deaths == 0 ? (double)kills : (double)kills / (double)deaths;
        if (kills >= this.minKills && currentKd >= this.kd && !this.cache.contains(killer.getName())) {
            for (Player admin : this.server.getOnline().getAdmins()) {
                this.server.say("Player " + killer.getName() + " has a K/D ratio of " + kills + "/" + deaths + ".", admin);
            }
            this.cache.add(killer.getName());
        }
    }

    public void onLevelStarted() {
        this.cache.clear();
    }
}

